/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Component;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Issue;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueType;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Priority;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Project;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Resolution;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Status;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.User;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Version;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Vote;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceFields
extends RestFuncTest {
    private IssueClient issueClient;

    public void testExpandos() throws Exception {
        this.administration.restoreData("TestIssueResourceFields.xml");
        Issue json = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        TestIssueResourceFields.assertTrue((boolean)json.expand.equals("html"));
        TestIssueResourceFields.assertNull((Object)json.html);
        Issue expanded = this.issueClient.get("HSP-1", Issue.Expand.html);
        TestIssueResourceFields.assertEquals((int)4, (int)expanded.html.length());
        TestIssueResourceFields.assertNotNull((Object)expanded.html.environment);
        TestIssueResourceFields.assertNotNull((Object)expanded.html.description);
        TestIssueResourceFields.assertEquals((int)1, (int)expanded.html.comment.size());
        TestIssueResourceFields.assertEquals((int)1, (int)expanded.html.worklog.size());
    }

    public void testSystemFields() throws Exception {
        this.administration.restoreData("TestIssueResourceFields.xml");
        Issue json = this.issueClient.get("HSP-1", Issue.Expand.html);
        TestIssueResourceFields.assertEquals((String)"HSP-1", (String)json.key);
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-1"), (String)json.self);
        TestIssueResourceFields.assertNotNull((Object)json.fields);
        TestIssueResourceFields.assertNotNull((Object)json.transitions);
        TestIssueResourceFields.assertNotNull((Object)json.html);
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-1/transitions"), (String)json.transitions);
        Issue.Fields fields = json.fields;
        TestIssueResourceFields.assertNotNull(fields.summary);
        TestIssueResourceFields.assertEquals((String)"Donec posuere tellus nulla; vitae pellentesque.", (String)((String)fields.summary.value));
        Vote votes = (Vote)fields.votes.value;
        TestIssueResourceFields.assertEquals((int)0, (int)votes.votes);
        TestIssueResourceFields.assertEquals((boolean)false, (boolean)votes.hasVoted);
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-1/votes"), (String)votes.self);
        TestIssueResourceFields.assertNotNull(fields.security);
        TestIssueResourceFields.assertEquals((String)"Insecure", (String)((String)fields.security.value));
        TestIssueResourceFields.assertNotNull(fields.resolutiondate);
        this.assertEqualDateStrings("2010-06-11T12:19:10.488+1000", (String)fields.resolutiondate.value);
        TestIssueResourceFields.assertNotNull(fields.environment);
        TestIssueResourceFields.assertEquals((String)"Curabitur bibendum molestie eros vel pretium.<br/>\n", (String)json.html.environment);
        TestIssueResourceFields.assertNotNull(fields.updated);
        this.assertEqualDateStrings("2010-06-11T12:25:16.265+1000", (String)fields.updated.value);
        TestIssueResourceFields.assertNotNull(fields.created);
        this.assertEqualDateStrings("2010-06-11T12:17:45.383+1000", (String)fields.created.value);
        TestIssueResourceFields.assertNotNull(fields.description);
        TestIssueResourceFields.assertEquals((String)"Suspendisse a mi augue. Donec quis.<br/>\n", (String)json.html.description);
        TestIssueResourceFields.assertNotNull(fields.duedate);
        TestIssueResourceFields.assertEquals((String)"2010-06-23", (String)((String)fields.duedate.value));
        this.checkLabels(fields);
        TestIssueResourceFields.assertNotNull(fields.timetracking);
        this.checkIssueType(fields);
        this.checkStatus(fields);
        this.checkAssignee(fields);
        this.checkReporter(fields);
        this.checkResolution(fields);
        this.checkProject(fields);
        this.checkPriority(fields);
        this.checkComponents(fields);
        this.checkFixVersions(fields);
        this.checkVersions(fields);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient(this.getEnvironmentData());
    }

    private void checkFixVersions(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull(fields.fixVersions);
        List versions = (List)fields.fixVersions.value;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/version/10000"), (String)((Version)versions.get((int)0)).self);
        TestIssueResourceFields.assertEquals((String)"Test Version Description 1", (String)((Version)versions.get((int)0)).description);
        TestIssueResourceFields.assertEquals((String)"New Version 1", (String)((Version)versions.get((int)0)).name);
        TestIssueResourceFields.assertFalse((boolean)((Version)versions.get((int)0)).archived);
        TestIssueResourceFields.assertFalse((boolean)((Version)versions.get((int)0)).released);
        TestIssueResourceFields.assertEquals((String)this.getRestApiUrl("version/10002"), (String)((Version)versions.get((int)1)).self);
        TestIssueResourceFields.assertEquals((String)"Test Version Description 5", (String)((Version)versions.get((int)1)).description);
        TestIssueResourceFields.assertEquals((String)"New Version 5", (String)((Version)versions.get((int)1)).name);
        TestIssueResourceFields.assertFalse((boolean)((Version)versions.get((int)1)).archived);
        TestIssueResourceFields.assertFalse((boolean)((Version)versions.get((int)1)).released);
    }

    private void checkVersions(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull(fields.versions);
        List versions = (List)fields.versions.value;
        TestIssueResourceFields.assertEquals((String)this.getRestApiUrl("version/10000"), (String)((Version)versions.get((int)0)).self);
        TestIssueResourceFields.assertEquals((String)"Test Version Description 1", (String)((Version)versions.get((int)0)).description);
        TestIssueResourceFields.assertEquals((String)"New Version 1", (String)((Version)versions.get((int)0)).name);
        TestIssueResourceFields.assertFalse((boolean)((Version)versions.get((int)0)).archived);
        TestIssueResourceFields.assertFalse((boolean)((Version)versions.get((int)0)).released);
        TestIssueResourceFields.assertEquals((String)this.getRestApiUrl("version/10002"), (String)((Version)versions.get((int)1)).self);
        TestIssueResourceFields.assertEquals((String)"Test Version Description 5", (String)((Version)versions.get((int)1)).description);
        TestIssueResourceFields.assertEquals((String)"New Version 5", (String)((Version)versions.get((int)1)).name);
        TestIssueResourceFields.assertFalse((boolean)((Version)versions.get((int)1)).archived);
        TestIssueResourceFields.assertFalse((boolean)((Version)versions.get((int)1)).released);
    }

    private void checkComponents(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull(fields.components);
        List components = (List)fields.components.value;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/component/10001"), (String)((Component)components.get((int)0)).self);
        TestIssueResourceFields.assertEquals((String)"New Component 2", (String)((Component)components.get((int)0)).name);
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/component/10002"), (String)((Component)components.get((int)1)).self);
        TestIssueResourceFields.assertEquals((String)"New Component 3", (String)((Component)components.get((int)1)).name);
    }

    private void checkPriority(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull(fields.priority);
        Priority priority = (Priority)fields.priority.value;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/priority/3"), (String)priority.self);
        TestIssueResourceFields.assertEquals((String)"Major", (String)priority.name);
    }

    private void checkProject(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull(fields.project);
        Project project = (Project)fields.project.value;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/project/HSP"), (String)project.self);
        TestIssueResourceFields.assertEquals((String)"HSP", (String)project.key);
    }

    private void checkResolution(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull(fields.resolution);
        Resolution resolution = (Resolution)fields.resolution.value;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/resolution/1"), (String)resolution.self);
        TestIssueResourceFields.assertEquals((String)"Fixed", (String)resolution.name);
    }

    private void checkAssignee(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull(fields.assignee);
        User user = (User)fields.assignee.value;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/user?username=admin"), (String)user.self);
        TestIssueResourceFields.assertEquals((String)"admin", (String)user.name);
        TestIssueResourceFields.assertEquals((String)"Administrator", (String)user.displayName);
    }

    private void checkReporter(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull(fields.reporter);
        User user = (User)fields.reporter.value;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/user?username=admin"), (String)user.self);
        TestIssueResourceFields.assertEquals((String)"admin", (String)user.name);
        TestIssueResourceFields.assertEquals((String)"Administrator", (String)user.displayName);
    }

    private void checkStatus(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull(fields.status);
        Status status = (Status)fields.status.value;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/status/5"), (String)status.self);
        TestIssueResourceFields.assertEquals((String)"Resolved", (String)status.name);
    }

    private void checkIssueType(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull(fields.issuetype);
        IssueType issueType = (IssueType)fields.issuetype.value;
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issueType/1"), (String)issueType.self);
        TestIssueResourceFields.assertEquals((String)"Bug", (String)issueType.name);
        TestIssueResourceFields.assertFalse((boolean)issueType.subtask);
    }

    private void checkLabels(Issue.Fields fields) {
        TestIssueResourceFields.assertNotNull(fields.labels);
        List labels = (List)fields.labels.value;
        TestIssueResourceFields.assertEquals((int)3, (int)labels.size());
        TestIssueResourceFields.assertEquals((String)"bad", (String)((String)labels.get(0)));
        TestIssueResourceFields.assertEquals((String)"big", (String)((String)labels.get(1)));
        TestIssueResourceFields.assertEquals((String)"wolf", (String)((String)labels.get(2)));
    }
}

