/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Attachment;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Issue;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueClient;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceAttachments
extends RestFuncTest {
    private static final String ISSUE_KEY = "MKY-1";
    private IssueClient issueClient;

    public void testAttachmentsExpanded() throws Exception {
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        TestIssueResourceAttachments.assertEquals((String)ISSUE_KEY, (String)issue.key);
        TestIssueResourceAttachments.assertEquals((int)2, (int)((List)issue.fields.attachment.value).size());
        Attachment attachment1 = (Attachment)((List)issue.fields.attachment.value).get(0);
        TestIssueResourceAttachments.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/attachment/10000"), (String)attachment1.self);
        TestIssueResourceAttachments.assertEquals((String)"attachment.txt", (String)attachment1.filename);
        TestIssueResourceAttachments.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/user?username=admin"), (String)attachment1.author.self);
        TestIssueResourceAttachments.assertEquals((String)"admin", (String)attachment1.author.name);
        TestIssueResourceAttachments.assertEquals((String)"Administrator", (String)attachment1.author.displayName);
        this.assertEqualDateStrings("2010-06-09T15:59:34.602+1000", attachment1.created);
        TestIssueResourceAttachments.assertEquals((long)19L, (long)attachment1.size);
        TestIssueResourceAttachments.assertEquals((String)"text/plain", (String)attachment1.mimeType);
        TestIssueResourceAttachments.assertEquals((String)(this.getBaseUrl() + "/secure/attachment/10000/attachment.txt"), (String)attachment1.content);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient(this.getEnvironmentData());
        this.administration.restoreData("TestIssueResourceAttachments.xml");
    }
}

