/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Component;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ComponentClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ComponentIssueCounts;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Errors;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.SearchClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.SearchRequest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.SearchResult;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.User;
import java.net.URI;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestComponentResource
extends RestFuncTest {
    private ComponentClient componentClient;
    private SearchClient searchClient;

    public void testViewComponent() throws Exception {
        Component component = this.componentClient.get("10000");
        TestComponentResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/component/10000"), (String)component.self);
        TestComponentResource.assertEquals((String)"New Component 1", (String)component.name);
        TestComponentResource.assertNull((Object)component.lead);
    }

    public void testViewComponentNotFound() throws Exception {
        Response response123 = this.componentClient.getResponse("123");
        TestComponentResource.assertEquals((int)404, (int)response123.statusCode);
        TestComponentResource.assertTrue((boolean)response123.entity.errorMessages.contains("The component with id 123 does not exist."));
        Response responseAbc = this.componentClient.getResponse("abc");
        TestComponentResource.assertEquals((int)404, (int)responseAbc.statusCode);
        TestComponentResource.assertTrue((boolean)responseAbc.entity.errorMessages.contains("The component with id abc does not exist."));
    }

    public void testCreateComponent() throws Exception {
        Component inputComponent = new Component().project("MKY").name("Sausages").description("Lamb and Rosemary").leadUserName("fred").assigneeType(Component.AssigneeType.COMPONENT_LEAD);
        Component newComponent = this.componentClient.get(this.componentClient.create((Component)inputComponent).id.toString());
        this.assertSameComponent(inputComponent, newComponent);
        inputComponent = new Component().project("MKY").name("Chops").description("Lamb short loin").assigneeType(Component.AssigneeType.PROJECT_DEFAULT);
        newComponent = this.componentClient.get(this.componentClient.create((Component)inputComponent).id.toString());
        this.assertSameComponent(inputComponent, newComponent);
        inputComponent = new Component().project("MKY").name("potatoes").leadUserName("fred").assigneeType(Component.AssigneeType.PROJECT_DEFAULT);
        newComponent = this.componentClient.get(this.componentClient.create((Component)inputComponent).id.toString());
        this.assertSameComponent(inputComponent, newComponent);
        inputComponent = new Component().project("MKY").name("onions");
        newComponent = this.componentClient.get(this.componentClient.create((Component)inputComponent).id.toString());
        Component expectedComponent = new Component().project("MKY").name("onions").assigneeType(Component.AssigneeType.PROJECT_DEFAULT);
        this.assertSameComponent(expectedComponent, newComponent);
    }

    public void testCreateComponentErrors() throws Exception {
        Response response = this.componentClient.createResponse(new Component());
        TestComponentResource.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.statusCode);
        TestComponentResource.assertEquals((Object)new Errors().addError("A project id must be specified for this operation."), (Object)response.entity);
        Component inputComponent = new Component().project("BAD").name("Sausages").description("Lamb and Rosemary").leadUserName("fred").assigneeType(Component.AssigneeType.COMPONENT_LEAD);
        response = this.componentClient.createResponse(inputComponent);
        TestComponentResource.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.statusCode);
        TestComponentResource.assertEquals((Object)new Errors().addError("No project could be found with key 'BAD'."), (Object)response.entity);
        inputComponent = new Component().project("MKY").id(10000L).description("Lamb and Rosemary").leadUserName("fred").assigneeType(Component.AssigneeType.COMPONENT_LEAD);
        response = this.componentClient.createResponse(inputComponent);
        TestComponentResource.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.statusCode);
        TestComponentResource.assertEquals((Object)new Errors().addError("name", "The component name specified is invalid - cannot be an empty string."), (Object)response.entity);
        inputComponent = new Component().project("MKY").id(10000L).name("Sausages").description("Lamb and Rosemary").leadUserName("fred").assigneeType(Component.AssigneeType.COMPONENT_LEAD);
        Component newComponent = this.componentClient.create(inputComponent);
        inputComponent = new Component().project("MKY").id(10000L).name("Sausages").description("Lamb and Rosemary").leadUserName("fred").assigneeType(Component.AssigneeType.COMPONENT_LEAD);
        response = this.componentClient.createResponse(inputComponent);
        TestComponentResource.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.statusCode);
        TestComponentResource.assertEquals((Object)new Errors().addError("name", "A component with the name Sausages already exists in this project."), (Object)response.entity);
        inputComponent = new Component().project("MKY").id(10000L).name("C1").description("Lamb and Rosemary").leadUserName("notfred").assigneeType(Component.AssigneeType.COMPONENT_LEAD);
        response = this.componentClient.createResponse(inputComponent);
        TestComponentResource.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.statusCode);
        TestComponentResource.assertEquals((Object)new Errors().addError("leadUserName", "The user notfred does not exist.").addError("componentLead", "The user notfred does not exist."), (Object)response.entity);
        inputComponent = new Component().project("MKY").id(10001L).name("Chops").description("Lamb short loin").assigneeType(Component.AssigneeType.PROJECT_DEFAULT);
        response = ((ComponentClient)this.componentClient.loginAs("fred")).createResponse(inputComponent);
        TestComponentResource.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response.statusCode);
        TestComponentResource.assertEquals((Object)new Errors().addError("You cannot edit the configuration of this project."), (Object)response.entity);
    }

    public void testEditComponent() throws Exception {
        Component expectedComponent = this.getInitialComponent();
        Component inputComponent = new Component().name("Sausages").description("Lamb and Rosemary").leadUserName("fred").assigneeType(Component.AssigneeType.COMPONENT_LEAD).self(expectedComponent.self);
        expectedComponent.name("Sausages").description("Lamb and Rosemary").leadUserName("fred").assigneeType(Component.AssigneeType.COMPONENT_LEAD);
        this.verifyEdit(expectedComponent, inputComponent);
        inputComponent = new Component().name("Hamburger").self(expectedComponent.self);
        expectedComponent.name("Hamburger");
        this.verifyEdit(expectedComponent, inputComponent);
        inputComponent = new Component().description("Beef mince to you and me").self(expectedComponent.self);
        expectedComponent.description("Beef mince to you and me");
        this.verifyEdit(expectedComponent, inputComponent);
        inputComponent = new Component().assigneeType(Component.AssigneeType.COMPONENT_LEAD).self(expectedComponent.self);
        expectedComponent.assigneeType(Component.AssigneeType.COMPONENT_LEAD);
        this.verifyEdit(expectedComponent, inputComponent);
        inputComponent = new Component().assigneeType(Component.AssigneeType.UNASSIGNED).self(expectedComponent.self);
        expectedComponent.assigneeType(Component.AssigneeType.UNASSIGNED);
        this.verifyEdit(expectedComponent, inputComponent);
        inputComponent = new Component().leadUserName("admin").self(expectedComponent.self);
        expectedComponent.leadUserName("admin");
        this.verifyEdit(expectedComponent, inputComponent);
        inputComponent = new Component().leadUserName("").self(expectedComponent.self);
        expectedComponent.leadUserName(null);
        expectedComponent.lead(null);
        this.verifyEdit(expectedComponent, inputComponent);
    }

    public void testEditComponentErrors() throws Exception {
        Component expectedComponent = this.getInitialComponent();
        Component editComponent = new Component().name("New Component 2").self(expectedComponent.self);
        Response response = this.componentClient.putResponse(editComponent);
        TestComponentResource.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.statusCode);
        TestComponentResource.assertEquals((Object)new Errors().addError("name", "A component with the name New Component 2 already exists in this project."), (Object)response.entity);
        editComponent = new Component().name("").self(expectedComponent.self);
        response = this.componentClient.putResponse(editComponent);
        TestComponentResource.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.statusCode);
        TestComponentResource.assertEquals((Object)new Errors().addError("name", "The component name specified is invalid - cannot be an empty string."), (Object)response.entity);
        editComponent = new Component().leadUserName("notfred").self(expectedComponent.self);
        response = this.componentClient.putResponse(editComponent);
        TestComponentResource.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.statusCode);
        TestComponentResource.assertEquals((Object)new Errors().addError("leadUserName", "The user notfred does not exist.").addError("componentLead", "The user notfred does not exist."), (Object)response.entity);
        editComponent = new Component().name("Not authorised").self(expectedComponent.self);
        response = ((ComponentClient)this.componentClient.loginAs("fred")).putResponse(editComponent);
        TestComponentResource.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response.statusCode);
        TestComponentResource.assertEquals((Object)new Errors().addError("The user fred does not have permission to complete this operation."), (Object)response.entity);
    }

    private void verifyEdit(Component expectedComponent, Component editComponent) {
        this.componentClient.putResponse(editComponent);
        this.assertSameComponent(expectedComponent, this.componentClient.get(expectedComponent.id.toString()));
    }

    private Component getInitialComponent() {
        String componentID = "10000";
        Component actualComponent = this.componentClient.get("10000");
        Component expectedComponent = new Component().self(this.createSelfLink(Long.valueOf("10000"))).id(10000L).name("New Component 1").assigneeType(Component.AssigneeType.PROJECT_DEFAULT).assignee(this.createUserAdmin()).realAssigneeType(Component.AssigneeType.PROJECT_DEFAULT).realAssignee(this.createUserAdmin()).isAssigneeTypeValid(true);
        TestComponentResource.assertEquals((Object)expectedComponent, (Object)actualComponent);
        return actualComponent;
    }

    private User createUserAdmin() {
        return new User().self(this.createUserUri("admin")).name("admin").displayName("Administrator").active(true);
    }

    private URI createUserUri(String name) {
        return this.getRestApiUri(String.format("user?username=%s", name));
    }

    private URI createSelfLink(long id) {
        return this.getRestApiUri("component", String.valueOf(id));
    }

    public void testGetComponentIssueCounts() throws Exception {
        ComponentIssueCounts counts = this.componentClient.getComponentIssueCounts("10000");
        TestComponentResource.assertEquals((long)0L, (long)counts.issueCount);
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Issue for voting test");
        this.navigation.issue().setComponents(issueKey, "New Component 1");
        counts = this.componentClient.getComponentIssueCounts("10000");
        TestComponentResource.assertEquals((long)1L, (long)counts.issueCount);
        issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Issue for voting test");
        this.navigation.issue().setComponents(issueKey, "New Component 2");
        counts = this.componentClient.getComponentIssueCounts("10000");
        TestComponentResource.assertEquals((long)1L, (long)counts.issueCount);
        counts = this.componentClient.getComponentIssueCounts("10001");
        TestComponentResource.assertEquals((long)1L, (long)counts.issueCount);
        issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Issue for voting test");
        this.navigation.issue().setComponents(issueKey, "New Component 2");
        counts = this.componentClient.getComponentIssueCounts("10000");
        TestComponentResource.assertEquals((long)1L, (long)counts.issueCount);
        counts = this.componentClient.getComponentIssueCounts("10001");
        TestComponentResource.assertEquals((long)2L, (long)counts.issueCount);
        counts = ((ComponentClient)this.componentClient.loginAs("fred")).getComponentIssueCounts("10001");
        TestComponentResource.assertEquals((long)2L, (long)counts.issueCount);
    }

    public void testGetVersionIssueCountsNotFound() throws Exception {
        Response resp1 = this.componentClient.getComponentIssueCountsResponse("1");
        TestComponentResource.assertEquals((int)404, (int)resp1.statusCode);
        TestComponentResource.assertTrue((boolean)resp1.entity.errorMessages.contains("The component with id 1 does not exist."));
        Response respZbing = this.componentClient.getComponentIssueCountsResponse("zbing");
        TestComponentResource.assertEquals((int)404, (int)respZbing.statusCode);
        TestComponentResource.assertTrue((boolean)respZbing.entity.errorMessages.contains("The component with id zbing does not exist."));
    }

    public void testDeleteComponent() throws Exception {
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Issue for voting test");
        this.navigation.issue().setComponents(issueKey, "New Component 1");
        SearchResult searchResults = this.searchClient.postSearch(new SearchRequest().jql("component is empty"));
        Assert.assertThat((Object)searchResults.total, CoreMatchers.equalTo(0));
        Assert.assertThat((Object)searchResults.issues.size(), CoreMatchers.equalTo(0));
        this.componentClient.delete("10000");
        Response resp1 = this.componentClient.getResponse("10000");
        TestComponentResource.assertEquals((int)404, (int)resp1.statusCode);
        TestComponentResource.assertTrue((boolean)resp1.entity.errorMessages.contains("The component with id 10000 does not exist."));
        searchResults = this.searchClient.postSearch(new SearchRequest().jql("component is empty"));
        Assert.assertThat((Object)searchResults.total, CoreMatchers.equalTo(1));
        Assert.assertThat((Object)searchResults.issues.size(), CoreMatchers.equalTo(1));
        this.navigation.issue().setComponents(issueKey, "New Component 2");
        issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Issue for voting test");
        this.navigation.issue().setComponents(issueKey, "New Component 2");
        this.componentClient.delete("10001", this.createSelfLink(10002L));
        resp1 = this.componentClient.getResponse("10001");
        TestComponentResource.assertEquals((int)404, (int)resp1.statusCode);
        TestComponentResource.assertTrue((boolean)resp1.entity.errorMessages.contains("The component with id 10001 does not exist."));
        searchResults = this.searchClient.postSearch(new SearchRequest().jql("component = \"New Component 3\""));
        Assert.assertThat((Object)searchResults.total, CoreMatchers.equalTo(2));
        Assert.assertThat((Object)searchResults.issues.size(), CoreMatchers.equalTo(2));
    }

    private void assertSameComponent(Component expectedComponent, Component actualComponent) {
        TestComponentResource.assertNotNull((Object)actualComponent.id);
        TestComponentResource.assertNotNull((Object)actualComponent.self);
        TestComponentResource.assertEquals((String)expectedComponent.name, (String)actualComponent.name);
        TestComponentResource.assertEquals((String)expectedComponent.description, (String)actualComponent.description);
        TestComponentResource.assertEquals((Object)((Object)expectedComponent.assigneeType), (Object)((Object)actualComponent.assigneeType));
        String expectedlead = expectedComponent.lead != null ? expectedComponent.lead.name : expectedComponent.leadUserName;
        String actuallead = actualComponent.lead != null ? actualComponent.lead.name : actualComponent.leadUserName;
        TestComponentResource.assertEquals((String)expectedlead, (String)actuallead);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.componentClient = new ComponentClient(this.getEnvironmentData());
        this.searchClient = new SearchClient(this.getEnvironmentData());
        this.administration.restoreBlankInstance();
    }
}

