/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Comment;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.CommentClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpNotFoundException;
import com.meterware.httpunit.WebRequest;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestCommentResource
extends RestFuncTest {
    private CommentClient commentClient;

    public void testViewCommentNotFound() throws Exception {
        this.administration.restoreData("TestEditComment.xml");
        Response content1 = this.commentClient.getResponse("1");
        TestCommentResource.assertEquals((int)404, (int)content1.statusCode);
        TestCommentResource.assertEquals((int)1, (int)content1.entity.errorMessages.size());
        TestCommentResource.assertTrue((boolean)content1.entity.errorMessages.contains("Can not find a comment for the id: 1."));
        Response contentPiolho = this.commentClient.getResponse("piolho");
        TestCommentResource.assertEquals((int)404, (int)contentPiolho.statusCode);
        TestCommentResource.assertEquals((int)1, (int)contentPiolho.entity.errorMessages.size());
        TestCommentResource.assertTrue((boolean)contentPiolho.entity.errorMessages.contains("Can not find a comment for the id: piolho."));
    }

    public void testAnonymousComment() throws Exception {
        this.administration.restoreData("TestRESTAnonymous.xml");
        Comment comment = this.commentClient.get("10000");
        TestCommentResource.assertNull((Object)comment.author);
    }

    public void testAnonymous() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.PROJECT_ROLES);
        this.administration.roles().addProjectRoleForUser("monkey", "Administrators", "admin");
        String key = this.navigation.issue().createIssue("monkey", "Bug", "First Test Issue");
        this.navigation.issue().addComment(key, "comment", "Administrators");
        this.navigation.logout();
        try {
            String url = this.getEnvironmentData().getBaseUrl() + "/rest/api/2.0.alpha1/comment/10000";
            this.tester.getDialog().getWebClient().sendRequest((WebRequest)new GetMethodWebRequest(url));
            TestCommentResource.fail();
        }
        catch (HttpNotFoundException httpNotFoundException) {
            // empty catch block
        }
    }

    public void testCommentJson() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.PROJECT_ROLES);
        this.administration.roles().addProjectRoleForUser("monkey", "Administrators", "admin");
        String key = this.navigation.issue().createIssue("monkey", "Bug", "First Test Issue");
        this.navigation.issue().addComment(key, "comment", "Administrators");
        Comment json = this.commentClient.get("10000");
        TestCommentResource.assertNotNull((Object)json.created);
        TestCommentResource.assertNotNull((Object)json.updated);
        TestCommentResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2.0.alpha1/comment/10000"), (String)json.self);
        TestCommentResource.assertEquals((String)"comment", (String)json.body);
        TestCommentResource.assertEquals((String)"ROLE", (String)json.visibility.type);
        TestCommentResource.assertEquals((String)"Administrators", (String)json.visibility.value);
        TestCommentResource.assertEquals((String)"admin", (String)json.author.name);
        TestCommentResource.assertEquals((String)"Administrator", (String)json.author.displayName);
        TestCommentResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2.0.alpha1/user?username=admin"), (String)json.author.self);
        TestCommentResource.assertEquals((String)"admin", (String)json.updateAuthor.name);
        TestCommentResource.assertEquals((String)"Administrator", (String)json.updateAuthor.displayName);
        TestCommentResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2.0.alpha1/user?username=admin"), (String)json.updateAuthor.self);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.commentClient = new CommentClient(this.getEnvironmentData());
    }
}

