/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Attachment;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Issue;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueClient;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Logger;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestAttachTemporaryFileResource
extends FuncTestCase {
    private static final Logger log = Logger.getLogger(TestAttachTemporaryFileResource.class);
    private static final String REST_PATH = "rest/internal/1.0/AttachTemporaryFile";
    private static final String ATTACH_PATH = "secure/AttachFile.jspa";
    private static final String PARAM_FILENAME = "filename";
    private static final String PARAM_ISSUE_ID = "issueId";
    private static final String PARAM_ID = "id";
    private static final String PARAM_SIZE = "size";
    private static final String PARAM_CONVERT_ID = "filetoconvert";
    private static final String PARAM_DECORATOR = "decorator";
    private static final String PARAM_USERNAME = "os_username";
    private static final String PARAM_PASSWORD = "os_password";
    private static final String PARAM_COOKIE = "os_cookie";
    private static final String PARAM_XSRF = "atl_token";
    private static final String JSON_NAME = "name";
    private static final String JSON_ID = "id";
    private static final String JSON_ERROR_MSG = "errorMessage";
    private static final String HEADER_SERAPH_RESPONSE = "X-Seraph-LoginReason";
    private static final String COOKIE_XSRF = "atlassian.xsrf.token";
    private static final String GOOD_LOGIN = "OK";
    private static final String NONE = "none";
    private static final long ISSUE_ID = 10000L;
    private static final String ISSUE_KEY = "HSP-1";
    public static final String JSON_TOKEN = "token";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestAttachTemporaryFileResource.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoSizeRequest() throws Exception {
        HttpClient client = this.createClientForUser("admin");
        PostMethod method = new PostMethod(this.getRestUrlWithToken(client, PARAM_FILENAME, "text.txt", PARAM_ISSUE_ID, 1));
        method.setRequestEntity((RequestEntity)new RandomBytesEntity().setContentLength(-1).setActualLength(1));
        try {
            client.executeMethod((HttpMethod)method);
            this.assertBadResponse(400, (HttpMethod)method);
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTooBigRequest() throws Exception {
        HttpClient client = this.createClientForUser("admin");
        PostMethod method = new PostMethod(this.getRestUrlWithToken(client, PARAM_FILENAME, "test.data", PARAM_ISSUE_ID, 10000L, PARAM_SIZE, 10));
        method.setRequestEntity((RequestEntity)new RandomBytesEntity().setLength(20));
        try {
            client.executeMethod((HttpMethod)method);
            this.assertBadResponse(500, (HttpMethod)method);
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTooSmallRequest() throws Exception {
        HttpClient client = this.createClientForUser("admin");
        PostMethod method = new PostMethod(this.getRestUrlWithToken(client, PARAM_FILENAME, "test.data", PARAM_ISSUE_ID, 10000L, PARAM_SIZE, 40));
        method.setRequestEntity((RequestEntity)new RandomBytesEntity().setLength(20));
        try {
            client.executeMethod((HttpMethod)method);
            this.assertBadResponse(500, (HttpMethod)method);
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGoodRequest() throws Exception {
        String id;
        int response;
        HttpClient client = this.createClientForUser("admin");
        String expectedFile = "test.data";
        PostMethod method = new PostMethod(this.getRestUrlWithToken(client, PARAM_FILENAME, expectedFile, PARAM_ISSUE_ID, 10000L));
        RandomBytesEntity entity = new RandomBytesEntity().setLength(150);
        method.setRequestEntity((RequestEntity)entity);
        try {
            response = client.executeMethod((HttpMethod)method);
            TestAttachTemporaryFileResource.assertEquals((int)201, (int)response);
            JSONObject jsonObject = new JSONObject(method.getResponseBodyAsString());
            HashSet actualKeys = Sets.newHashSet(jsonObject.keys());
            TestAttachTemporaryFileResource.assertEquals((Object)Sets.newHashSet((Object[])new String[]{JSON_NAME, "id"}), (Object)actualKeys);
            TestAttachTemporaryFileResource.assertEquals((String)expectedFile, (String)jsonObject.getString(JSON_NAME));
            id = jsonObject.getString("id");
        }
        finally {
            method.releaseConnection();
        }
        method = new PostMethod(this.getUrl(ATTACH_PATH, new Object[0]));
        method.setParameter(PARAM_CONVERT_ID, String.valueOf(id));
        method.setParameter("id", String.valueOf(10000L));
        method.setParameter(PARAM_DECORATOR, NONE);
        method.setParameter(PARAM_XSRF, this.getToken(client));
        try {
            response = client.executeMethod((HttpMethod)method);
            if (response != 302) {
                TestAttachTemporaryFileResource.fail((String)String.format("Trying to add attachment but got status %s: %s.", HttpStatus.getStatusText((int)response), method.getResponseBodyAsString()));
            }
        }
        finally {
            method.releaseConnection();
        }
        IssueClient issueClient = new IssueClient(this.getEnvironmentData());
        Issue issue = issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        List attachments = (List)issue.fields.attachment.value;
        TestAttachTemporaryFileResource.assertEquals((int)1, (int)attachments.size());
        Attachment attachment = (Attachment)attachments.get(0);
        TestAttachTemporaryFileResource.assertEquals((String)expectedFile, (String)attachment.filename);
        GetMethod data = new GetMethod(attachment.content);
        try {
            TestAttachTemporaryFileResource.assertEquals((int)200, (int)client.executeMethod((HttpMethod)data));
            ByteArrayOutputStream expectedStream = new ByteArrayOutputStream();
            entity.writeRequest(expectedStream);
            this.assertStreams(new ByteArrayInputStream(expectedStream.toByteArray()), data.getResponseBodyAsStream());
        }
        finally {
            data.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttachmentsDisabled() throws IOException, JSONException {
        this.administration.attachments().disable();
        HttpClient client = this.createClientForUser("admin");
        String expectedFile = "test.data";
        PostMethod method = new PostMethod(this.getRestUrlWithToken(client, PARAM_FILENAME, expectedFile, PARAM_ISSUE_ID, 10000L));
        RandomBytesEntity entity = new RandomBytesEntity().setLength(150);
        method.setRequestEntity((RequestEntity)entity);
        try {
            client.executeMethod((HttpMethod)method);
            this.assertBadResponse(500, (HttpMethod)method);
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoAttachPermission() throws IOException, JSONException {
        this.administration.attachments().disable();
        HttpClient client = this.createClientForUser("fred");
        String expectedFile = "test.data";
        PostMethod method = new PostMethod(this.getRestUrlWithToken(client, PARAM_FILENAME, expectedFile, PARAM_ISSUE_ID, 10000L));
        RandomBytesEntity entity = new RandomBytesEntity().setLength(150);
        method.setRequestEntity((RequestEntity)entity);
        try {
            client.executeMethod((HttpMethod)method);
            this.assertBadResponse(500, (HttpMethod)method);
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadXsrfAttach() throws IOException, JSONException {
        this.administration.attachments().disable();
        HttpClient client = this.createClientForUser("fred");
        String expectedFile = "test.data";
        PostMethod method = new PostMethod(this.getRestUrl(PARAM_FILENAME, expectedFile, PARAM_ISSUE_ID, 10000L));
        RandomBytesEntity entity = new RandomBytesEntity().setLength(150);
        method.setRequestEntity((RequestEntity)entity);
        try {
            client.executeMethod((HttpMethod)method);
            this.assertXsrfResponse(500, (HttpMethod)method, client);
        }
        finally {
            method.releaseConnection();
        }
    }

    private void assertStreams(InputStream expected, InputStream actual) throws IOException {
        int expectedByte = expected.read();
        int actualByte = actual.read();
        int count = 0;
        while (expectedByte >= 0 && actualByte >= 0) {
            TestAttachTemporaryFileResource.assertEquals((String)String.format("Byte at position %d differers.%n", count), (int)expectedByte, (int)actualByte);
            expectedByte = expected.read();
            actualByte = actual.read();
            ++count;
        }
        if (expectedByte >= 0) {
            TestAttachTemporaryFileResource.fail((String)("Expected more input but actual had only " + count + " bytes."));
        } else if (actualByte >= 0) {
            TestAttachTemporaryFileResource.fail((String)("Expected less input as expected had only " + count + " bytes."));
        }
    }

    private void assertBadResponse(int expectedResponse, HttpMethod method) {
        JSONObject result = this.assertBadCommon(expectedResponse, method);
        TestAttachTemporaryFileResource.assertFalse((boolean)result.has(JSON_TOKEN));
    }

    private JSONObject assertBadCommon(int expectedResponse, HttpMethod method) {
        TestAttachTemporaryFileResource.assertEquals((int)expectedResponse, (int)method.getStatusCode());
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(method.getResponseBodyAsString());
            TestAttachTemporaryFileResource.assertTrue((boolean)jsonObject.has(JSON_ERROR_MSG));
        }
        catch (JSONException e) {
            log.error((Object)"Response did not contain JSON.", (Throwable)e);
            TestAttachTemporaryFileResource.fail((String)"Response did not contain JSON.");
        }
        catch (IOException e) {
            log.error((Object)"IO error occured while reading the response.", (Throwable)e);
            TestAttachTemporaryFileResource.fail((String)"IO error occured while reading the response.");
        }
        return jsonObject;
    }

    private void assertXsrfResponse(int expectedResponse, HttpMethod method, HttpClient client) {
        JSONObject result = this.assertBadCommon(expectedResponse, method);
        TestAttachTemporaryFileResource.assertTrue((boolean)result.has(JSON_TOKEN));
        try {
            TestAttachTemporaryFileResource.assertEquals((String)this.getToken(client), (String)result.getString(JSON_TOKEN));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClient createClientForUser(String user) throws IOException {
        HttpClient client = new HttpClient();
        client.getParams().setCookiePolicy("compatibility");
        PostMethod method = new PostMethod(this.getUrl("login.jsp", new Object[0]));
        try {
            method.setParameter(PARAM_USERNAME, user);
            method.setParameter(PARAM_PASSWORD, user);
            method.setParameter(PARAM_COOKIE, String.valueOf(true));
            client.executeMethod((HttpMethod)method);
            TestAttachTemporaryFileResource.assertEquals((String)GOOD_LOGIN, (String)method.getResponseHeader(HEADER_SERAPH_RESPONSE).getValue());
        }
        finally {
            method.releaseConnection();
        }
        return client;
    }

    private String getToken(HttpClient client) {
        Cookie[] cookies;
        for (Cookie cookie : cookies = client.getState().getCookies()) {
            if (!cookie.getName().equals(COOKIE_XSRF)) continue;
            return cookie.getValue();
        }
        return null;
    }

    private String getRestUrl(Object ... params) {
        return this.getUrl(REST_PATH, params);
    }

    public String getRestUrlWithToken(HttpClient client, Object ... params) {
        ArrayList<Object> objects = new ArrayList<Object>(Arrays.asList(params));
        objects.add(PARAM_XSRF);
        objects.add(this.getToken(client));
        return this.getUrl(REST_PATH, objects);
    }

    private String getUrl(String path, Object ... params) {
        return this.getUrl(path, Arrays.asList(params));
    }

    private String getUrl(String path, Collection<Object> params) {
        String baseUrl = this.getEnvironmentData().getBaseUrl().toExternalForm();
        StringBuilder builder = new StringBuilder(baseUrl);
        if (!baseUrl.endsWith("/")) {
            builder.append("/");
        }
        builder.append(path);
        if (params != null && !params.isEmpty()) {
            Iterator<Object> object = params.iterator();
            int pos = 1;
            builder.append("?").append(this.encode(object.next())).append("=");
            while (object.hasNext()) {
                boolean key;
                boolean bl = key = !(pos & true);
                if (key) {
                    builder.append("&");
                }
                builder.append(this.encode(object.next()));
                if (key) {
                    builder.append("=");
                }
                ++pos;
            }
        }
        return builder.toString();
    }

    private String encode(Object obj) {
        try {
            return URLEncoder.encode(obj.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static class RandomBytesEntity
    implements RequestEntity {
        private int contentLength;
        private int actualLength;
        private String contentType;

        private RandomBytesEntity() {
            this.actualLength = this.contentLength = 10240;
            this.contentType = "application/octet-stream";
        }

        public RandomBytesEntity setLength(int length) {
            this.actualLength = this.contentLength = length;
            return this;
        }

        public RandomBytesEntity setActualLength(int actualLength) {
            this.actualLength = actualLength;
            return this;
        }

        public RandomBytesEntity setContentLength(int contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public RandomBytesEntity setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public boolean isRepeatable() {
            return true;
        }

        public void writeRequest(OutputStream out) throws IOException {
            int left = this.actualLength;
            int counter = 0;
            byte[] bytes = new byte[4];
            while (left > 0) {
                bytes[0] = (byte)counter;
                bytes[1] = (byte)(counter >> 8);
                bytes[2] = (byte)(counter >> 16);
                bytes[3] = (byte)(counter >> 24);
                int write = Math.min(left, bytes.length);
                out.write(bytes, 0, write);
                left -= write;
                ++counter;
            }
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

