/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestEditNestedGroups
extends JIRAWebTest {
    private static final String PLEASE_REFRESH_MEMBERS_LIST = "Newly selected group(s) may have different members.";
    private static final String UNASSIGN = "unassign";
    private static final String ASSIGN = "assign";
    private static final String FIELD_GROUPS_TO_UNASSIGN = "childrenToUnassign";
    private static final String FIELD_GROUPS_TO_ASSIGN = "childrenToAssignStr";
    private static final String FIELD_SELECTED_GROUPS = "selectedGroupsStr";
    private static final String ERROR_SELECT_GROUPS = "Please select group(s) to edit";
    private static final String ERROR_SELECT_GROUPS_TO_REMOVE = "Please select groups to remove from the selected group(s)";
    private static final String ERROR_SELECT_GROUPS_TO_ADD = "Please select groups to add to all the selected group(s)";

    public TestEditNestedGroups(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestEditNestedGroups.xml");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
    }

    @Override
    public void tearDown() {
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        super.tearDown();
    }

    public void testEditNestedGroupGroupsInvalidGroups() {
        this.gotoPage(this.page.addXsrfToken("/secure/admin/group/EditNestedGroups.jspa?selectedGroupsStr=invalid&assign=true&childrenToAssignStr=group200"));
        this.assertTextPresent("The group &#39;invalid&#39; is not a valid group.");
        this.gotoPage(this.page.addXsrfToken("/secure/admin/group/EditNestedGroups.jspa?selectedGroupsStr=invalid&unassign=true&childrenToUnassign=group200"));
        this.assertTextPresent("The group &#39;invalid&#39; is not a valid group.");
    }

    public void testUnassignGroupsFromGroups() {
        String option;
        int i;
        this.gotoEditNestedGroups();
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group202");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "jira-developers");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "jira-users");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "group203");
        this.submit(ASSIGN);
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group202");
        this.selectMultiOption(FIELD_GROUPS_TO_UNASSIGN, "jira-developers");
        this.submit(UNASSIGN);
        this.assertTextPresent("Selected 1 of 5 Groups");
        this.assertTextPresent("2 Group Member(s)");
        String[] options = this.getDialog().getOptionValuesFor(FIELD_GROUPS_TO_UNASSIGN);
        for (i = 0; i < options.length; ++i) {
            option = options[i];
            TestEditNestedGroups.assertFalse((boolean)option.equals("jira-developers______group202"));
        }
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group200");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "jira-users");
        this.submit(ASSIGN);
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group200");
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group202");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "jira-developers");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "group203");
        this.submit(ASSIGN);
        this.selectGroup200And202();
        options = this.getDialog().getOptionValuesFor(FIELD_GROUPS_TO_UNASSIGN);
        TestEditNestedGroups.assertTrue((options.length == 3 ? 1 : 0) != 0);
        this.selectMultiOptionByValue(FIELD_GROUPS_TO_UNASSIGN, "jira-users");
        this.selectMultiOptionByValue(FIELD_GROUPS_TO_UNASSIGN, "jira-developers");
        this.submit(UNASSIGN);
        this.assertTextPresent("Selected 2 of 5 Groups");
        options = this.getDialog().getOptionValuesFor(FIELD_GROUPS_TO_UNASSIGN);
        TestEditNestedGroups.assertTrue((options.length == 1 ? 1 : 0) != 0);
        for (i = 0; i < options.length; ++i) {
            option = options[i];
            TestEditNestedGroups.assertFalse((boolean)option.equals("jira-developers______group202"));
            TestEditNestedGroups.assertFalse((boolean)option.equals("jira-users"));
        }
    }

    public void testAssignGroupsFromGroups() {
        this.gotoEditNestedGroups();
        this.selectDeveloperGroupOnly();
        this.assertTextPresent("No groups in selected group(s)");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "group200");
        this.submit(ASSIGN);
        this.assertTextPresent("Selected 1 of 5 Groups");
        this.assertTextPresent("1 Group Member(s)");
        String[] options = this.getDialog().getOptionValuesFor(FIELD_GROUPS_TO_UNASSIGN);
        boolean found = false;
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            if (!option.equals("group200______jira-developers")) continue;
            found = true;
        }
        TestEditNestedGroups.assertTrue((boolean)found);
        this.selectGroupsAndDevelopersGroup();
        options = this.getDialog().getOptionValuesFor(FIELD_GROUPS_TO_UNASSIGN);
        TestEditNestedGroups.assertTrue((options.length == 1 ? 1 : 0) != 0);
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "group200");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "group202");
        this.submit(ASSIGN);
        this.assertTextPresent("Selected 2 of 5 Groups");
        options = this.getDialog().getOptionValuesFor(FIELD_GROUPS_TO_UNASSIGN);
        TestEditNestedGroups.assertEquals((int)2, (int)options.length);
        boolean found2 = false;
        found = false;
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            if (option.equals("group200")) {
                found = true;
            }
            if (!option.equals("group202")) continue;
            found2 = true;
        }
        TestEditNestedGroups.assertTrue((found && found2 ? 1 : 0) != 0);
    }

    public void testUnassignGroupsFromGroupsValidation() {
        this.gotoEditNestedGroups();
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group200");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "jira-users");
        this.submit(ASSIGN);
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group200");
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group202");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "jira-developers");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "group203");
        this.submit(ASSIGN);
        this.gotoEditNestedGroups();
        this.submit(UNASSIGN);
        this.assertTextPresent(ERROR_SELECT_GROUPS);
        this.selectGroupsAndDevelopersGroup();
        this.submit(UNASSIGN);
        this.assertTextPresent(ERROR_SELECT_GROUPS_TO_REMOVE);
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group200");
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group202");
        this.refreshMembersList();
        this.selectMultiOption(FIELD_GROUPS_TO_UNASSIGN, "jira-developers");
        this.selectOption(FIELD_SELECTED_GROUPS, "group203");
        this.assertTextPresent(PLEASE_REFRESH_MEMBERS_LIST);
        this.submit(UNASSIGN);
        this.assertTextPresent("Cannot remove group &#39;jira-developers&#39; from group &#39;group203&#39; since group is not a member of &#39;group203&#39;");
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group200");
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group202");
        this.refreshMembersList();
        this.selectMultiOption(FIELD_GROUPS_TO_UNASSIGN, "jira-users");
        this.selectOption(FIELD_SELECTED_GROUPS, "group202");
        this.assertTextPresent(PLEASE_REFRESH_MEMBERS_LIST);
        this.submit(UNASSIGN);
        this.assertTextPresent("Cannot remove group &#39;jira-users&#39; from group &#39;group200&#39; since the group was not selected. Please make sure to refresh after selecting new group(s)");
    }

    public void testAssignGroupsFromGroupsValidation() {
        this.gotoEditNestedGroups();
        this.assertTextPresent("Selected 0 of 5 Groups");
        this.submit(ASSIGN);
        this.assertTextPresent(ERROR_SELECT_GROUPS);
        this.gotoEditNestedGroups();
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "group200");
        this.assertTextPresent("Selected 0 of 5 Groups");
        this.submit(ASSIGN);
        this.assertTextPresent(ERROR_SELECT_GROUPS);
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group200");
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group202");
        this.submit(ASSIGN);
        this.assertTextPresent(ERROR_SELECT_GROUPS_TO_ADD);
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group200");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "group202");
        this.submit(ASSIGN);
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group200");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "group202");
        this.submit(ASSIGN);
        this.assertTextPresent("Cannot add group &#39;group202&#39;, group is already a member of &#39;group200&#39;");
        this.selectOption(FIELD_SELECTED_GROUPS, "jira-users");
        this.selectOption(FIELD_GROUPS_TO_ASSIGN, "group202");
        this.submit(ASSIGN);
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "jira-users");
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group200");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "group202");
        this.submit(ASSIGN);
        this.assertTextPresent("Cannot add group &#39;group202&#39;, group is already a member of all the selected group(s)");
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group200");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "group200");
        this.submit(ASSIGN);
        this.assertTextPresent("Cannot add a group to itself.");
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group202");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "group200");
        this.submit(ASSIGN);
        this.assertTextPresent("Cannot add child group &#39;group200&#39; to parent group &#39;group202&#39; - this would cause a circular dependency.");
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "group202");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "jira-developers");
        this.submit(ASSIGN);
        this.selectMultiOption(FIELD_SELECTED_GROUPS, "jira-developers");
        this.selectMultiOption(FIELD_GROUPS_TO_ASSIGN, "group200");
        this.submit(ASSIGN);
        this.assertTextPresent("Cannot add child group &#39;group200&#39; to parent group &#39;jira-developers&#39; - this would cause a circular dependency.");
    }

    private void gotoEditNestedGroups() {
        this.clickOnAdminPanel("admin.groupsgroups", "group_browser");
        this.clickLink("edit_nested_groups");
        this.assertTextPresent("This page allows you to edit nested group memberships.");
        this.assertTextPresent("Selected 0 of 5 Groups");
        this.assertTextPresent("No groups in selected group(s)");
    }

    private void selectDeveloperGroupOnly() {
        this.selectSingleGroupOnly(this.getDeveloperOption());
    }

    private void selectAdminGroupOnly() {
        this.selectSingleGroupOnly(this.getAdminOption());
    }

    private void selectGroupsAndDevelopersGroup() {
        this.selectTwoGroups(this.getGroupOption(), this.getDeveloperOption());
    }

    private void selectGroup200And202() {
        this.selectTwoGroups(this.getGroup200Option(), this.getGroup202Option());
    }

    private void selectSingleGroupOnly(String group) {
        this.selectMultiOption(FIELD_SELECTED_GROUPS, group);
        this.assertTextPresent(PLEASE_REFRESH_MEMBERS_LIST);
        this.refreshMembersList();
        this.assertTextPresent("Selected 1 of 5 Groups");
    }

    private void selectTwoGroups(String group1, String group2) {
        this.selectMultiOption(FIELD_SELECTED_GROUPS, group1);
        this.selectMultiOption(FIELD_SELECTED_GROUPS, group2);
        this.assertTextPresent(PLEASE_REFRESH_MEMBERS_LIST);
        this.refreshMembersList();
        this.assertTextPresent("Selected 2 of 5 Groups");
    }

    private void selectAllGroups() {
        this.selectMultiOption(FIELD_SELECTED_GROUPS, this.getAdminOption());
        this.selectMultiOption(FIELD_SELECTED_GROUPS, this.getDeveloperOption());
        this.selectMultiOption(FIELD_SELECTED_GROUPS, this.getGroupOption());
        this.assertTextPresent(PLEASE_REFRESH_MEMBERS_LIST);
        this.refreshMembersList();
        this.assertTextPresent("Selected 3 of 5 Groups");
    }

    private void refreshMembersList() {
        if (HttpUnitOptions.isScriptingEnabled()) {
            this.clickLink("refresh-dependant-fields");
        } else {
            this.submit("refresh");
        }
    }

    private String getAdminOption() {
        return "group203";
    }

    private String getDeveloperOption() {
        return "jira-developers";
    }

    private String getGroupOption() {
        return "jira-users";
    }

    private String getGroup200Option() {
        return "group200";
    }

    private String getGroup202Option() {
        return "group202";
    }
}

