/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS})
public class TestBulkOperationsIndexing
extends JIRAWebTest {
    public TestBulkOperationsIndexing(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestBulkOperationsIndexing.xml");
    }

    public void testBulkEditIndexing() {
        this.findAndVerifyIssuesArePresent(false);
        this.clickLink("bulkedit_all");
        this.checkCheckbox("bulkedit_10003", "on");
        this.checkCheckbox("bulkedit_10002", "on");
        this.checkCheckbox("bulkedit_10001", "on");
        this.checkCheckbox("bulkedit_10000", "on");
        this.submit("Next");
        this.checkCheckbox("operation", "bulk.edit.operation.name");
        this.submit("Next");
        this.checkCheckbox("actions", "comment");
        this.setFormElement("comment", "whatsminesay");
        this.submit("Next");
        this.submit("Confirm");
        this.clickLink("find_link");
        this.clickLink("new_filter");
        this.checkCheckbox("body", "true");
        this.uncheckCheckbox("summary");
        this.uncheckCheckbox("description");
        this.setFormElement("query", "whatsminesay");
        this.submit("show");
        this.assertTextPresent("HSP-1");
        this.assertTextPresent("HSP-2");
        this.assertTextPresent("Test issue 1");
        this.assertTextPresent("Test Issue 2");
        this.assertTextPresent("HSP-3");
        this.assertTextPresent("HSP-4");
        this.assertTextPresent("Subtask 1");
        this.assertTextPresent("Subtask 2");
    }

    public void testBulkMoveIndexing() {
        this.findAndVerifyIssuesArePresent(true);
        this.clickLink("bulkedit_all");
        this.checkCheckbox("bulkedit_10003", "on");
        this.checkCheckbox("bulkedit_10002", "on");
        this.checkCheckbox("bulkedit_10001", "on");
        this.checkCheckbox("bulkedit_10000", "on");
        this.checkCheckbox("bulkedit_10010", "on");
        this.submit("Next");
        this.checkCheckbox("operation", "bulk.move.operation.name");
        this.submit("Next");
        this.selectOption("10010_1_pid", "monkey");
        this.submit("Next");
        this.submit("Next");
        this.submit("Next");
        this.submit("Next");
        this.submit("Next");
        this.clickLink("find_link");
        this.clickLink("new_filter");
        this.selectOption("pid", "monkey");
        this.submit("show");
        this.assertTextPresent("MKY-1");
        this.assertTextPresent("MKY-2");
        this.assertTextPresent("MKY-3");
        this.assertTextPresent("Test issue 1");
        this.assertTextPresent("Test Issue 2");
        this.assertTextPresent("MKY-4");
        this.assertTextPresent("MKY-5");
        this.assertTextPresent("Subtask 1");
        this.assertTextPresent("Subtask 2");
        this.assertTextPresent("Test Monkey Issue 1");
        this.clickLink("find_link");
        this.clickLink("new_filter");
        this.selectOption("pid", "homosapien");
        this.submit("show");
        this.assertTextPresent("No matching issues found.");
    }

    public void testBulkWorkflowTransitionIndexing() {
        this.findAndVerifyIssuesArePresent(true);
        this.clickLink("bulkedit_all");
        this.checkCheckbox("bulkedit_10003", "on");
        this.checkCheckbox("bulkedit_10002", "on");
        this.checkCheckbox("bulkedit_10001", "on");
        this.checkCheckbox("bulkedit_10000", "on");
        this.checkCheckbox("bulkedit_10010", "on");
        this.submit("Next");
        this.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.submit("Next");
        this.checkCheckbox("wftransition", "jira_5_5");
        this.submit("Next");
        this.selectOption("resolution", "Fixed");
        this.submit("Next");
        this.submit("Next");
        this.clickLink("find_link");
        this.clickLink("new_filter");
        this.selectOption("resolution", "Fixed");
        this.selectOption("status", "Resolved");
        this.submit("show");
        this.assertTextPresent("HSP-1");
        this.assertTextPresent("HSP-2");
        this.assertTextPresent("Test issue 1");
        this.assertTextPresent("Test Issue 2");
        this.assertTextPresent("HSP-3");
        this.assertTextPresent("HSP-4");
        this.assertTextPresent("Subtask 1");
        this.assertTextPresent("Subtask 2");
        this.assertTextPresent("MKY-1");
        this.assertTextPresent("Test Monkey Issue 1");
    }

    private void findAndVerifyIssuesArePresent(boolean all) {
        this.clickLink("find_link");
        if (!all) {
            this.selectOption("pid", "homosapien");
        }
        this.submit("show");
        this.assertTextPresent("HSP-1");
        this.assertTextPresent("HSP-2");
        this.assertTextPresent("Test issue 1");
        this.assertTextPresent("Test Issue 2");
        this.assertTextPresent("HSP-3");
        this.assertTextPresent("HSP-4");
        this.assertTextPresent("Subtask 1");
        this.assertTextPresent("Subtask 2");
        if (all) {
            this.assertTextPresent("MKY-1");
            this.assertTextPresent("Test Monkey Issue 1");
        }
    }
}

