/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigation.issue.FileAttachmentsList;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS, Category.BULK_OPERATIONS})
public class TestBulkMoveAttachments
extends FuncTestCase {
    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestAttachmentEncoding.xml");
        this.removeAttachmentFilesFromJiraHome();
        this.copyAttachmentFilesToJiraHome();
    }

    public void testBulkMove() throws Exception {
        this.navigation.issueNavigator().displayAllIssues();
        BulkChangeWizard wizard = this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        wizard.selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperations.MOVE).chooseTargetContextForAll("monkey").finaliseFields().complete();
        for (FileAttachmentsList.FileAttachmentItem fileAttachmentItem : this.navigation.issue().attachments("MKY-1").list().get()) {
            this.tester.gotoPage("/secure/attachment/" + fileAttachmentItem.getId() + "/" + fileAttachmentItem.getName());
        }
    }

    protected final void copyAttachmentFilesToJiraHome() {
        File jiraAttachmentsPath = new File(this.administration.getCurrentAttachmentPath());
        File testAttachmentsPath = new File(this.environmentData.getXMLDataLocation(), "TestAttachmentEncoding/attachments");
        try {
            FileUtils.copyDirectory((File)testAttachmentsPath, (File)jiraAttachmentsPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void removeAttachmentFilesFromJiraHome() {
        File jiraAttachmentsPath = new File(this.administration.getCurrentAttachmentPath());
        try {
            FileUtils.cleanDirectory((File)jiraAttachmentsPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

