/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bulk.BulkChangeIssues;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.ISSUES})
public class TestBulkEditIssues
extends BulkChangeIssues {
    private static final String HSP_5 = "HSP-5";
    private static final String TST_1 = "TST-1";
    private static final String COMMENT_1 = "This issue is resolved now.";
    private static final String COMMENT_2 = "Viewable by developers group.";
    private static final String COMMENT_3 = "Viewable by Developers role.";
    private static final String UNAVAILABLE_BULK_EDIT_ACTIONS_TABLE_ID = "unavailableActionsTable";
    private static final String SESSION_TIMEOUT_MESSAGE_CONTAINER_LOCATOR = ".aui-message.warning";

    public TestBulkEditIssues(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.bulkChangeSetup();
        this.administration.addGlobalPermission(33, "jira-users");
    }

    @Override
    public void tearDown() {
        this.administration.removeGlobalPermission(33, "jira-users");
        super.tearDown();
    }

    public void testBulkEditIssues() {
        this._testBulkEditOneIssueInCurrentPage();
        this._testBulkEditOneIssueInAllPages();
        this._testBulkEditAllIssuesInAllPages();
        this._testBulkEditAllIssuesInCurrentPage();
    }

    public void _testBulkEditOneIssueInCurrentPage() {
        TestBulkEditIssues.log("Bulk Change - Edit Operation: ONE issue from CURRENT page");
        String summary = "EditOneIssueInCurrentPage";
        this.addCurrentPageLink();
        String key = this.addIssue(summary);
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)key), EasyMap.build((Object)"fixVersion", (Object)"New Version 1", (Object)"version", (Object)"New Version 2"), key);
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkChangeIncludeCurrentPage();
        this.bulkChangeSelectIssue(key);
        this.bulkChangeChooseOperationEdit();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("fixVersions", "New Version 1");
        fields.put("versions", "New Version 2");
        fields.put("assignee", "Administrator");
        fields.put("priority", "Major");
        this.bulkEditOperationDetailsSetAs(fields);
        fields = new HashMap();
        fields.put("fixVersions", "New Version 1");
        fields.put("versions", "New Version 2");
        fields.put("assignee", "Administrator");
        fields.put("priority", "Major");
        this.bulkEditConfirmEdit(fields);
        this.bulkChangeConfirm();
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("/secure/IssueNavigator.jspa");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"fixVersion", (Object)"New Version 1", (Object)"version", (Object)"New Version 2", (Object)"assignee", (Object)"Administrator", (Object)"priority", (Object)"Major"), null, key);
    }

    public void _testBulkEditOneIssueInAllPages() {
        TestBulkEditIssues.log("Bulk Change - Edit Operation: ONE issue from ALL pages");
        String summary = "EditOneIssueInAllPages";
        this.addCurrentPageLink();
        String key = this.addIssue(summary);
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeSelectIssue(key);
        this.bulkChangeChooseOperationEdit();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("fixVersions", "New Version 1");
        fields.put("versions", "New Version 1");
        fields.put("components", "New Component 1");
        fields.put("assignee", "Administrator");
        fields.put("priority", "Blocker");
        this.bulkEditOperationDetailsSetAs(fields);
        fields = new HashMap();
        fields.put("fixVersions", "New Version 1");
        fields.put("versions", "New Version 1");
        fields.put("components", "New Component 1");
        fields.put("assignee", "Administrator");
        fields.put("priority", "Blocker");
        this.bulkEditConfirmEdit(fields);
        this.bulkChangeConfirm();
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("/secure/IssueNavigator.jspa");
    }

    public void _testBulkEditAllIssuesInCurrentPage() {
        TestBulkEditIssues.log("Bulk Change - Edit Operation: ALL issue from CURRENT pages");
        this.setUnassignedIssuesOption(true);
        this.addCurrentPageLink();
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkChangeIncludeCurrentPage();
        this.bulkChangeChooseIssuesAll();
        this.bulkChangeChooseOperationEdit();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("fixVersions", "New Version 2");
        fields.put("versions", "New Version 2");
        fields.put("components", "New Component 1");
        fields.put("assignee", "Unassigned");
        this.bulkEditOperationDetailsSetAs(fields);
        fields = new HashMap();
        fields.put("fixVersions", "New Version 2");
        fields.put("versions", "New Version 2");
        fields.put("components", "New Component 1");
        fields.put("assignee", "Unassigned");
        this.bulkEditConfirmEdit(fields);
        this.bulkChangeConfirm();
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("/secure/IssueNavigator.jspa");
        this.deleteAllIssuesInAllPages();
        this.setUnassignedIssuesOption(false);
    }

    public void _testBulkEditAllIssuesInAllPages() {
        TestBulkEditIssues.log("Bulk Change - Edit Operation: ALL issue from ALL pages");
        this.addCurrentPageLink();
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.bulkChangeChooseOperationEdit();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("versions", "New Version 2");
        fields.put("assignee", "Administrator");
        fields.put("priority", "Blocker");
        this.bulkEditOperationDetailsSetAs(fields);
        fields = new HashMap();
        fields.put("versions", "New Version 2");
        fields.put("assignee", "Administrator");
        fields.put("priority", "Blocker");
        this.bulkEditConfirmEdit(fields);
        this.bulkChangeConfirm();
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("/secure/IssueNavigator.jspa");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"version", (Object)"New Version 2", (Object)"assignee", (Object)"Administrator", (Object)"priority", (Object)"Blocker"), null, "HSP-1");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"version", (Object)"New Version 2", (Object)"assignee", (Object)"Administrator", (Object)"priority", (Object)"Blocker"), null, HSP_5);
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"version", (Object)"New Version 2", (Object)"assignee", (Object)"Administrator", (Object)"priority", (Object)"Blocker"), null, "HSP-9");
    }

    public void testBulkEditIssuesIssueTypesWithDiffWorkflows() {
        this.administration.restoreData("TestBulkEditIssues.xml");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeSelectIssue(HSP_5);
        this.bulkChangeChooseOperationEdit();
        this.tester.assertOptionsEqual("issuetype", new String[]{"Test Bug", "Test Improvment", "Test New Feature"});
    }

    public void testBulkEditIssuesIssueTypesWithDiffWorkflowsMultipleIssues() {
        this.administration.restoreData("TestBulkEditIssues.xml");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeSelectIssues(Arrays.asList("HSP-2", TST_1));
        this.bulkChangeChooseOperationEdit();
        this.tester.assertOptionsEqual("issuetype", new String[]{"Task"});
    }

    public void testBulkEditIssuesIssueTypesWithDifferentWorkflowsNoOptions() {
        this.administration.restoreData("TestBulkEditIssues.xml");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeSelectIssues(Arrays.asList(HSP_5, TST_1));
        this.bulkChangeChooseOperationEdit();
        this.text.assertTextPresent(this.locator.id(UNAVAILABLE_BULK_EDIT_ACTIONS_TABLE_ID), "There are no issue types available for selected issues.");
    }

    public void testBulkEditIssuesIssueTypesWithDifferentFieldConfigurationSchemes() {
        this.administration.restoreData("TestBulkEditIssues.xml");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeSelectIssue("TST-3");
        this.bulkChangeChooseOperationEdit();
        this.tester.assertOptionsEqual("issuetype", new String[]{"Improvement"});
    }

    public void testBulkEditIssuesIssueTypesWithDifferentWorkflowsSubtasks() {
        this.administration.restoreData("TestBulkEditIssues.xml");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeSelectIssue("HSP-6");
        this.bulkChangeChooseOperationEdit();
        this.tester.assertOptionsEqual("issuetype", new String[]{"Super Sub-taks"});
    }

    public void testBulkEditIssuesIssueTypesWithDiffFieldConfSchemesSubtasks() {
        this.administration.restoreData("TestBulkEditIssues.xml");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeSelectIssue("TST-4");
        this.bulkChangeChooseOperationEdit();
        this.tester.assertOptionsEqual("issuetype", new String[]{"Sub-task"});
    }

    public void testBulkEditSessionTimeouts() {
        TestBulkEditIssues.log("Bulk Edit - Test that you get redirected to the session timeout page when jumping into the wizard");
        this.administration.restoreBlankInstance();
        this.tester.beginAt("secure/views/bulkedit/BulkEditDetails.jspa");
        this.verifyAtSessionTimeoutPage();
        this.tester.beginAt("secure/views/bulkedit/BulkEditDetailsValidation.jspa");
        this.verifyAtSessionTimeoutPage();
    }

    private void verifyAtSessionTimeoutPage() {
        this.text.assertTextPresent(this.locator.css(SESSION_TIMEOUT_MESSAGE_CONTAINER_LOCATOR), "Your session timed out while you were in the process of selecting issues to perform a bulk operation on.");
    }

    public void testBulkEditWithCommentVisibility() {
        this.administration.restoreData("TestBulkEditIssues.xml");
        this.enableCommentGroupVisibility(Boolean.TRUE);
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeSelectIssues(Arrays.asList(HSP_5, TST_1));
        this.bulkChangeChooseOperationEdit();
        this.tester.checkCheckbox("actions", "priority");
        this.tester.selectOption("priority", "Minor");
        this.tester.checkCheckbox("actions", "comment");
        this.tester.setFormElement("comment", COMMENT_1);
        this.tester.submit("Next");
        this.bulkChangeConfirm();
        this.addComment(COMMENT_2, "jira-developers");
        this.addComment(COMMENT_3, "Developers");
        this.addComment("This comment should be visible to users role.", "Users");
        this.addComment("This comment should be visible to jira-users group", "jira-users");
        this.addComment("this comment should be visible to jira admins", "jira-administrators");
        this.addComment("this comment should be visible to Administrators role", "Administrators");
        List userComments = EasyList.build((Object)"This comment should be visible to users role.", (Object)"This comment should be visible to jira-users group", (Object)COMMENT_1);
        List developerComments = EasyList.build((Object)COMMENT_2, (Object)COMMENT_3);
        List adminComments = EasyList.build((Object)"this comment should be visible to jira admins", (Object)"this comment should be visible to Administrators role");
        this.checkCommentVisibility("fred", HSP_5, userComments, EasyList.mergeLists((List)developerComments, (List)adminComments, null));
        this.checkCommentVisibility("fred", TST_1, userComments, EasyList.mergeLists((List)developerComments, (List)adminComments, null));
        this.checkCommentVisibility("adminman", HSP_5, EasyList.mergeLists((List)adminComments, (List)userComments, null), developerComments);
        this.checkCommentVisibility("adminman", TST_1, EasyList.mergeLists((List)adminComments, (List)userComments, null), developerComments);
        this.checkCommentVisibility("devman", HSP_5, EasyList.mergeLists((List)userComments, (List)developerComments, null), adminComments);
        this.checkCommentVisibility("devman", TST_1, EasyList.mergeLists((List)userComments, (List)developerComments, null), adminComments);
        this.checkCommentVisibility("admin", HSP_5, EasyList.mergeLists((List)developerComments, (List)adminComments, (List)userComments), null);
        this.checkCommentVisibility("admin", TST_1, EasyList.mergeLists((List)developerComments, (List)adminComments, (List)userComments), null);
    }

    private void addComment(String comment, String commentLevel) {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeSelectIssues(Arrays.asList(HSP_5, TST_1));
        this.bulkChangeChooseOperationEdit();
        this.tester.checkCheckbox("actions", "priority");
        this.tester.selectOption("priority", "Minor");
        this.tester.checkCheckbox("actions", "comment");
        this.tester.setFormElement("comment", comment);
        this.tester.selectOption("commentLevel", commentLevel);
        this.tester.submit("Next");
        this.bulkChangeConfirm();
    }
}

