/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebTable;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS})
public class TestBulkEditEnvironment
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestBulkEditEnvironment.xml");
    }

    public void testHappyPath() throws Exception {
        this.navigation.issue().viewIssue("RAT-1");
        this.assertions.getViewIssueAssertions().assertEnvironmentEquals("DOS 4, 80286");
        this.navigation.issue().viewIssue("RAT-2");
        this.assertions.getViewIssueAssertions().assertEnvironmentEquals("");
        this.navigation.issue().viewIssue("COW-18");
        this.assertions.getViewIssueAssertions().assertEnvironmentEquals("");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Issue Navigator");
        this.tester.clickLinkWithText("Tools");
        this.tester.clickLink("bulkedit_all");
        this.tester.assertTextPresent("Bulk Operation Step 1 of 4: Choose Issues");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.checkCheckbox("bulkedit_10020", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Bulk Operation Step 2 of 4: Choose Operation");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Bulk Operation Step 3 of 4: Operation Details");
        this.tester.assertTextPresent("Change Environment");
        this.tester.checkCheckbox("actions", "environment");
        this.tester.setFormElement("environment", "DOS 5, 80386");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Bulk Operation Step 4 of 4: Confirmation");
        this.tester.assertTextPresent("Updated Fields");
        WebTable updatedfields = this.tester.getDialog().getWebTableBySummaryOrId("updatedfields");
        TestBulkEditEnvironment.assertEquals((String)"Cell (0, 0) in table 'updatedfields' should be 'Environment'.", (String)"Environment", (String)updatedfields.getCellAsText(0, 0).trim());
        TestBulkEditEnvironment.assertEquals((String)"Cell (0, 1) in table 'updatedfields' should be 'DOS 5, 80386'.", (String)"DOS 5, 80386", (String)updatedfields.getCellAsText(0, 1).trim());
        this.tester.submit("Confirm");
        this.navigation.issue().viewIssue("RAT-1");
        this.assertions.getViewIssueAssertions().assertEnvironmentEquals("DOS 5, 80386");
        this.navigation.issue().viewIssue("RAT-2");
        this.assertions.getViewIssueAssertions().assertEnvironmentEquals("");
        this.navigation.issue().viewIssue("COW-15");
        this.assertions.getViewIssueAssertions().assertEnvironmentEquals("DOS 5, 80386");
    }

    public void testHiddenInOneProject() throws Exception {
        this.tester.gotoPage("/plugins/servlet/project-config/COW/fields");
        this.tester.clickLink("project-config-fields-scheme-change");
        this.tester.selectOption("schemeId", "Small Field Configuration Scheme");
        this.tester.submit("Associate");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Issue Navigator");
        this.tester.clickLinkWithText("Tools");
        this.tester.clickLink("bulkedit_all");
        this.tester.assertTextPresent("Bulk Operation Step 1 of 4: Choose Issues");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.checkCheckbox("bulkedit_10020", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Bulk Operation Step 2 of 4: Choose Operation");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Bulk Operation Step 3 of 4: Operation Details");
        this.tester.assertTextInElement("unavailableActionsTable", "Change Environment");
    }

    public void testDifferentRenderers() throws Exception {
        this.tester.gotoPage("/plugins/servlet/project-config/COW/fields");
        this.tester.clickLink("project-config-fields-scheme-edit");
        this.tester.clickLink("configure_fieldlayout");
        this.tester.clickLink("renderer_environment");
        this.tester.selectOption("selectedRendererType", "Wiki Style Renderer");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Edit Field Renderer Confirmation: Environment");
        this.tester.submit("Update");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Issue Navigator");
        this.tester.clickLinkWithText("Tools");
        this.tester.clickLink("bulkedit_all");
        this.tester.assertTextPresent("Bulk Operation Step 1 of 4: Choose Issues");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.checkCheckbox("bulkedit_10020", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Bulk Operation Step 2 of 4: Choose Operation");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Bulk Operation Step 3 of 4: Operation Details");
        this.tester.assertTextInElement("unavailableActionsTable", "Change Environment");
    }
}

