/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bulk.BulkChangeIssues;
import com.meterware.httpunit.HttpUnitOptions;
import java.util.HashMap;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.ISSUES})
public class TestBulkChangeIssues
extends BulkChangeIssues {
    protected static final int MAX = 3;
    protected static final String PREFIX_ISSUE_ON_CURR_PG = "issue_";
    private static final int NUM_ISSUES_IN_XML_FILE = 51;
    private static final int TOTAL_ISSUES = 54;
    protected static String[] issueID = new String[3];
    private static final String MY_OPTION_VERSION_ONE_UNESCAPED = "New Version 1 &trade;";
    private static final String MY_OPTION_COMPONENT_ONE_UNESCAPED = "New Component 1 &trade;";

    public TestBulkChangeIssues(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestBulkChangeInitialised.xml");
        for (int i = 0; i < 3; ++i) {
            TestBulkChangeIssues.issueID[i] = this.getIssueIdWithIssueKey(this.addIssue(PREFIX_ISSUE_ON_CURR_PG + i));
        }
    }

    @Override
    public void tearDown() {
        super.tearDown();
    }

    public void testBulkChangeIssues() {
        this._testCheckLabelForStepIssueNavigator();
        this._testCheckLabelsSelectIssuesOneSingleProject();
        this._testCheckLabelsSelectIssuesSomeSingleProject();
        this._testCheckLabelsSelectIssuesAllSingleProject();
        this._testCheckLabelsSelectIssuesSomeMultipleProject();
        this._testCheckLabelsSelectIssuesAllMultipleProject();
        this._testCheckOperationDetailsContent();
        this._testClickNextWithoutFormCompletionForOperationEdit();
        this._testClickNextWithoutFormCompletionForOperationDelete();
        this._testCancelLinkForStepChooseIssues();
        this._testCancelLinkForStepChooseOperation();
        this._testCancelLinkForStepOperationDetails();
        this._testCancelLinkForStepConfirmationEdit();
        this._testCancelLinkForStepConfirmationDelete();
        this._testSideBarLinks();
        this._testCheckIssueContentIncludeCurrentPageFromCurrentPage();
        this._testCheckIssueContentIncludeCurrentPageFromNextPage();
        this._testCheckIssueContentIncludeAllPageFromCurrentPage();
        this._testCheckIssueContentIncludeAllPageFromNextPage();
    }

    public void _testCheckLabelForStepIssueNavigator() {
        TestBulkChangeIssues.log("Bulk Change - Check Labels: iterate through ALL pages and check ISSUE NAVIGATOR labels");
        this.displayAllIssues();
        int i = 1;
        this.checkLabelForStepIssueNavigator(i, 54);
        while (this.getDialog().isLinkPresentWithText("Next >>")) {
            this.clickLinkWithText("Next >>");
            this.checkLabelForStepIssueNavigator(++i, 54);
        }
    }

    public void _testCheckLabelsSelectIssuesOneSingleProject() {
        boolean mailServerExists = this.isMailServerExists();
        TestBulkChangeIssues.log("Bulk Change - Check Labels: select ONE known issue from a SINGLE project");
        String summary = "testCheckLabelsSelectIssuesOneSingleProject";
        this.addCurrentPageLink();
        String issueKey = this.addIssue(summary);
        this.displayAllIssues();
        this.checkLabelForStepIssueNavigator(1, 55);
        this.bulkChangeIncludeAllPages();
        this.bulkChangeSelectIssue(issueKey);
        this.checkLabelForStepChooseOperation(1, 1);
        this.bulkChangeChooseOperationEdit();
        this.checkLabelForStepOperationDetails(1, 1);
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("fixVersions", MY_OPTION_VERSION_ONE_UNESCAPED);
        fields.put("versions", "New Version 2");
        fields.put("components", MY_OPTION_COMPONENT_ONE_UNESCAPED);
        fields.put("assignee", "Administrator");
        fields.put("priority", "Blocker");
        this.bulkEditOperationDetailsSetAs(fields);
        this.checkLabelForStepConfirmationEdit(1, 1);
        this.checkLinkToStepChooseOperation();
        this.bulkChangeChooseOperationDelete(mailServerExists);
        this.checkLabelForStepConfirmationDelete(1, 1);
        this.deleteIssue(issueKey);
    }

    public void _testCheckLabelsSelectIssuesSomeSingleProject() {
        boolean mailServerExists = this.isMailServerExists();
        TestBulkChangeIssues.log("Bulk Change - Check Labels: select SOME known issues from a SINGLE project");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesSome();
        this.clickOnNext();
        this.checkLabelForStepChooseOperation(3, 1);
        this.bulkChangeChooseOperationEdit();
        this.checkLabelForStepOperationDetails(3, 1);
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("fixVersions", MY_OPTION_VERSION_ONE_UNESCAPED);
        fields.put("versions", "New Version 2");
        fields.put("components", MY_OPTION_COMPONENT_ONE_UNESCAPED);
        fields.put("assignee", "Administrator");
        fields.put("priority", "Blocker");
        this.bulkEditOperationDetailsSetAs(fields);
        this.checkLabelForStepConfirmationEdit(3, 1);
        this.checkLinkToStepChooseOperation();
        this.bulkChangeChooseOperationDelete(mailServerExists);
        this.checkLabelForStepConfirmationDelete(3, 1);
    }

    public void _testCheckLabelsSelectIssuesAllSingleProject() {
        boolean mailServerExists = this.isMailServerExists();
        TestBulkChangeIssues.log("Bulk Change - Check Labels: select ALL known issues from a SINGLE project");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.checkLabelForStepChooseOperation(54, 1);
        this.bulkChangeChooseOperationEdit();
        this.checkUnescapedVersionAndComponentNotPresent();
        this.checkLabelForStepOperationDetails(54, 1);
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("fixVersions", MY_OPTION_VERSION_ONE_UNESCAPED);
        fields.put("versions", "New Version 2");
        fields.put("components", MY_OPTION_COMPONENT_ONE_UNESCAPED);
        fields.put("assignee", "Administrator");
        fields.put("priority", "Blocker");
        this.bulkEditOperationDetailsSetAs(fields);
        this.checkUnescapedVersionAndComponentNotPresent();
        this.checkLabelForStepConfirmationEdit(54, 1);
        this.checkLinkToStepChooseOperation();
        this.bulkChangeChooseOperationDelete(mailServerExists);
        this.checkLabelForStepConfirmationDelete(54, 1);
    }

    public void _testCheckLabelsSelectIssuesSomeMultipleProject() {
        boolean mailServerExists = this.isMailServerExists();
        TestBulkChangeIssues.log("Bulk Change - Check Labels: select SOME known issues from MULTIPLE projects");
        String projectTwoIssueKey = this.addIssueInProject("issue in project two", "neanderthal", "NDT");
        String projectTwoIssueID = this.getIssueIdWithIssueKey(projectTwoIssueKey);
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesSome();
        this.selectCheckbox("bulkedit_" + projectTwoIssueID);
        this.clickOnNext();
        this.checkLabelForStepChooseOperation(4, 2);
        this.bulkChangeChooseOperationEdit();
        this.checkLabelForStepOperationDetails(4, 2);
        this.checkMultipleProjectNote();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("priority", "Minor");
        this.bulkEditOperationDetailsSetAs(fields);
        this.checkLabelForStepConfirmationEdit(4, 2);
        this.checkLinkToStepChooseOperation();
        this.bulkChangeChooseOperationDelete(mailServerExists);
        this.checkLabelForStepConfirmationDelete(4, 2);
        this.deleteIssue(projectTwoIssueKey);
    }

    public void _testCheckLabelsSelectIssuesAllMultipleProject() {
        boolean mailServerExists = this.isMailServerExists();
        TestBulkChangeIssues.log("Bulk Change - Check Labels: select ALL known issues from MULTIPLE projects");
        String projectTwoIssueKey = this.addIssueInProject("issue in project two", "neanderthal", "NDT");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.checkLabelForStepChooseOperation(55, 2);
        this.bulkChangeChooseOperationEdit();
        this.checkLabelForStepOperationDetails(55, 2);
        this.checkMultipleProjectNote();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("priority", "Trivial");
        this.bulkEditOperationDetailsSetAs(fields);
        this.checkLabelForStepConfirmationEdit(55, 2);
        this.checkLinkToStepChooseOperation();
        this.bulkChangeChooseOperationDelete(mailServerExists);
        this.checkLabelForStepConfirmationDelete(55, 2);
        this.deleteIssue(projectTwoIssueKey);
    }

    private void checkUnescapedVersionAndComponentNotPresent() {
        this.assertTextNotPresent(MY_OPTION_COMPONENT_ONE_UNESCAPED);
        this.assertTextNotPresent(MY_OPTION_VERSION_ONE_UNESCAPED);
    }

    public void _testCheckOperationDetailsContent() {
        TestBulkChangeIssues.log("Bulk Change - Check label & contents: Step Operation Details");
        this.addProject("project_temp", "tmp", "admin");
        String key = this.addIssueInProject("issue in project temp", "project_temp", "TMP");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeSelectIssue(key);
        this.bulkChangeChooseOperationEdit();
        this.assertTextPresent("The project of the selected issue(s) does not have any versions.");
        this.assertTextPresent("The project of the selected issue(s) does not have any components.");
        this.assertTextPresent("There are no available custom fields for the selected issues.");
        this.assertFormElementNotPresent("fixVersions");
        this.assertFormElementNotPresent("versions");
        this.assertFormElementNotPresent("components");
        this.assertFormElementPresent("assignee");
        this.assertFormElementPresent("priority");
        this.deleteProject("project_temp");
    }

    public void _testClickNextWithoutFormCompletionForOperationEdit() {
        TestBulkChangeIssues.log("Bulk Change - Errors: Click NEXT without form completion for operation Edit");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeNextWithoutFormCompletionStepChooseIssue();
        this.bulkChangeChooseIssuesAll();
        this.bulkChangeNextWithoutFormCompletionStepChooseOperation();
        this.bulkChangeChooseOperationEdit();
        this.bulkChangeNextWithoutFormCompletionStepOperationDetails();
    }

    public void _testClickNextWithoutFormCompletionForOperationDelete() {
        TestBulkChangeIssues.log("Bulk Change - Errors: Click NEXT without form completion for operation Delete");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeNextWithoutFormCompletionStepChooseIssue();
        this.bulkChangeChooseIssuesAll();
        this.bulkChangeNextWithoutFormCompletionStepChooseOperation();
    }

    public void _testCancelLinkForStepChooseIssues() {
        TestBulkChangeIssues.log("Bulk Change - Navigation: Click CANCEL at step CHOOSE ISSUES");
        this.displayAllIssues();
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.bulkChangeIncludeAllPages();
        this.isStepChooseIssues();
        this.bulkChangeCancel();
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    public void _testCancelLinkForStepChooseOperation() {
        TestBulkChangeIssues.log("Bulk Change - Navigation: Click CANCEL at step CHOOSE OPERATION");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.bulkChangeChooseIssuesAll();
        this.isStepChooseOperation();
        this.bulkChangeCancel();
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    public void _testCancelLinkForStepOperationDetails() {
        TestBulkChangeIssues.log("Bulk Change - Navigation: Click CANCEL at step OPERATION DETAILS");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.bulkChangeChooseOperationEdit();
        this.isStepOperationDetails();
        this.bulkChangeCancel();
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    public void _testCancelLinkForStepConfirmationEdit() {
        TestBulkChangeIssues.log("Bulk Change - Navigation: Click CANCEL at step CONFIRMATION EDIT");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.bulkChangeChooseOperationEdit();
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("fixVersions", MY_OPTION_VERSION_ONE_UNESCAPED);
        fields.put("versions", "New Version 2");
        fields.put("components", MY_OPTION_COMPONENT_ONE_UNESCAPED);
        fields.put("assignee", "Administrator");
        fields.put("priority", "Blocker");
        this.bulkEditOperationDetailsSetAs(fields);
        this.isStepConfirmation();
        this.bulkChangeCancel();
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    public void _testCancelLinkForStepConfirmationDelete() {
        boolean mailServerExists = this.isMailServerExists();
        TestBulkChangeIssues.log("Bulk Change - Navigation: Click CANCEL at step CONFIRMATION DELETE");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.bulkChangeChooseOperationDelete(mailServerExists);
        this.isStepConfirmation();
        this.bulkChangeCancel();
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    public void _testSideBarLinks() {
        boolean mailServerExists = this.isMailServerExists();
        TestBulkChangeIssues.log("Bulk Change - Navigation: check side bar links are valid and working");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.checkSideBarLinksInStepChooseIssues();
        this.bulkChangeChooseIssuesAll();
        this.checkSideBarLinksInStepChooseOperation();
        this.checkLinkToStepChooseIssues();
        this.clickOnNext();
        this.bulkChangeChooseOperationEdit();
        this.checkSideBarLinksInStepOperationDetails();
        this.checkLinkToStepChooseOperation();
        this.bulkChangeChooseOperationEdit();
        this.checkLinkToStepChooseIssues();
        this.clickOnNext();
        this.bulkChangeChooseOperationEdit();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("priority", "Blocker");
        this.bulkEditOperationDetailsSetAs(fields);
        this.checkSideBarLinksInStepConfirmationForEditOp();
        this.checkLinkToStepOperationDetails();
        this.clickOnNext();
        this.checkLinkToStepChooseIssues();
        this.clickOnNext();
        this.bulkChangeChooseOperationEdit();
        this.clickOnNext();
        fields = new HashMap();
        fields.put("priority", "Critical");
        this.bulkEditOperationDetailsSetAs(fields);
        this.checkLinkToStepChooseOperation();
        this.bulkChangeChooseOperationDelete(mailServerExists);
        this.checkSideBarLinksInStepConfirmationForDeleteOp();
        this.checkLinkToStepChooseIssues();
        this.clickOnNext();
        this.bulkChangeChooseOperationDelete(mailServerExists);
        this.checkLinkToStepChooseOperation();
    }

    public void _testCheckIssueContentIncludeCurrentPageFromCurrentPage() {
        TestBulkChangeIssues.log("Bulk Change - Issue Content: Check correct issues are displayed, Include CURRENT page from CURRENT page");
        this.displayAllIssues();
        this.bulkChangeIncludeCurrentPage();
        this.assertLinkNotPresentWithText("this is on the next page");
        this.checkIssuesAreListed(PREFIX_ISSUE_ON_CURR_PG, 3);
    }

    public void _testCheckIssueContentIncludeCurrentPageFromNextPage() {
        TestBulkChangeIssues.log("Bulk Change - Issue Content: Check correct issues are displayed, Include CURRENT page from NEXT page");
        this.displayAllIssues();
        this.clickLinkWithText("Next >>");
        this.bulkChangeIncludeCurrentPage();
        this.assertLinkPresentWithText("this is on the next page");
        this.checkIssuesAreNotListed(PREFIX_ISSUE_ON_CURR_PG, 3);
    }

    public void _testCheckIssueContentIncludeAllPageFromCurrentPage() {
        TestBulkChangeIssues.log("Bulk Change - Issue Content: Check correct issues are displayed, Include All page from CURRENT page");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.assertLinkPresentWithText("this is on the next page");
        this.checkIssuesAreListed(PREFIX_ISSUE_ON_CURR_PG, 3);
    }

    public void _testCheckIssueContentIncludeAllPageFromNextPage() {
        TestBulkChangeIssues.log("Bulk Change - Issue Content: Check correct issues are displayed, Include All page from NEXT page");
        this.displayAllIssues();
        this.clickLinkWithText("Next >>");
        this.bulkChangeIncludeAllPages();
        this.assertLinkPresentWithText("this is on the next page");
        this.checkIssuesAreListed(PREFIX_ISSUE_ON_CURR_PG, 3);
    }

    protected void bulkChangeChooseIssuesSome() {
        this.isStepChooseIssues();
        for (int i = 0; i < 3; ++i) {
            this.selectCheckbox("bulkedit_" + issueID[i]);
        }
    }
}

