/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.webtests.JIRAWebTest;

public abstract class BulkChangeIssues
extends JIRAWebTest {
    protected static final int NUM_RESULTS_PER_PG = 50;
    protected static final String PROJECT_TEMP = "project_temp";
    protected static final String SUMMARY_ISSUE_ON_NEXT_PG = "this is on the next page";
    protected static final String SUMMARY_ISSUE_IN_PROJECT_TWO = "issue in project two";
    protected static final String SUMMARY_ISSUE_IN_PROJECT_TEMP = "issue in project temp";
    protected static final String LABEL_NO_ISSUE_FOUND = "No matching issues found";
    protected static final String ERROR_NEXT_CHOOSE_ISSUE = "You must select at least one issue to bulk edit.";
    protected static final String ERROR_NEXT_CHOOSE_OPERATION = "Please choose an operation from the list below.";
    protected static final String ERROR_NEXT_OPERATION_DETAILS = "You must select at least one bulk action to perform";
    protected static final String NOTE_MULTIPLE_PROJECTS = "This operation can be performed only on issues from ONE project.";
    protected static final String NOTE_NO_VERSIONS = "The project of the selected issue(s) does not have any versions.";
    protected static final String NOTE_NO_COMPONENTS = "The project of the selected issue(s) does not have any components.";
    protected static final String NOTE_NO_CUSTOM_FIELDS = "There are no available custom fields for the selected issues.";
    protected static final String FORM_QUICK_SEARCH = "quicksearch";
    protected static final String FIELD_SEARCH_STRING = "searchString";
    protected static final String OPTION_VERSION_ONE = "New Version 1";
    protected static final String OPTION_VERSION_TWO = "New Version 2";
    protected static final String OPTION_COMPONENT_ONE = "New Component 1";
    protected static final String OPTION_UNASSIGNED = "Unassigned";
    protected static final String OPTION_PRIORITY_ONE = "Blocker";
    protected static final String OPTION_PRIORITY_TWO = "Critical";
    protected static final String OPTION_PRIORITY_THREE = "Major";
    protected static final String OPTION_PRIORITY_FOUR = "Minor";
    protected static final String OPTION_PRIORITY_FIVE = "Trivial";
    protected static final String TYPE_PRIORITY_ONE = "Blocker";
    protected static final String TYPE_PRIORITY_TWO = "Critical";
    protected static final String TYPE_PRIORITY_THREE = "Major";
    protected static final String TYPE_PRIORITY_FOUR = "Minor";
    protected static final String TYPE_PRIORITY_FIVE = "Trivial";
    protected static final String FIELDS_UPDATE_AUTO = "All field values will be retained";

    public BulkChangeIssues(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
    }

    protected void bulkChangeSetup() {
        BulkChangeIssues.log("Bulk Change - Set Up: deleting ALL issues and adding projects, components, & versions");
        this.restoreData("TestBulkChangeSetup.xml");
    }

    protected String addIssue(String summary) {
        return this.addIssue("homosapien", "HSP", "Bug", summary, "Major", null, null, null, "Administrator", "test environment", "description for " + summary, null, null, null);
    }

    protected void addIssues(int numOfIssues) {
        for (int i = 0; i < numOfIssues; ++i) {
            this.addIssue("homosapien", "HSP", "Bug", "random_" + numOfIssues, "Major", null, null, null, "Administrator", "test environment", "\"generated by loop\"", null, null, null);
        }
    }

    protected void addIssues(String prefix, int numOfIssues) {
        for (int i = 0; i < numOfIssues; ++i) {
            this.addIssue("homosapien", "HSP", "Bug", prefix + i, "Major", null, null, null, "Administrator", "test environment", "\"generated by loop with prefix\"", null, null, null);
        }
    }

    protected String addIssueInProject(String summary, String project, String projectKey) {
        return this.addIssue(project, projectKey, "Bug", summary, "Critical", null, null, null, "Administrator", "environment", "this issue is not in project " + project, null, null, null);
    }

    protected void addCurrentPageLink() {
        this.displayAllIssues();
        while (!this.getDialog().isLinkPresentWithText("Next >>")) {
            this.addIssue("add current page link");
            this.displayAllIssues();
        }
    }

    protected boolean checkIssueIsDeleted(String summary) {
        if (!this.getDialog().hasForm(FORM_QUICK_SEARCH) || !this.getDialog().hasFormParameterNamed(FIELD_SEARCH_STRING)) {
            this.login("admin", "admin");
        }
        this.setFormElement(FIELD_SEARCH_STRING, summary);
        this.submit(FORM_QUICK_SEARCH);
        return !this.getDialog().isLinkPresentWithText(summary);
    }

    protected void bulkChangeNextWithoutFormCompletionStepChooseIssue() {
        this.clickOnNext();
        this.assertTextPresent("Errors");
        this.assertTextPresent(ERROR_NEXT_CHOOSE_ISSUE);
    }

    protected void bulkChangeNextWithoutFormCompletionStepChooseOperation() {
        this.clickOnNext();
        this.assertTextPresent("Errors");
        this.assertTextPresent(ERROR_NEXT_CHOOSE_OPERATION);
    }

    protected void bulkChangeNextWithoutFormCompletionStepOperationDetails() {
        this.clickOnNext();
        this.assertTextPresent("Errors");
        this.assertTextPresent(ERROR_NEXT_OPERATION_DETAILS);
    }

    protected void checkLabelForStepIssueNavigator(int page, int totalIssues) {
        int fromIssue = (page - 1) * 50 + 1;
        int toIssue = totalIssues - fromIssue < 50 ? totalIssues : fromIssue + 50 - 1;
        this.assertIssueNavigatorDisplaying(String.valueOf(fromIssue), String.valueOf(toIssue), String.valueOf(totalIssues));
        this.assertLinkPresentWithText("all " + totalIssues + " issue(s)");
        if (this.getDialog().isTextInResponse("Next >>")) {
            this.assertLinkPresent("bulkedit_curr_pg");
        }
    }

    protected void checkLabelForStepChooseOperation(int numOfSelectedIssues, int numOfSelectedProjects) {
        this.checkSideMenuLabel(numOfSelectedIssues, numOfSelectedProjects);
        this.assertTextPresent("Choose the operation you wish to perform on the selected <strong>" + numOfSelectedIssues + "</strong> issue(s).");
    }

    protected void checkLabelForStepOperationDetails(int numOfSelectedIssues, int numOfSelectedProjects) {
        this.checkSideMenuLabel(numOfSelectedIssues, numOfSelectedProjects);
        this.assertTextPresent("Choose the bulk action(s) you wish to perform on the selected <b>" + numOfSelectedIssues + "</b> issue(s).");
    }

    protected void checkLabelForStepConfirmationEdit(int numOfSelectedIssues, int numOfSelectedProjects) {
        this.checkSideMenuLabel(numOfSelectedIssues, numOfSelectedProjects);
        this.assertTextPresent("The above table summarises the changes you are about to make to the following <strong>" + numOfSelectedIssues + "</strong> issues. Do you wish to continue?");
    }

    protected void checkLabelForStepConfirmationDelete(int numOfSelectedIssues, int numOfSelectedProjects) {
        this.checkSideMenuLabel(numOfSelectedIssues, numOfSelectedProjects);
        this.assertTextPresent("Please confirm that you wish to delete the following <b>" + numOfSelectedIssues + "</b> issues.");
    }

    protected void checkSideMenuLabel(int numOfSelectedIssues, int numOfSelectedProjects) {
        this.assertTextPresent("Selected <strong>" + numOfSelectedIssues + "</strong> issues from <strong>" + numOfSelectedProjects + "</strong> project(s)");
    }

    protected void checkIssuesAreListed(String prefix, int max) {
        for (int i = 0; i < max; ++i) {
            this.assertLinkPresentWithText(prefix + i);
        }
    }

    protected void checkIssuesAreNotListed(String prefix, int max) {
        for (int i = 0; i < max; ++i) {
            this.assertLinkNotPresentWithText(prefix + i);
        }
    }

    protected void checkSideBarLinksInStepChooseIssues() {
        this.isStepChooseIssues();
        this.assertLinkNotPresentWithText("Choose Issues");
        this.assertLinkNotPresentWithText("Choose Operation");
        this.assertLinkNotPresentWithText("Operation Details");
        this.assertLinkNotPresentWithText("Confirmation");
    }

    protected void checkSideBarLinksInStepChooseOperation() {
        this.isStepChooseOperation();
        this.assertLinkPresentWithText("Choose Issues");
        this.assertLinkNotPresentWithText("Choose Operation");
        this.assertLinkNotPresentWithText("Operation Details");
        this.assertLinkNotPresentWithText("Confirmation");
    }

    protected void checkSideBarLinksInStepOperationDetails() {
        this.isStepOperationDetails();
        this.assertLinkPresentWithText("Choose Issues");
        this.assertLinkPresentWithText("Choose Operation");
        this.assertLinkNotPresentWithText("Operation Details");
        this.assertLinkNotPresentWithText("Confirmation");
    }

    protected void checkSideBarLinksInStepConfirmationForDeleteOp() {
        this.isStepConfirmation();
        this.assertLinkPresentWithText("Choose Issues");
        this.assertLinkPresentWithText("Choose Operation");
        this.assertLinkPresentWithText("Operation Details");
        this.assertLinkNotPresentWithText("Confirmation");
    }

    protected void checkSideBarLinksInStepConfirmationForEditOp() {
        this.isStepConfirmation();
        this.assertLinkPresentWithText("Choose Issues");
        this.assertLinkPresentWithText("Choose Operation");
        this.assertLinkPresentWithText("Operation Details");
        this.assertLinkNotPresentWithText("Confirmation");
    }

    protected void checkMultipleProjectNote() {
        this.assertTextPresent(NOTE_MULTIPLE_PROJECTS);
        this.assertFormElementNotPresent("fixVersions");
        this.assertFormElementNotPresent("versions");
        this.assertFormElementNotPresent("components");
    }

    protected void checkLinkToStepChooseIssues() {
        this.clickLinkWithText("Choose Issues");
        this.isStepChooseIssues();
    }

    protected void checkLinkToStepChooseOperation() {
        this.clickLinkWithText("Choose Operation");
        this.isStepChooseOperation();
    }

    protected void checkLinkToStepOperationDetails() {
        this.clickLinkWithText("Operation Details");
        this.isStepOperationDetails();
    }
}

