/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.navigation.issue.AttachmentsBlock;
import com.atlassian.jira.functest.framework.navigation.issue.FileAttachmentsList;
import com.atlassian.jira.functest.framework.navigation.issue.ImageAttachmentsGallery;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.collect.CollectionBuilder;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;

public interface TestAttachmentsBlockSortingOnViewIssue {
    public void testAttachmentsDefaultToSortingByNameInDescendingOrder() throws Exception;

    public void testCanSortAttachmentsByFileNameInAscendingOrder() throws Exception;

    public void testCanSortAttachmentsByFileNameInDescendingOrder() throws Exception;

    public void testCanSortAttachmentsByDateInAscendingOrder() throws Exception;

    public void testCanSortAttachmentsByDateInDescendingOrder() throws Exception;

    @WebTest(value={Category.FUNC_TEST, Category.BROWSING})
    public static class TestImageAttachmentsGallerySorting
    extends AbstractTestAttachmentsBlockSortingOnViewIssue
    implements TestAttachmentsBlockSortingOnViewIssue {
        @Override
        public void testAttachmentsDefaultToSortingByNameInDescendingOrder() throws Exception {
            List<ImageAttachmentsGallery.ImageAttachmentItem> expectedImageAttachments = CollectionBuilder.newBuilder(new ImageAttachmentsGallery.ImageAttachmentItem("200px-FCB.svg.png", "16 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB")).asList();
            List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = this.navigation.issue().attachments("HSP-1").gallery().get();
            TestImageAttachmentsGallerySorting.assertEquals(expectedImageAttachments, actualImageAttachments);
        }

        @Override
        public void testCanSortAttachmentsByFileNameInAscendingOrder() throws Exception {
            List<ImageAttachmentsGallery.ImageAttachmentItem> expectedImageAttachments = CollectionBuilder.newBuilder(new ImageAttachmentsGallery.ImageAttachmentItem("200px-FCB.svg.png", "16 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB")).asList();
            AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1");
            attachmentsBlock.sort(AttachmentsBlock.Sort.Key.NAME, AttachmentsBlock.Sort.Direction.ASCENDING);
            List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = attachmentsBlock.gallery().get();
            TestImageAttachmentsGallerySorting.assertEquals(expectedImageAttachments, actualImageAttachments);
            this.verifySortingSettingIsStickyDuringTheSession(expectedImageAttachments);
        }

        @Override
        public void testCanSortAttachmentsByFileNameInDescendingOrder() throws Exception {
            List<ImageAttachmentsGallery.ImageAttachmentItem> expectedImageAttachments = CollectionBuilder.newBuilder(new ImageAttachmentsGallery.ImageAttachmentItem("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("200px-FCB.svg.png", "16 kB")).asList();
            AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1");
            attachmentsBlock.sort(AttachmentsBlock.Sort.Key.NAME, AttachmentsBlock.Sort.Direction.DESCENDING);
            List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = attachmentsBlock.gallery().get();
            TestImageAttachmentsGallerySorting.assertEquals(expectedImageAttachments, actualImageAttachments);
            this.verifySortingSettingIsStickyDuringTheSession(expectedImageAttachments);
        }

        @Override
        public void testCanSortAttachmentsByDateInAscendingOrder() throws Exception {
            List<ImageAttachmentsGallery.ImageAttachmentItem> expectedImageAttachments = CollectionBuilder.newBuilder(new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("200px-FCB.svg.png", "16 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB")).asList();
            AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1");
            attachmentsBlock.sort(AttachmentsBlock.Sort.Key.DATE, AttachmentsBlock.Sort.Direction.ASCENDING);
            List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = attachmentsBlock.gallery().get();
            TestImageAttachmentsGallerySorting.assertEquals(expectedImageAttachments, actualImageAttachments);
            this.verifySortingSettingIsStickyDuringTheSession(expectedImageAttachments);
        }

        @Override
        public void testCanSortAttachmentsByDateInDescendingOrder() throws Exception {
            List<ImageAttachmentsGallery.ImageAttachmentItem> expectedImageAttachments = CollectionBuilder.newBuilder(new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("200px-FCB.svg.png", "16 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB")).asList();
            AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1");
            attachmentsBlock.sort(AttachmentsBlock.Sort.Key.DATE, AttachmentsBlock.Sort.Direction.DESCENDING);
            List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = attachmentsBlock.gallery().get();
            TestImageAttachmentsGallerySorting.assertEquals(expectedImageAttachments, actualImageAttachments);
            this.verifySortingSettingIsStickyDuringTheSession(expectedImageAttachments);
        }

        private void verifySortingSettingIsStickyDuringTheSession(List<ImageAttachmentsGallery.ImageAttachmentItem> expectedFileAttachmentsList) {
            this.navigation.gotoDashboard();
            AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1");
            List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = attachmentsBlock.gallery().get();
            TestImageAttachmentsGallerySorting.assertEquals(expectedFileAttachmentsList, actualImageAttachments);
        }
    }

    @WebTest(value={Category.FUNC_TEST, Category.BROWSING})
    public static class TestAttachmentsListSorting
    extends AbstractTestAttachmentsBlockSortingOnViewIssue
    implements TestAttachmentsBlockSortingOnViewIssue {
        @Override
        public void testAttachmentsDefaultToSortingByNameInDescendingOrder() throws Exception {
            List<FileAttachmentsList.FileAttachmentItem> expectedFileAttachmentsList = CollectionBuilder.newBuilder(FileAttachmentsList.Items.file("_fil\u00e5e", "0.0 kB", "Administrator", "06/May/10 12:13 PM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Atlassian.pdf", "193 kB", "Administrator", "06/May/10 11:27 AM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Printable.pdf", "98 kB", "Administrator", "06/May/10 12:02 PM"), FileAttachmentsList.Items.file("a", "0.0 kB", "Administrator", "06/May/10 12:12 PM"), FileAttachmentsList.Items.file("a1k4BJwT.jpg.part", "22 kB", "Administrator", "06/May/10 12:01 PM"), FileAttachmentsList.Items.file("\u00e1 file", "0.0 kB", "Administrator", "06/May/10 12:14 PM"), FileAttachmentsList.Items.file("build.xml", "1 kB", "Administrator", "06/May/10 12:00 PM"), FileAttachmentsList.Items.file("catalina.sh", "12 kB", "Administrator", "06/May/10 12:15 PM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:24 AM"), FileAttachmentsList.Items.file("pom.xml", "5 kB", "Administrator", "06/May/10 11:29 AM"), FileAttachmentsList.Items.file("pom.xml", "2 kB", "Administrator", "06/May/10 11:25 AM"), FileAttachmentsList.Items.file("Tickspot", "0.1 kB", "Administrator", "06/May/10 12:03 PM")).asList();
            List<FileAttachmentsList.FileAttachmentItem> actualFileAttachmentsList = this.navigation.issue().attachments("HSP-1").list().get();
            TestAttachmentsListSorting.assertEquals(expectedFileAttachmentsList, actualFileAttachmentsList);
        }

        @Override
        public void testCanSortAttachmentsByFileNameInAscendingOrder() throws Exception {
            List<FileAttachmentsList.FileAttachmentItem> expectedFileAttachmentsList = CollectionBuilder.newBuilder(FileAttachmentsList.Items.file("_fil\u00e5e", "0.0 kB", "Administrator", "06/May/10 12:13 PM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Atlassian.pdf", "193 kB", "Administrator", "06/May/10 11:27 AM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Printable.pdf", "98 kB", "Administrator", "06/May/10 12:02 PM"), FileAttachmentsList.Items.file("a", "0.0 kB", "Administrator", "06/May/10 12:12 PM"), FileAttachmentsList.Items.file("a1k4BJwT.jpg.part", "22 kB", "Administrator", "06/May/10 12:01 PM"), FileAttachmentsList.Items.file("\u00e1 file", "0.0 kB", "Administrator", "06/May/10 12:14 PM"), FileAttachmentsList.Items.file("build.xml", "1 kB", "Administrator", "06/May/10 12:00 PM"), FileAttachmentsList.Items.file("catalina.sh", "12 kB", "Administrator", "06/May/10 12:15 PM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:24 AM"), FileAttachmentsList.Items.file("pom.xml", "5 kB", "Administrator", "06/May/10 11:29 AM"), FileAttachmentsList.Items.file("pom.xml", "2 kB", "Administrator", "06/May/10 11:25 AM"), FileAttachmentsList.Items.file("Tickspot", "0.1 kB", "Administrator", "06/May/10 12:03 PM")).asList();
            AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1");
            attachmentsBlock.sort(AttachmentsBlock.Sort.Key.NAME, AttachmentsBlock.Sort.Direction.ASCENDING);
            List<FileAttachmentsList.FileAttachmentItem> actualFileAttachmentsList = attachmentsBlock.list().get();
            TestAttachmentsListSorting.assertEquals(expectedFileAttachmentsList, actualFileAttachmentsList);
            this.verifySortingSettingIsStickyDuringTheSession(expectedFileAttachmentsList);
        }

        @Override
        public void testCanSortAttachmentsByFileNameInDescendingOrder() throws Exception {
            List<FileAttachmentsList.FileAttachmentItem> expectedFileAttachmentsList = CollectionBuilder.newBuilder(FileAttachmentsList.Items.file("Tickspot", "0.1 kB", "Administrator", "06/May/10 12:03 PM"), FileAttachmentsList.Items.file("pom.xml", "2 kB", "Administrator", "06/May/10 11:25 AM"), FileAttachmentsList.Items.file("pom.xml", "5 kB", "Administrator", "06/May/10 11:29 AM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:24 AM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("catalina.sh", "12 kB", "Administrator", "06/May/10 12:15 PM"), FileAttachmentsList.Items.file("build.xml", "1 kB", "Administrator", "06/May/10 12:00 PM"), FileAttachmentsList.Items.file("\u00e1 file", "0.0 kB", "Administrator", "06/May/10 12:14 PM"), FileAttachmentsList.Items.file("a1k4BJwT.jpg.part", "22 kB", "Administrator", "06/May/10 12:01 PM"), FileAttachmentsList.Items.file("a", "0.0 kB", "Administrator", "06/May/10 12:12 PM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Printable.pdf", "98 kB", "Administrator", "06/May/10 12:02 PM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Atlassian.pdf", "193 kB", "Administrator", "06/May/10 11:27 AM"), FileAttachmentsList.Items.file("_fil\u00e5e", "0.0 kB", "Administrator", "06/May/10 12:13 PM")).asList();
            AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1");
            attachmentsBlock.sort(AttachmentsBlock.Sort.Key.NAME, AttachmentsBlock.Sort.Direction.DESCENDING);
            List<FileAttachmentsList.FileAttachmentItem> actualFileAttachmentsList = attachmentsBlock.list().get();
            TestAttachmentsListSorting.assertEquals(expectedFileAttachmentsList, actualFileAttachmentsList);
            this.verifySortingSettingIsStickyDuringTheSession(expectedFileAttachmentsList);
        }

        @Override
        public void testCanSortAttachmentsByDateInAscendingOrder() throws Exception {
            List<FileAttachmentsList.FileAttachmentItem> expectedFileAttachmentsList = CollectionBuilder.newBuilder(FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:24 AM"), FileAttachmentsList.Items.file("pom.xml", "2 kB", "Administrator", "06/May/10 11:25 AM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Atlassian.pdf", "193 kB", "Administrator", "06/May/10 11:27 AM"), FileAttachmentsList.Items.file("pom.xml", "5 kB", "Administrator", "06/May/10 11:29 AM"), FileAttachmentsList.Items.file("build.xml", "1 kB", "Administrator", "06/May/10 12:00 PM"), FileAttachmentsList.Items.file("a1k4BJwT.jpg.part", "22 kB", "Administrator", "06/May/10 12:01 PM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Printable.pdf", "98 kB", "Administrator", "06/May/10 12:02 PM"), FileAttachmentsList.Items.file("Tickspot", "0.1 kB", "Administrator", "06/May/10 12:03 PM"), FileAttachmentsList.Items.file("a", "0.0 kB", "Administrator", "06/May/10 12:12 PM"), FileAttachmentsList.Items.file("_fil\u00e5e", "0.0 kB", "Administrator", "06/May/10 12:13 PM"), FileAttachmentsList.Items.file("\u00e1 file", "0.0 kB", "Administrator", "06/May/10 12:14 PM"), FileAttachmentsList.Items.file("catalina.sh", "12 kB", "Administrator", "06/May/10 12:15 PM")).asList();
            AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1");
            attachmentsBlock.sort(AttachmentsBlock.Sort.Key.DATE, AttachmentsBlock.Sort.Direction.ASCENDING);
            List<FileAttachmentsList.FileAttachmentItem> actualFileAttachmentsList = attachmentsBlock.list().get();
            TestAttachmentsListSorting.assertEquals(expectedFileAttachmentsList, actualFileAttachmentsList);
            this.verifySortingSettingIsStickyDuringTheSession(expectedFileAttachmentsList);
        }

        @Override
        public void testCanSortAttachmentsByDateInDescendingOrder() throws Exception {
            List<FileAttachmentsList.FileAttachmentItem> expectedFileAttachmentsList = CollectionBuilder.newBuilder(FileAttachmentsList.Items.file("catalina.sh", "12 kB", "Administrator", "06/May/10 12:15 PM"), FileAttachmentsList.Items.file("\u00e1 file", "0.0 kB", "Administrator", "06/May/10 12:14 PM"), FileAttachmentsList.Items.file("_fil\u00e5e", "0.0 kB", "Administrator", "06/May/10 12:13 PM"), FileAttachmentsList.Items.file("a", "0.0 kB", "Administrator", "06/May/10 12:12 PM"), FileAttachmentsList.Items.file("Tickspot", "0.1 kB", "Administrator", "06/May/10 12:03 PM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Printable.pdf", "98 kB", "Administrator", "06/May/10 12:02 PM"), FileAttachmentsList.Items.file("a1k4BJwT.jpg.part", "22 kB", "Administrator", "06/May/10 12:01 PM"), FileAttachmentsList.Items.file("build.xml", "1 kB", "Administrator", "06/May/10 12:00 PM"), FileAttachmentsList.Items.file("pom.xml", "5 kB", "Administrator", "06/May/10 11:29 AM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Atlassian.pdf", "193 kB", "Administrator", "06/May/10 11:27 AM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("pom.xml", "2 kB", "Administrator", "06/May/10 11:25 AM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:24 AM")).asList();
            AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1");
            attachmentsBlock.sort(AttachmentsBlock.Sort.Key.DATE, AttachmentsBlock.Sort.Direction.DESCENDING);
            List<FileAttachmentsList.FileAttachmentItem> actualFileAttachmentsList = attachmentsBlock.list().get();
            TestAttachmentsListSorting.assertEquals(expectedFileAttachmentsList, actualFileAttachmentsList);
            this.verifySortingSettingIsStickyDuringTheSession(expectedFileAttachmentsList);
        }

        private void verifySortingSettingIsStickyDuringTheSession(List<FileAttachmentsList.FileAttachmentItem> expectedFileAttachmentsList) {
            this.navigation.gotoDashboard();
            AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1");
            List<FileAttachmentsList.FileAttachmentItem> actualAttachmentsList = attachmentsBlock.list().get();
            TestAttachmentsListSorting.assertEquals(expectedFileAttachmentsList, actualAttachmentsList);
        }
    }

    public static abstract class AbstractTestAttachmentsBlockSortingOnViewIssue
    extends FuncTestCase {
        @Override
        protected void setUpTest() {
            super.setUpTest();
            this.administration.restoreData("TestAttachmentsBlockSortingOnViewIssue.xml");
            this.removeAttachmentFilesFromJiraHome();
            this.copyAttachmentFilesToJiraHome();
            this.administration.generalConfiguration().setJiraLocale("English (Australia)");
        }

        @Override
        protected void tearDownTest() {
            this.removeAttachmentFilesFromJiraHome();
            super.tearDownTest();
        }

        protected final void copyAttachmentFilesToJiraHome() {
            File jiraAttachmentsPath = new File(this.administration.getCurrentAttachmentPath());
            File testAttachmentsPath = new File(this.environmentData.getXMLDataLocation(), "TestAttachmentsBlockSortingOnViewIssue/attachments");
            try {
                FileUtils.copyDirectory((File)testAttachmentsPath, (File)jiraAttachmentsPath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected final void removeAttachmentFilesFromJiraHome() {
            File jiraAttachmentsPath = new File(this.administration.getCurrentAttachmentPath());
            try {
                FileUtils.cleanDirectory((File)jiraAttachmentsPath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

