/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.upgrade;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.date.DateUtil;
import com.atlassian.jira.webtests.LicenseKeys;
import java.util.LinkedHashMap;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
public class TestUpgradeHistory
extends FuncTestCase {
    public void testUpgradeHistory3Versions() throws Exception {
        LinkedHashMap<String, String> replacements = new LinkedHashMap<String, String>();
        replacements.put("@@TIMESTAMP1@@", DateUtil.dateAsTimestamp(2009, 9, 11, 9, 45));
        replacements.put("@@TIMESTAMP2@@", DateUtil.dateAsTimestamp(2009, 9, 23, 12, 30));
        this.administration.restoreDataWithReplacedTokens("TestUpgradeHistory3Versions.xml", replacements);
        this.navigation.gotoAdminSection("system_info");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Last Upgrade", "v4.0#466", "Get more upgrade history details.");
        this.tester.clickLink("view_upgrade_history");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "4.0", "466", "23/Oct/09 12:30 PM", "3.8", "209", "11/Oct/09 9:45 AM", "3.7.3", "187", "(inferred)", "Unknown");
    }

    public void testUpgradeHistory2VersionsInferred() throws Exception {
        LinkedHashMap<String, String> replacements = new LinkedHashMap<String, String>();
        replacements.put("@@TIMESTAMP1@@", DateUtil.dateAsTimestamp(2009, 9, 23, 12, 30));
        this.administration.restoreDataWithReplacedTokens("TestUpgradeHistory2VersionsInferred.xml", replacements);
        this.navigation.gotoAdminSection("system_info");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Last Upgrade", "v4.0#466", "Get more upgrade history details.");
        this.tester.clickLink("view_upgrade_history");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "4.0", "466", "23/Oct/09 12:30 PM", "3.8", "209", "(inferred from 207)", "Unknown");
    }

    public void testUpgradeHistoryAfterSetUp() throws Exception {
        this.resetupJira();
        this.navigation.gotoAdminSection("system_info");
        TableCellLocator locator = new TableCellLocator(this.tester, "jirainfo", 8, 0);
        this.assertions.getTextAssertions().assertTextPresent(locator, "Last Upgrade");
        locator = new TableCellLocator(this.tester, "jirainfo", 8, 1);
        this.assertions.getTextAssertions().assertTextNotPresent(locator, "(v");
        this.assertions.getTextAssertions().assertTextNotPresent(locator, "#");
        this.assertions.getTextAssertions().assertTextNotPresent(locator, ")");
        this.tester.clickLink("view_upgrade_history");
        TestUpgradeHistory.assertEquals((String)"Found more than 2 rows in the upgrade history table", (int)2, (int)this.tester.getDialog().getWebTableBySummaryOrId("upgradehistory").getRowCount());
    }

    private void resetupJira() {
        this.administration.restoreNotSetupInstance();
        this.tester.gotoPage("secure/Setup.jspa");
        this.tester.assertTextPresent("Step 2 of 4: Application properties");
        this.tester.setWorkingForm("jira-setupwizard");
        this.tester.setFormElement("title", "My JIRA");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        this.tester.assertTextPresent("Step 3 of 4: Administrator account");
        this.tester.setFormElement("username", "admin");
        this.tester.setFormElement("password", "admin");
        this.tester.setFormElement("confirm", "admin");
        this.tester.setFormElement("fullname", "Mary Magdelene");
        this.tester.setFormElement("email", "admin@example.com");
        this.tester.submit();
        this.tester.assertTextPresent("Step 4 of 4: Email Notification");
        this.log("Noemail");
        this.tester.submit("finish");
        this.log("Noemail");
        this.tester.assertTextPresent("Setup Complete");
        this.navigation.login("admin");
    }
}

