/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.statuses;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
public class TestStatuses
extends FuncTestCase {
    public void testWorkflowLinksUrlEncoded() {
        this.administration.restoreData("TestStatuses.xml");
        this.navigation.gotoAdminSection("statuses");
        this.tester.assertTextNotPresent("workflowName=<xxx>Crazy workflow</xxx>");
        this.tester.assertTextPresent("workflowName=%3Cxxx%3ECrazy+workflow%3C%2Fxxx%3E");
    }

    public void testDeleteActiveStatusViaUrlFails() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdmin();
        this.tester.clickLink("statuses");
        this.tester.assertLinkNotPresentWithText("Delete");
        this.tester.gotoPage("secure/admin/DeleteStatus!default.jspa?id=1");
        this.tester.assertTextPresent("Delete Status: Open");
        this.tester.assertTextPresent("Confirm that you want to delete this status ...");
        this.tester.assertTextNotPresent("The status with ID 1 is currently associated with a workflow(s) and cannot be deleted.");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Delete Status: Open");
        this.tester.assertTextPresent("Confirm that you want to delete this status ...");
        this.tester.assertTextPresent("The status with ID 1 is currently associated with a workflow(s) and cannot be deleted.");
    }

    public void testDeletePassiveStatusViaSucceeds() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdmin();
        this.tester.clickLink("statuses");
        this.tester.assertLinkNotPresentWithText("Delete");
        this.tester.setFormElement("name", "Not used");
        this.tester.setFormElement("description", "why bother");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Not used");
        this.tester.assertTextPresent("why bother");
        this.tester.assertLinkPresentWithText("Delete");
        this.tester.assertLinkPresent("del_10000");
        this.tester.gotoPage("secure/admin/DeleteStatus!default.jspa?id=10000");
        this.tester.assertTextPresent("Delete Status: Not used");
        this.tester.assertTextPresent("Confirm that you want to delete this status ...");
        this.tester.submit("Delete");
        this.tester.assertTextNotPresent("Not used");
        this.tester.assertTextNotPresent("why bother");
        this.tester.assertLinkNotPresentWithText("Delete");
        this.tester.assertLinkNotPresent("del_10000");
    }

    public void testEditStatusAlreadyExists() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdmin();
        this.tester.clickLink("statuses");
        this.tester.setFormElement("name", "closed");
        this.tester.submit();
        this.assertDuplicateStatusError();
        this.tester.setFormElement("name", "CLOSED");
        this.tester.submit();
        this.assertDuplicateStatusError();
        this.tester.gotoPage("secure/admin/EditStatus!default.jspa?id=5");
        this.tester.setFormElement("name", "closed");
        this.tester.submit();
        this.assertDuplicateStatusError();
        this.tester.setFormElement("name", "CLOSED");
        this.tester.submit();
        this.assertDuplicateStatusError();
    }

    public void testRenamePropagates() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdmin();
        this.tester.clickLink("workflows");
        this.tester.clickLink("steps_live_jira");
        this.navigation.gotoAdmin();
        this.tester.clickLink("statuses");
        this.tester.gotoPage("secure/admin/EditStatus!default.jspa?id=5");
        this.tester.assertFormElementEquals("name", "Resolved");
        this.tester.setFormElement("name", "what-do-you-mean-resolved");
        this.tester.submit();
        this.navigation.gotoAdmin();
        this.tester.clickLink("workflows");
        this.tester.clickLink("steps_live_jira");
        this.tester.assertTextPresent("what-do-you-mean-resolved");
        this.tester.gotoPage("secure/admin/EditStatus!default.jspa?id=5");
        this.tester.setFormElement("name", "Resolved");
        this.tester.submit();
    }

    private void assertDuplicateStatusError() {
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("A status with that name already exists.");
    }
}

