/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Element;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
public class TestXsrfImportAndExport
extends FuncTestCase {
    public void testProjectImportExport() throws Exception {
        this.administration.restoreBlankInstance();
        final String tempFilePath = this.getTempFilePath(".xml");
        new XsrfTestSuite(new XsrfCheck("ExportXmlData", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfImportAndExport.this.navigation.gotoAdminSection("backup_data");
                TestXsrfImportAndExport.this.tester.setFormElement("filename", tempFilePath);
            }
        }, new BackupFormSubmission()), new XsrfCheck("ImportXmlData", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfImportAndExport.this.navigation.gotoAdminSection("restore_data");
                TestXsrfImportAndExport.this.tester.setFormElement("filename", tempFilePath);
            }
        }, new XsrfCheck.FormSubmission("Restore"))).run(this.funcTestHelperFactory);
    }

    public void testProjectImport() throws Exception {
        new XsrfTestSuite(new XsrfCheck("ProjectImport", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfImportAndExport.this.administration.projectImport().doImportToSummary("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataNoProject.xml", null);
            }
        }, new XsrfCheck.FormSubmission("Import"))).run(this.funcTestHelperFactory);
    }

    private String getTempFilePath(String suffix) {
        File tempFile;
        try {
            tempFile = File.createTempFile("TestXsrfImportAndExport_Export", suffix);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tempFile.getAbsolutePath();
    }

    private class BackupFormSubmission
    extends XsrfCheck.FormSubmission {
        public BackupFormSubmission() {
            super("Backup");
        }

        @Override
        public void submitRequest() {
            super.submitRequest();
            Element replaceSubmit = TestXsrfImportAndExport.this.tester.getDialog().getElement("Replace File");
            if (replaceSubmit != null) {
                TestXsrfImportAndExport.this.tester.submit("Replace File");
            }
        }
    }
}

