/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.IOException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
public class TestXsrfCvsModules
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testCvsModuleAdministration() throws Exception {
        new XsrfTestSuite(new XsrfCheck("AddCvsModule", new CvsModuleSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfCvsModules.this.tester.clickLink("add_cvs_module");
                TestXsrfCvsModules.this.tester.setFormElement("name", "MyModule");
                TestXsrfCvsModules.this.tester.setFormElement("cvsRoot", ":pserver:anonymous@example.com:/");
                TestXsrfCvsModules.this.tester.setFormElement("moduleName", "dummy");
                TestXsrfCvsModules.this.tester.checkCheckbox("fetchLog", "false");
                try {
                    TestXsrfCvsModules.this.tester.setFormElement("logFilePath", TestXsrfCvsModules.this.getEnvironmentData().getXMLDataLocation().getCanonicalPath() + "/TestCvsIntegration.log");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, new XsrfCheck.FormSubmission(" Add ")), new XsrfCheck("EditCvsModule", new CvsModuleSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfCvsModules.this.tester.clickLink("edit_10000");
                TestXsrfCvsModules.this.tester.setFormElement("description", "This is MyModule");
            }
        }, new XsrfCheck.FormSubmission(" Update ")), new XsrfCheck("TestCvsModule", new CvsModuleSetup(), new XsrfCheck.LinkWithIdSubmission("test_10000")), new XsrfCheck("DeleteCvsModule", new CvsModuleSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfCvsModules.this.tester.clickLink("delete_10000");
            }
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.funcTestHelperFactory);
    }

    private class CvsModuleSetup
    implements XsrfCheck.Setup {
        private CvsModuleSetup() {
        }

        @Override
        public void setup() {
            TestXsrfCvsModules.this.navigation.gotoAdminSection("cvs_modules");
        }
    }
}

