/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.scheme;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SCHEMES})
public class TestSchemePurgeTool
extends JIRAWebTest {
    public TestSchemePurgeTool(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestSchemeMergeTool.xml");
    }

    public void testDeleteAllPermissionSchemes() throws SAXException {
        this.gotoPage("secure/admin/SchemePurgeTypePicker!default.jspa");
        this.assertTextPresent("Bulk Delete Schemes: Select Schemes");
        WebTable schemeTable = this.getDialog().getResponse().getTableWithID("purge_schemes_PermissionScheme");
        TestSchemePurgeTool.assertEquals((String)"Correct number of rows", (int)4, (int)schemeTable.getRowCount());
        TestSchemePurgeTool.assertTrue((boolean)this.tableCellHasText(schemeTable, 1, 1, "Another Permission Scheme"));
        TestSchemePurgeTool.assertTrue((boolean)this.tableCellHasText(schemeTable, 2, 1, "Copy of Another Permission Scheme"));
        TestSchemePurgeTool.assertTrue((boolean)this.tableCellHasText(schemeTable, 3, 1, "Copy of Default Permission Scheme"));
        this.checkCheckbox("selectedSchemeIds", "10000");
        this.checkCheckbox("selectedSchemeIds", "10001");
        this.checkCheckbox("selectedSchemeIds", "10002");
        this.submit("Preview");
        this.assertTextPresent("Bulk Delete Schemes: Confirm Schemes to Delete");
        this.assertTextPresent("Another Permission Scheme");
        this.assertTextPresent("Copy of Another Permission Scheme");
        this.assertTextPresent("Copy of Default Permission Scheme");
        this.submit("Delete Schemes");
        this.assertTextPresent("Bulk Delete Schemes: Results");
        this.assertTextPresent("Another Permission Scheme");
        this.assertTextPresent("Copy of Another Permission Scheme");
        this.assertTextPresent("Copy of Default Permission Scheme");
        this.gotoPage("secure/admin/ViewPermissionSchemes.jspa");
        this.assertTextNotPresent("Another Permission Scheme");
        this.assertTextNotPresent("Copy of Another Permission Scheme");
        this.assertTextNotPresent("Copy of Default Permission Scheme");
        this.assertTextPresent("Default Permission Scheme");
    }

    public void testDeleteAllNotificationSchemes() throws SAXException {
        this.gotoPage("secure/admin/SchemePurgeTypePicker!return.jspa?selectedSchemeType=NotificationScheme");
        this.assertTextPresent("Bulk Delete Schemes: Select Schemes");
        WebTable schemeTable = this.getDialog().getResponse().getTableWithID("purge_schemes_NotificationScheme");
        TestSchemePurgeTool.assertEquals((String)"Correct number of rows", (int)4, (int)schemeTable.getRowCount());
        TestSchemePurgeTool.assertTrue((boolean)this.tableCellHasText(schemeTable, 1, 1, "Another Notification Scheme"));
        TestSchemePurgeTool.assertTrue((boolean)this.tableCellHasText(schemeTable, 2, 1, "Copy of Another Notification Scheme"));
        TestSchemePurgeTool.assertTrue((boolean)this.tableCellHasText(schemeTable, 3, 1, "Copy of Default Notification Scheme"));
        this.checkCheckbox("selectedSchemeIds", "10010");
        this.checkCheckbox("selectedSchemeIds", "10011");
        this.checkCheckbox("selectedSchemeIds", "10012");
        this.submit("Preview");
        this.assertTextPresent("Bulk Delete Schemes: Confirm Schemes to Delete");
        this.assertTextPresent("Another Notification Scheme");
        this.assertTextPresent("Copy of Another Notification Scheme");
        this.assertTextPresent("Copy of Default Notification Scheme");
        this.submit("Delete Schemes");
        this.assertTextPresent("Bulk Delete Schemes: Results");
        this.assertTextPresent("Another Notification Scheme");
        this.assertTextPresent("Copy of Another Notification Scheme");
        this.assertTextPresent("Copy of Default Notification Scheme");
        this.gotoPage("secure/admin/ViewNotificationSchemes.jspa");
        this.assertTextNotPresent("Another Notification Scheme");
        this.assertTextNotPresent("Copy of Another Notification Scheme");
        this.assertTextNotPresent("Copy of Default Notification Scheme");
        this.assertTextPresent("Default Notification Scheme");
    }

    public void testDeleteWithNoSelectedSchemes() {
        this.gotoPage("secure/admin/SchemePurgeTypePicker!default.jspa");
        this.assertTextPresent("Bulk Delete Schemes: Select Schemes");
        this.submit("Preview");
        this.assertTextPresent("No schemes were selected. Please select at least one scheme.");
    }

    public void testAssociatingASchemeWhileDeleting() {
        this.gotoPage("secure/admin/SchemePurgeTypePicker!default.jspa");
        this.checkCheckbox("selectedSchemeIds", "10000");
        this.checkCheckbox("selectedSchemeIds", "10001");
        this.checkCheckbox("selectedSchemeIds", "10002");
        this.submit("Preview");
        this.associatePermSchemeToProject("homosapien", "Another Permission Scheme");
        this.gotoPage("secure/admin/SchemePurgeToolPreview!default.jspa?selectedSchemeType=PermissionScheme");
        this.submit("Delete Schemes");
        this.assertTextPresent("Can not delete scheme, <strong>Another Permission Scheme</strong>. It has been associated with a project since it was originally selected.");
        this.assertTextPresent("Copy of Another Permission Scheme");
        this.assertTextPresent("Copy of Default Permission Scheme");
        this.gotoPage("secure/admin/ViewPermissionSchemes.jspa");
        this.assertTextPresent("Another Permission Scheme");
        this.assertTextNotPresent("Copy of Another Permission Scheme");
        this.assertTextNotPresent("Copy of Default Permission Scheme");
        this.assertTextPresent("Default Permission Scheme");
    }

    public void testCannotDeleteDefaultPermissionScheme() {
        this.restoreData("TestPurgeDefaultPermissionScheme.xml");
        this.gotoPage("secure/admin/SchemePurgeTypePicker!default.jspa");
        this.assertTextNotPresent("Default Permission Scheme");
        this.gotoPage("secure/admin/SchemePurgeToolPreview!default.jspa?selectedSchemeType=PermissionScheme&selectedSchemeIds=0");
        this.submit("Delete Schemes");
        this.gotoPage("secure/admin/ViewPermissionSchemes.jspa");
        this.assertTextPresent("Default Permission Scheme");
    }
}

