/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.scheme;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SCHEMES})
public class TestSchemeMergeTool
extends JIRAWebTest {
    public TestSchemeMergeTool(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestSchemeMergeTool.xml");
    }

    public void testNoPermissionSchemesCanMerge() {
        this.gotoPage("secure/admin/SchemeTypePicker!default.jspa");
        this.assertTextPresent("Merge Schemes: Select Schemes");
        this.submit("Analyse Schemes");
        this.assertTextPresent("Merge Schemes: Choose Schemes to Merge");
        this.assertTextPresent("There are no associated permission schemes which can be merged at this time");
        this.assertTextNotPresent("Preview Changes");
    }

    public void testNoNotificationSchemesCanMerge() {
        this.gotoPage("secure/admin/SchemeTypePicker!switch.jspa?typeOfSchemesToDisplay=associated&selectedSchemeType=NotificationScheme");
        this.assertTextPresent("Merge Schemes: Select Schemes");
        this.submit("Analyse Schemes");
        this.assertTextPresent("Merge Schemes: Choose Schemes to Merge");
        this.assertTextPresent("There are no associated notification schemes which can be merged at this time");
        this.assertTextNotPresent("Preview Changes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPermissionSchemesCanMerge() throws SAXException {
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.gotoPage("secure/admin/SchemeTypePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=PermissionScheme");
            this.assertTextPresent("Merge Schemes: Select Schemes");
            this.submit("Analyse Schemes");
            this.assertTextPresent("Merge Schemes: Choose Schemes to Merge");
            this.assertTextPresentBeforeText("4", "2");
            WebTable mergedSchemeTable = this.getDialog().getResponse().getTableWithID("merged_schemes");
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(mergedSchemeTable, 1, 1, "Copy of Another Permission Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(mergedSchemeTable, 1, 1, "Another Permission Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(mergedSchemeTable, 1, 1, "Copy of Default Permission Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(mergedSchemeTable, 1, 1, "Default Permission Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(mergedSchemeTable, 2, 1, "Copy of Default Permission Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(mergedSchemeTable, 2, 1, "Default Permission Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(mergedSchemeTable, 2, 1, "Copy of Another Permission Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(mergedSchemeTable, 2, 1, "Another Permission Scheme"));
            this.checkCheckbox("selectedDistilledSchemes", "Clone of Another Permission Scheme");
            this.checkCheckbox("selectedDistilledSchemes", "Clone of Copy of Default Permission Scheme");
            this.setFormElement("Clone of Copy of Default Permission Scheme", "New_Scheme_1");
            this.setFormElement("Clone of Another Permission Scheme", "New_Scheme_2");
            this.assertTextPresent("Preview Changes");
            this.assertTextPresent("Cancel");
            this.submit("Preview Changes");
            this.assertTextPresent("<strong>all</strong>");
            this.assertTextPresent("Adding scheme: <strong>New_Scheme_1</strong>");
            this.assertTextPresent("Adding scheme: <strong>New_Scheme_2</strong>");
            WebTable newSchemeTable1 = this.getDialog().getResponse().getTableWithID("New_Scheme_1_table");
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable1, 1, 0, "Copy of Default Permission Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable1, 1, 0, "Default Permission Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(newSchemeTable1, 1, 0, "Copy of Another Permission Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(newSchemeTable1, 1, 0, "Another Permission Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable1, 1, 1, "homosapien"));
            WebTable newSchemeTable2 = this.getDialog().getResponse().getTableWithID("New_Scheme_2_table");
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(newSchemeTable2, 1, 0, "Copy of Default Permission Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(newSchemeTable2, 1, 0, "Default Permission Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable2, 1, 0, "Copy of Another Permission Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable2, 1, 0, "Another Permission Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(newSchemeTable2, 1, 1, "homosapien"));
            this.assertTextPresent("Submit Changes");
            this.assertTextPresent("Cancel");
            this.submit("Submit Changes");
            this.assertTextPresent("Merge Schemes: Results");
            this.assertTextPresent("You have successfully saved the following merged scheme(s)");
            this.assertTextPresent("New_Scheme_1");
            this.assertTextPresent("has been associated with project(s):");
            this.assertTextPresent("homosapien");
            this.assertTextPresent("New_Scheme_2");
            this.assertTextPresent("bulk delete schemes tool");
            this.clickLinkWithText("bulk delete schemes tool");
            this.assertTextPresent("Bulk Delete Schemes: Select Schemes");
            this.gotoPage("/plugins/servlet/project-config/HSP/permissions");
            this.assertions.assertNodeByIdHasText("project-config-header-name", "homosapien");
            this.assertions.assertNodeByIdHasText("project-config-permissions-scheme-name", "New_Scheme_1");
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotificationSchemesCanMerge() throws SAXException {
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.gotoPage("secure/admin/SchemeTypePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
            this.assertTextPresent("Merge Schemes: Select Schemes");
            this.submit("Analyse Schemes");
            this.assertTextPresent("Merge Schemes: Choose Schemes to Merge");
            this.assertTextPresentBeforeText("4", "2");
            WebTable mergedSchemeTable = this.getDialog().getResponse().getTableWithID("merged_schemes");
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(mergedSchemeTable, 1, 1, "Copy of Another Notification Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(mergedSchemeTable, 1, 1, "Another Notification Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(mergedSchemeTable, 1, 1, "Copy of Default Notification Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(mergedSchemeTable, 1, 1, "Default Notification Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(mergedSchemeTable, 2, 1, "Copy of Default Notification Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(mergedSchemeTable, 2, 1, "Default Notification Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(mergedSchemeTable, 2, 1, "Copy of Another Notification Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(mergedSchemeTable, 2, 1, "Another Notification Scheme"));
            this.checkCheckbox("selectedDistilledSchemes", "Clone of Another Notification Scheme");
            this.checkCheckbox("selectedDistilledSchemes", "Clone of Copy of Default Notification Scheme");
            this.setFormElement("Clone of Copy of Default Notification Scheme", "New_Scheme_1");
            this.setFormElement("Clone of Another Notification Scheme", "New_Scheme_2");
            this.assertTextPresent("Preview Changes");
            this.assertTextPresent("Cancel");
            this.submit("Preview Changes");
            this.assertTextPresent("<strong>all</strong>");
            this.assertTextPresent("Adding scheme: <strong>New_Scheme_1</strong>");
            this.assertTextPresent("Adding scheme: <strong>New_Scheme_2</strong>");
            WebTable newSchemeTable1 = this.getDialog().getResponse().getTableWithID("New_Scheme_1_table");
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable1, 1, 0, "Copy of Default Notification Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable1, 1, 0, "Default Notification Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(newSchemeTable1, 1, 0, "Copy of Another Notification Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(newSchemeTable1, 1, 0, "Another Notification Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable1, 1, 1, "homosapien"));
            WebTable newSchemeTable2 = this.getDialog().getResponse().getTableWithID("New_Scheme_2_table");
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(newSchemeTable2, 1, 0, "Copy of Default Notification Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(newSchemeTable2, 1, 0, "Default Notification Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable2, 1, 0, "Copy of Another Notification Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable2, 1, 0, "Another Notification Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(newSchemeTable2, 1, 1, "homosapien"));
            this.assertTextPresent("Submit Changes");
            this.assertTextPresent("Cancel");
            this.submit("Submit Changes");
            this.assertTextPresent("Merge Schemes: Results");
            this.assertTextPresent("You have successfully saved the following merged scheme(s)");
            this.assertTextPresent("New_Scheme_1");
            this.assertTextPresent("has been associated with project(s):");
            this.assertTextPresent("homosapien");
            this.assertTextPresent("New_Scheme_2");
            this.gotoPage("/plugins/servlet/project-config/HSP/notifications");
            this.assertions.assertNodeByIdHasText("project-config-header-name", "homosapien");
            this.assertions.assertNodeByIdHasText("project-config-notification-scheme-name", "New_Scheme_1");
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
    }

    public void testSelectNoSchemes() {
        this.gotoPage("secure/admin/SchemeTypePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
        this.submit("Analyse Schemes");
        this.submit("Preview Changes");
        this.assertTextPresent("You must select at least one set of schemes to merge.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnterDuplicateSchemeNames() throws SAXException {
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.gotoPage("secure/admin/SchemeTypePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
            this.submit("Analyse Schemes");
            this.checkCheckbox("selectedDistilledSchemes", "Clone of Another Notification Scheme");
            this.checkCheckbox("selectedDistilledSchemes", "Clone of Copy of Default Notification Scheme");
            this.setFormElement("Clone of Copy of Default Notification Scheme", "New_Scheme_1");
            this.setFormElement("Clone of Another Notification Scheme", "New_Scheme_1");
            this.submit("Preview Changes");
            WebTable newSchemeTable1 = this.getDialog().getResponse().getTableWithID("merged_schemes");
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable1, 1, 2, "You have entered this scheme name more than once."));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable1, 2, 2, "You have entered this scheme name more than once."));
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnterExistingSchemeName() throws SAXException {
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.gotoPage("secure/admin/SchemeTypePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
            this.submit("Analyse Schemes");
            this.checkCheckbox("selectedDistilledSchemes", "Clone of Copy of Default Notification Scheme");
            this.setFormElement("Clone of Copy of Default Notification Scheme", "Another Notification Scheme");
            this.submit("Preview Changes");
            WebTable newSchemeTable1 = this.getDialog().getResponse().getTableWithID("merged_schemes");
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable1, 2, 2, "A scheme with the name you entered already exists. Please enter a different scheme name."));
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnterExistingSchemeNameWithWhitespace() throws SAXException {
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.gotoPage("secure/admin/SchemeTypePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
            this.submit("Analyse Schemes");
            this.checkCheckbox("selectedDistilledSchemes", "Clone of Copy of Default Notification Scheme");
            this.setFormElement("Clone of Copy of Default Notification Scheme", "Another Notification Scheme     ");
            this.submit("Preview Changes");
            WebTable newSchemeTable1 = this.getDialog().getResponse().getTableWithID("merged_schemes");
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable1, 2, 2, "A scheme with the name you entered already exists. Please enter a different scheme name."));
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteSchemeDuringPreview() {
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.gotoPage("secure/admin/SchemeTypePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
            this.submit("Analyse Schemes");
            this.checkCheckbox("selectedDistilledSchemes", "Clone of Copy of Default Notification Scheme");
            this.setFormElement("Clone of Copy of Default Notification Scheme", "New_Scheme_1");
            this.submit("Preview Changes");
            this.gotoPage("secure/admin/DeleteNotificationScheme!default.jspa?schemeId=10010");
            this.submit("Delete");
            this.gotoPage("secure/admin/SchemeMergePreview!default.jspa?selectedSchemeType=NotificationScheme&typeOfSchemesToDisplay=all");
            this.submit("Submit Changes");
            this.assertTextPresent("Could not save merged scheme <strong>New_Scheme_1</strong>:");
            this.assertTextPresent("Some of the original schemes (<strong>Copy of Default Notification Scheme</strong>)");
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModifySchemeEntitiesDuringPreview() {
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.gotoPage("secure/admin/SchemeTypePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
            this.submit("Analyse Schemes");
            this.checkCheckbox("selectedDistilledSchemes", "Clone of Copy of Default Notification Scheme");
            this.checkCheckbox("selectedDistilledSchemes", "Clone of Another Notification Scheme");
            this.setFormElement("Clone of Copy of Default Notification Scheme", "New_Scheme_1");
            this.setFormElement("Clone of Another Notification Scheme", "New_Scheme_2");
            this.submit("Preview Changes");
            this.gotoPage("secure/admin/DeleteNotification!default.jspa?schemeId=10000&id=10003");
            this.submit("Delete");
            this.gotoPage("secure/admin/DeleteNotification!default.jspa?schemeId=10010&id=10078");
            this.submit("Delete");
            this.gotoPage("secure/admin/SchemeMergePreview!default.jspa?selectedSchemeType=NotificationScheme&typeOfSchemesToDisplay=all");
            this.submit("Submit Changes");
            this.assertTextPresent("Could not save merged scheme <strong>New_Scheme_1</strong>:");
            this.assertTextPresent("Some of the original schemes (<strong>Copy of Default Notification Scheme, Default Notification Scheme</strong>)");
            this.assertTextPresent("You have successfully saved the following merged scheme(s)");
            this.assertTextPresent("New_Scheme_2");
            this.assertTextNotPresent("has been associated with project(s):");
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModifySchemeNameDuringPreview() {
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.gotoPage("secure/admin/SchemeTypePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
            this.submit("Analyse Schemes");
            this.checkCheckbox("selectedDistilledSchemes", "Clone of Copy of Default Notification Scheme");
            this.checkCheckbox("selectedDistilledSchemes", "Clone of Another Notification Scheme");
            this.setFormElement("Clone of Copy of Default Notification Scheme", "New_Scheme_1");
            this.setFormElement("Clone of Another Notification Scheme", "New_Scheme_2");
            this.submit("Preview Changes");
            this.gotoPage("secure/admin/EditNotificationScheme!default.jspa?schemeId=10010");
            this.setFormElement("name", "A new name");
            this.submit("Update");
            this.gotoPage("secure/admin/SchemeMergePreview!default.jspa?selectedSchemeType=NotificationScheme&typeOfSchemesToDisplay=all");
            this.submit("Submit Changes");
            this.assertTextPresent("Could not save merged scheme <strong>New_Scheme_1</strong>:");
            this.assertTextPresent("Some of the original schemes (<strong>Copy of Default Notification Scheme</strong>)");
            this.assertTextPresent("You have successfully saved the following merged scheme(s)");
            this.assertTextPresent("New_Scheme_2");
            this.assertTextNotPresent("has been associated with project(s):");
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModifySchemeDescDuringPreview() {
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.gotoPage("secure/admin/SchemeTypePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
            this.submit("Analyse Schemes");
            this.checkCheckbox("selectedDistilledSchemes", "Clone of Copy of Default Notification Scheme");
            this.checkCheckbox("selectedDistilledSchemes", "Clone of Another Notification Scheme");
            this.setFormElement("Clone of Copy of Default Notification Scheme", "New_Scheme_1");
            this.setFormElement("Clone of Another Notification Scheme", "New_Scheme_2");
            this.submit("Preview Changes");
            this.gotoPage("secure/admin/EditNotificationScheme!default.jspa?schemeId=10010");
            this.setFormElement("description", "A new description");
            this.submit("Update");
            this.gotoPage("secure/admin/SchemeMergePreview!default.jspa?selectedSchemeType=NotificationScheme&typeOfSchemesToDisplay=all");
            this.submit("Submit Changes");
            this.assertTextPresent("Could not save merged scheme <strong>New_Scheme_1</strong>:");
            this.assertTextPresent("Some of the original schemes (<strong>Copy of Default Notification Scheme</strong>)");
            this.assertTextPresent("You have successfully saved the following merged scheme(s)");
            this.assertTextPresent("New_Scheme_2");
            this.assertTextNotPresent("has been associated with project(s):");
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCancelSchemePreview() throws SAXException {
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.gotoPage("secure/admin/SchemeTypePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
            this.submit("Analyse Schemes");
            this.checkCheckbox("selectedDistilledSchemes", "Clone of Copy of Default Notification Scheme");
            this.checkCheckbox("selectedDistilledSchemes", "Clone of Another Notification Scheme");
            this.setFormElement("Clone of Copy of Default Notification Scheme", "New_Scheme_1");
            this.setFormElement("Clone of Another Notification Scheme", "New_Scheme_2");
            this.submit("Preview Changes");
            WebTable newSchemeTable1 = this.getDialog().getResponse().getTableWithID("New_Scheme_1_table");
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable1, 1, 0, "Copy of Default Notification Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable1, 1, 0, "Default Notification Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(newSchemeTable1, 1, 0, "Copy of Another Notification Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(newSchemeTable1, 1, 0, "Another Notification Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable1, 1, 1, "homosapien"));
            WebTable newSchemeTable2 = this.getDialog().getResponse().getTableWithID("New_Scheme_2_table");
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(newSchemeTable2, 1, 0, "Copy of Default Notification Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(newSchemeTable2, 1, 0, "Default Notification Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable2, 1, 0, "Copy of Another Notification Scheme"));
            TestSchemeMergeTool.assertTrue((boolean)this.tableCellHasText(newSchemeTable2, 1, 0, "Another Notification Scheme"));
            TestSchemeMergeTool.assertFalse((boolean)this.tableCellHasText(newSchemeTable2, 1, 1, "homosapien"));
            this.gotoPage("secure/admin/SchemeMerge!default.jspa?selectedSchemeType=NotificationScheme&typeOfSchemesToDisplay=all");
            this.assertFormElementEquals("Clone of Copy of Default Notification Scheme", "New_Scheme_1");
            this.assertFormElementEquals("Clone of Another Notification Scheme", "New_Scheme_2");
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
    }
}

