/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.issuetypes;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.ISSUES})
public class TestMultiIssueTypes
extends JIRAWebTest {
    private static final String AUTO_CREATED_SCHEME_PREFIX = "New issue type scheme for project ";
    private static final String CREATE_ISSUE_FORM_HEADER_CSS_LOCATOR = "#issue-create h2";
    private static final String VIEW_ISSUE_PAGE_ISSUE_TYPE_LABEL_ID = "type-val";

    public TestMultiIssueTypes(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    @Override
    public void tearDown() {
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testMultiIssueTypes() throws Exception {
        this._testCreateNewIssueTypeScheme();
        this._testSameAsProject();
        this._testChooseScheme();
        this._testIssueNavigator();
    }

    private void _testIssueNavigator() {
        TestMultiIssueTypes.logSection("Testing that choosing a different scheme is reflected in the issue navigator (must run after other tests)");
        this.navigation.issueNavigator().gotoNavigator();
        this.tester.setWorkingForm("issue-filter");
        this.tester.assertOptionsEqual("type", new String[]{"Any", "Task"});
        this.gotoPage("/plugins/servlet/project-config/HSP/issuetypes");
        this.tester.clickLink("project-config-issuetype-scheme-change");
        this.tester.checkCheckbox("createType", "chooseScheme");
        this.tester.selectOption("schemeId", "New issue type scheme for project homosapien");
        this.tester.submit(" OK ");
        this.navigation.issueNavigator().gotoNavigator();
        this.tester.setWorkingForm("issue-filter");
        this.tester.assertOptionsEqual("type", new String[]{"Any", "Bug", "Task", "Improvement"});
    }

    private void _testChooseScheme() {
        TestMultiIssueTypes.logSection("Testing choosing scheme from a list & that all available projects share the same config");
        this.gotoPage("/plugins/servlet/project-config/MKY/issuetypes");
        this.tester.clickLink("project-config-issuetype-scheme-change");
        this.tester.checkCheckbox("createType", "createScheme");
        this.tester.selectOption("selectedOptions", "Task");
        this.tester.submit();
        this.gotoPage("/plugins/servlet/project-config/MKY/issuetypes");
        this.text.assertTextPresent(this.locator.id("project-config-issuetype-scheme-name"), "New issue type scheme for project monkey");
        this.gotoPage("/plugins/servlet/project-config/HSP/issuetypes");
        this.tester.clickLink("project-config-issuetype-scheme-change");
        this.tester.selectOption("schemeId", "New issue type scheme for project monkey");
        this.tester.submit();
        this.gotoPage("/plugins/servlet/project-config/HSP/issuetypes");
        this.text.assertTextPresent(this.locator.id("project-config-issuetype-scheme-name"), "New issue type scheme for project monkey");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Task");
        this.text.assertTextPresent(this.locator.css(CREATE_ISSUE_FORM_HEADER_CSS_LOCATOR), "Create Issue");
    }

    private void _testSameAsProject() {
        TestMultiIssueTypes.logSection("Choose issue type scheme same as another project");
        this.tester.checkCheckbox("createType", "chooseProject");
        this.tester.selectOption("sameAsProjectId", "monkey");
        this.tester.submit();
        this.assertTextPresent("Default Issue Type Scheme");
        this.getNavigation().issue().goToCreateIssueForm("homosapien", "Task");
        this.text.assertTextPresent(this.locator.css(CREATE_ISSUE_FORM_HEADER_CSS_LOCATOR), "Create Issue");
    }

    private void _testCreateNewIssueTypeScheme() {
        TestMultiIssueTypes.logSection("Create a new issue type scheme");
        this.gotoPage("/plugins/servlet/project-config/HSP/issuetypes");
        this.tester.clickLink("project-config-issuetype-scheme-change");
        this.tester.checkCheckbox("createType", "createScheme");
        this.selectMultiOption("selectedOptions", "Bug");
        this.selectMultiOption("selectedOptions", "Improvement");
        this.tester.submit();
        this.gotoPage("/plugins/servlet/project-config/HSP/issuetypes");
        this.text.assertTextPresent(this.locator.id("project-config-issuetype-scheme-name"), "New issue type scheme for project homosapien");
        this.tester.clickLink("leave_admin");
        this.tester.clickLink("create_link");
        this.tester.selectOption("pid", "homosapien");
        this.tester.selectOption("issuetype", "Task");
        this.tester.submit();
        this.assertTextPresent("The issue type selected is invalid");
        this.tester.selectOption("issuetype", "Bug");
        this.tester.submit();
        this.text.assertTextPresent(this.locator.css(CREATE_ISSUE_FORM_HEADER_CSS_LOCATOR), "Create Issue");
        this.gotoPage("/plugins/servlet/project-config/HSP/issuetypes");
        this.tester.clickLink("project-config-issuetype-scheme-change");
    }

    public void testMultipleIssueTypeSchemesWithoutBulkChangePermission() {
        this.administration.restoreData("TestIssueTypesSchemes.xml");
        this.administration.removeGlobalPermission(33, "jira-users");
        this.navigation.gotoAdminSection("issue_types");
        this.tester.setFormElement("name", "");
        this.tester.clickLinkWithText("Issue Types Scheme");
        this.tester.setFormElement("name", "");
        this.tester.clickLink("associate_10011");
        this.tester.selectOption("projects", "homosapien");
        this.tester.submit("Associate");
        this.tester.assertTextPresent("homosapien");
        this.tester.assertTextPresent("Bug");
        this.tester.assertTextPresent("1");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.tester.assertTextPresent("homosapien");
        this.tester.assertTextPresent("New Feature");
        this.tester.submit("nextBtn");
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextPresent(this.locator.id(VIEW_ISSUE_PAGE_ISSUE_TYPE_LABEL_ID), "New Feature");
    }
}

