/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.issuetypes;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.ISSUES})
public class TestIssueTypes
extends FuncTestCase {
    @Override
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @Override
    public void tearDownTest() {
        this.administration.restoreBlankInstance();
    }

    public void testDeleteIssueTypeAndMoveRelatedIssues() {
        this.navigation.issue().createIssue("homosapien", "Bug", "Test Issue 1");
        this.tester.gotoPage("secure/admin/DeleteIssueType!default.jspa?id=1");
        this.tester.assertTextPresent("Delete Issue Type: Bug");
        this.tester.assertTextPresent("There are currently <b>1</b> matching issues, that must be changed to another issue type.");
        this.tester.assertTextPresent("New type for matching issues");
        this.tester.assertFormElementPresent("newId");
        Object[] valuesFor = this.tester.getDialog().getOptionsFor("newId");
        List list = EasyList.build((Object[])valuesFor);
        TestIssueTypes.assertTrue((boolean)list.contains("Improvement"));
        TestIssueTypes.assertTrue((boolean)list.contains("New Feature"));
        TestIssueTypes.assertTrue((boolean)list.contains("Task"));
        this.tester.submit("Delete");
        this.tester.assertTextNotPresent("A problem which impairs or prevents the functions of the product.");
        this.tester.assertTextPresent("An improvement or enhancement to an existing feature or task.");
        this.tester.assertTextPresent("A new feature of the product, which has yet to be developed.");
        this.tester.assertTextPresent("A task that needs to be done.");
    }

    public void testDeleteIssueTypeWithNoRelatedIssues() {
        this.tester.gotoPage("secure/admin/DeleteIssueType!default.jspa?id=1");
        this.tester.assertTextPresent("Delete Issue Type: Bug");
        this.tester.assertTextPresent("There are currently no matching issues");
        this.tester.assertTextNotPresent("New type for matching issues:");
        this.tester.assertFormElementNotPresent("newId");
        this.tester.submit("Delete");
        this.tester.assertTextNotPresent("A problem which impairs or prevents the functions of the product.");
        this.tester.assertTextPresent("An improvement or enhancement to an existing feature or task.");
        this.tester.assertTextPresent("A new feature of the product, which has yet to be developed.");
        this.tester.assertTextPresent("A task that needs to be done.");
    }

    public void testRefuseToDeleteLastIssueType() {
        this.tester.gotoPage("secure/admin/DeleteIssueType!default.jspa?id=1");
        this.tester.submit("Delete");
        this.tester.gotoPage("secure/admin/DeleteIssueType!default.jspa?id=2");
        this.tester.submit("Delete");
        this.tester.gotoPage("secure/admin/DeleteIssueType!default.jspa?id=3");
        this.tester.submit("Delete");
        this.tester.assertTextNotPresent("A problem which impairs or prevents the functions of the product.");
        this.tester.assertTextNotPresent("A new feature of the product, which has yet to be developed.");
        this.tester.assertTextNotPresent("A task that needs to be done.");
        this.tester.assertTextPresent("An improvement or enhancement to an existing feature or task.");
        this.tester.assertLinkNotPresentWithText("Delete");
    }

    public void testRefuseToDeleteLastSubTaskIssueTypeWithRelatedIssues() {
        this.administration.subtasks().enable();
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Test Issue 1");
        this.navigation.issue().createSubTask(issueKey, "Sub-task", "subtask test 1", "description");
        this.tester.gotoPage("secure/admin/DeleteIssueType!default.jspa?id=5");
        this.tester.assertTextPresent("This issue type cannot be deleted - there are currently");
        this.tester.assertTextPresent("<b>1</b>");
        this.tester.assertTextPresent("In order for an issue type to be deleted, it needs to be associated with one workflow, field configuration and field screen scheme across all projects");
        this.tester.clickLinkWithText("1");
        this.tester.assertTextPresent("HSP-1");
        this.tester.assertSubmitButtonNotPresent("Delete");
    }

    public void testDeleteIssueTypeWithDifferentWorkflows() {
        this.administration.restoreData("TestDeleteIssueType.xml");
        this.tester.gotoPage("/secure/admin/DeleteIssueType!default.jspa?id=1");
        this.tester.assertTextPresent("This issue type cannot be deleted");
        this.tester.assertTextPresent("In order for an issue type to be deleted, it needs to be associated with one workflow, field configuration and field screen scheme across all projects");
        this.tester.clickLinkWithText("2");
        this.tester.assertTextPresent("MKY-1");
        this.tester.assertTextPresent("HSP-1");
    }
}

