/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.UserProfileImpl;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import com.atlassian.jira.webtests.LicenseKeys;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import java.io.IOException;
import java.util.Collection;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING, Category.LICENSING})
public class TestSupportRequest
extends EmailFuncTestCase {
    private static final String SUPPORT_REQUEST_HEADER = "---------------------------------------------------\r\nThis is an automated support request sent from JIRA\r\n---------------------------------------------------";
    private static final String SUPPORT_REQUEST_PROBLEM = "Problem Description:\r\n\r\n";
    private static final String CONTACT_NAME = "admin";
    private static final String CONTACT_EMAIL = "admin@localhost";
    private static final String CONTACT_NUMBER = "1234567890";
    private static final String SUPPORT_REQUEST_CONTACT = "Contact Information\r\n\r\nName:   admin\r\nEmail:  admin@localhost\r\nPhone:  1234567890\r\n";
    private static final String LOG_ZIP = "atlassian-jira.log.zip";
    private static final String LOG_CONTENT_TYPE = "application/zip";

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestSupportRequest.xml");
    }

    public void testSupportRequestDenied() throws Exception {
        this.switchLicenseAndAssertSupportRequestDenied(LicenseKeys.V2_PERSONAL);
        this.switchLicenseAndAssertSupportRequestDenied(LicenseKeys.V2_DEMO);
    }

    public void testSupportRequestNotDenied() throws Exception {
        this.switchLicenseAndAssertSupportRequestNotDenied(LicenseKeys.V2_COMMUNITY);
        this.switchLicenseAndAssertSupportRequestNotDenied(LicenseKeys.V2_DEVELOPER);
        this.switchLicenseAndAssertSupportRequestNotDenied(LicenseKeys.V2_OPEN_SOURCE);
    }

    private void switchLicenseAndAssertSupportRequestDenied(LicenseKeys.License license) throws SAXException {
        this.administration.switchToLicense(license);
        this.gotoSupportRequestAdminPage();
        this.assertions.getTextAssertions().assertTextSequence(new WebPageLocator(this.tester), new String[]{"Please note that your license", "does not entitle you to support.", "If you are experiencing problems, please see the JIRA", "The Atlassian Team"});
        this.assertions.getLinkAssertions().assertLinkLocationEndsWith("forums", "http://forums.atlassian.com/");
        this.assertions.getLinkAssertions().assertLinkLocationEndsWith("purchasing", "http://www.atlassian.com/order");
    }

    private void switchLicenseAndAssertSupportRequestNotDenied(LicenseKeys.License license) throws SAXException {
        this.administration.switchToLicense(license);
        this.gotoSupportRequestAdminPage();
        this.tester.assertTextNotPresent("does not entitle you to support.");
        this.tester.assertTextNotPresent("If you are experiencing problems, please see the JIRA");
    }

    private void gotoSupportRequestAdminPage() {
        this.tester.gotoPage("/secure/admin/JiraSupportRequest!default.jspa");
    }

    private void assertLinkWithTextUrlStartsWith(String name, String url) {
        try {
            WebLink link = this.tester.getDialog().getResponse().getLinkWith(name);
            TestSupportRequest.assertTrue((link.getURLString().indexOf(url) >= 0 ? 1 : 0) != 0);
        }
        catch (SAXException e) {
            TestSupportRequest.fail((String)("Failed to get the link with name: " + name));
        }
    }

    public void testMandatoryFields() {
        this.navigation.gotoAdmin();
        this.gotoSupportRequestAdminPage();
        this.tester.setFormElement("to", "");
        this.tester.setFormElement("cc", "admin@example.com");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("email", "");
        this.tester.setFormElement("phone", "");
        this.tester.submit("Submit");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("You must specify at least one 'to' address.");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("You must specify a subject.");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("You must specify a description.");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("You must specify a name.");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("You must specify a contact email address.");
    }

    public void testInvalidEmailAddresses() {
        this.navigation.gotoAdmin();
        this.gotoSupportRequestAdminPage();
        this.tester.setFormElement("to", "test@@test.com");
        this.tester.setFormElement("cc", "invalidemail.com");
        this.tester.setFormElement("email", "anotherivalid^#$%^#$^");
        this.tester.submit("Submit");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("You must specify a valid 'to' address(es).");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("You must specify a valid 'cc' address(es).");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("You must specify a valid 'contact' address(es).");
    }

    public void testInvalidMultipleEmailAddresses() {
        this.navigation.gotoAdmin();
        this.gotoSupportRequestAdminPage();
        this.tester.setFormElement("to", "test@test.com, test@@test.com");
        this.tester.setFormElement("cc", "invalidemail.com, valid@email.com");
        this.tester.setFormElement("email", "email@example.com, anotherivalid^#$%^#$^");
        this.tester.submit("Submit");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("You must specify a valid 'to' address(es).");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("You must specify a valid 'cc' address(es).");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("You must specify a valid 'contact' address(es).");
    }

    public void testBaseUrlIsSentInTheSupportRequest() throws MessagingException, IOException, InterruptedException, SAXException, FolderException {
        String from = "sender@base.url.com";
        String prefix = "[TEST-BaseUrl]";
        this.configureAndStartSmtpServer(from, prefix);
        String baseUrl = "http://example.url.com:8090";
        this.administration.generalConfiguration().setBaseUrl(baseUrl);
        this.assertBaseUrlnSupportRequest("change1@blah.com", baseUrl, from, prefix, 1);
        baseUrl = "http://a.new.base.url/test/jira";
        this.administration.generalConfiguration().setBaseUrl(baseUrl);
        this.assertBaseUrlnSupportRequest("change2@random.email", baseUrl, from, prefix, 2);
        baseUrl = "https://third.time.lucky";
        this.administration.generalConfiguration().setBaseUrl(baseUrl);
        this.assertBaseUrlnSupportRequest("change3@last.test", baseUrl, from, prefix, 3);
    }

    public void testSupportRequestContainsLicenseInfo() throws Exception {
        String from = "sender@base.url.com";
        String prefix = "[TEST-BaseUrl]";
        this.configureAndStartSmtpServer(from, prefix);
        LicenseKeys.License license = LicenseKeys.V2_DEVELOPER_LIMITED;
        this.administration.switchToLicense(license);
        this.navigation.gotoAdmin();
        this.gotoSupportRequestAdminPage();
        String licenseDesc = license.getDescription();
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(locator, new String[]{"License Type", licenseDesc});
        this.tester.assertTextPresent("Maintenance Period End Date");
        this.text.assertTextSequence(locator, new String[]{"Maintenance Status", "Supported"});
        this.tester.assertTextPresent("Date Purchased");
        this.text.assertTextSequence(locator, "Support Entitlement Number", license.getSen());
        this.text.assertTextSequence(locator, "User Limit", String.valueOf(license.getMaxUsers()));
        this.sendSupportRequestAndVerify("legendarysupport@example.com", "", false, false, from, prefix, 1, true);
        MailFolder userInbox = this.getUserInbox("legendarysupport@example.com");
        TestSupportRequest.assertEquals((int)1, (int)userInbox.getMessageCount());
        MimeMessage email = ((SimpleStoredMessage)userInbox.getMessages().get(0)).getMimeMessage();
        this.assertEmailBodyContains(email, "License Type");
        this.assertEmailBodyContains(email, licenseDesc);
        this.assertEmailBodyContains(email, "Maintenance Period End Date");
        this.assertEmailBodyContains(email, "Maintenance Status");
        this.assertEmailBodyContains(email, "Supported");
        this.assertEmailBodyContains(email, "Date Purchased");
        this.assertEmailBodyContains(email, "JIRA Home");
        this.assertEmailBodyContains(email, "User Limit");
        this.assertEmailBodyContains(email, "Support Entitlement Number");
    }

    public void testSupportRequestContainsNoSecurityBlacklistInfo() throws Exception {
        String from = "sender@base.url.com";
        String prefix = "[TEST-BaseUrl]";
        this.configureAndStartSmtpServer(from, prefix);
        LicenseKeys.License license = LicenseKeys.V2_DEVELOPER_LIMITED;
        this.administration.switchToLicense(license);
        this.navigation.gotoAdmin();
        this.gotoSupportRequestAdminPage();
        this.tester.assertTextNotPresent("License Hash 1");
        this.tester.assertTextNotPresent("License Hash 1 Text");
        this.tester.assertTextNotPresent("License Message");
        this.tester.assertTextNotPresent("License Message Text");
        this.tester.assertTextNotPresent("License20");
        this.tester.assertTextNotPresent("jira.sid.key");
        this.tester.assertTextNotPresent("org.apache.shindig.common.crypto.BlobCrypter:key");
        this.sendSupportRequestAndVerify("legendarysupport@example.com", "", false, false, from, prefix, 1, true);
        MailFolder userInbox = this.getUserInbox("legendarysupport@example.com");
        TestSupportRequest.assertEquals((int)1, (int)userInbox.getMessageCount());
        MimeMessage email = ((SimpleStoredMessage)userInbox.getMessages().get(0)).getMimeMessage();
        this.assertEmailBodyDoesntContain(email, "License Hash 1");
        this.assertEmailBodyDoesntContain(email, "License Hash 1 Text");
        this.assertEmailBodyDoesntContain(email, "License Message");
        this.assertEmailBodyDoesntContain(email, "License Message Text");
        this.assertEmailBodyDoesntContain(email, "License20");
        this.assertEmailBodyDoesntContain(email, "jira.sid.key");
        this.assertEmailBodyDoesntContain(email, "org.apache.shindig.common.crypto.BlobCrypter:key");
    }

    public void testSupportRequestContainsMemoryAndInputArgsInfo() throws MessagingException, IOException, InterruptedException, SAXException, FolderException {
        String from = "sender@base.url.com";
        String prefix = "[TEST-BaseUrl]";
        this.configureAndStartSmtpServer(from, prefix);
        this.navigation.gotoAdmin();
        this.gotoSupportRequestAdminPage();
        this.sendSupportRequestAndVerify("legendarysupport@example.com", "", false, false, from, prefix, 1, true);
        MailFolder userInbox = this.getUserInbox("legendarysupport@example.com");
        TestSupportRequest.assertEquals((int)1, (int)userInbox.getMessageCount());
        MimeMessage email = ((SimpleStoredMessage)userInbox.getMessages().get(0)).getMimeMessage();
        this.assertEmailBodyContains(email, "Used PermGen Memory");
        this.assertEmailBodyContains(email, "Free PermGen Memory");
        this.assertEmailBodyContains(email, "Memory Pools:");
        this.assertEmailBodyContains(email, "JVM Input Arguments");
        this.assertEmailBodyDoesntContain(email, "Unable to determine, this requires running JDK 1.5 and higher.");
    }

    public void testSupportRequestContainsTimezoneInfo() throws MessagingException, IOException, InterruptedException, SAXException, FolderException {
        String from = "sender@base.url.com";
        String prefix = "[TEST-BaseUrl]";
        this.configureAndStartSmtpServer(from, prefix);
        this.navigation.gotoAdmin();
        this.gotoSupportRequestAdminPage();
        this.sendSupportRequestAndVerify("legendarysupport@example.com", "", false, false, from, prefix, 1, true);
        MailFolder userInbox = this.getUserInbox("legendarysupport@example.com");
        TestSupportRequest.assertEquals((int)1, (int)userInbox.getMessageCount());
        MimeMessage email = ((SimpleStoredMessage)userInbox.getMessages().get(0)).getMimeMessage();
        this.assertEmailBodyContains(email, "User Timezone");
        this.assertEmailBodyContainsLine(email, "\\s*System Time: \\d{1,2}:\\d{2}:\\d{2} [+-]\\d{4}\\s*");
    }

    public void testSupportRequestContainsUserLimitLicenseInfo() throws MessagingException, IOException, InterruptedException, SAXException, FolderException {
        this.administration.switchToLicense(LicenseKeys.V2_HOSTED);
        String from = "sender@base.url.com";
        String prefix = "[TEST-BaseUrl]";
        this.configureAndStartSmtpServer(from, prefix);
        this.navigation.gotoAdmin();
        this.gotoSupportRequestAdminPage();
        this.assertions.getTextAssertions().assertTextSequence(new WebPageLocator(this.tester), new String[]{"License Type", "JIRA Enterprise: Hosted"});
        this.tester.assertTextPresent("Maintenance Period End Date");
        this.assertions.getTextAssertions().assertTextSequence(new WebPageLocator(this.tester), new String[]{"Maintenance Status", "Supported"});
        this.tester.assertTextPresent("Date Purchased");
        this.assertions.getTextAssertions().assertTextSequence(new WebPageLocator(this.tester), new String[]{"User Limit", "200", "(1 currently active)"});
        this.sendSupportRequestAndVerify("legendarysupport@example.com", "", false, false, from, prefix, 1, true);
        MailFolder userInbox = this.getUserInbox("legendarysupport@example.com");
        TestSupportRequest.assertEquals((int)1, (int)userInbox.getMessageCount());
        MimeMessage email = ((SimpleStoredMessage)userInbox.getMessages().get(0)).getMimeMessage();
        this.assertEmailBodyContains(email, "License Type: JIRA Enterprise: Hosted");
        this.assertEmailBodyContains(email, "Maintenance Period End Date");
        this.assertEmailBodyContains(email, "Maintenance Status");
        this.assertEmailBodyContains(email, "Supported");
        this.assertEmailBodyContains(email, "Date Purchased");
        this.assertEmailBodyContains(email, "User Limit: 200 (1 currently active)");
    }

    private void assertBaseUrlnSupportRequest(String to, String baseUrl, String from, String prefix, int expectTotalNumOfEmails) throws SAXException, InterruptedException, MessagingException, IOException, FolderException {
        this.navigation.gotoAdmin();
        this.gotoSupportRequestAdminPage();
        WebTable environmentTable = this.tester.getDialog().getResponse().getTableWithID("support_req_env");
        this.assertions.getTableAssertions().assertTableContainsRow(environmentTable, new String[]{"Base URL", baseUrl});
        this.sendSupportRequestAndVerify(to, "", false, false, from, prefix, expectTotalNumOfEmails, true);
        MailFolder userInbox = this.getUserInbox(to);
        TestSupportRequest.assertEquals((int)1, (int)userInbox.getMessageCount());
        MimeMessage email = ((SimpleStoredMessage)userInbox.getMessages().get(0)).getMimeMessage();
        this.assertEmailBodyContains(email, "Base URL: " + baseUrl);
    }

    public void testSupportRequestPageTranslated() {
        String from = "sender@support.request.com";
        String prefix = "[TEST-PREFIX]";
        this.configureAndStartSmtpServer(from, prefix);
        this.administration.generalConfiguration().setJiraLocale("German (Germany)");
        UserProfileImpl userProfile = new UserProfileImpl(this.tester, this.getEnvironmentData(), this.navigation);
        userProfile.changeUserLanguage("Deutsch (Deutschland) [Default]");
        this.navigation.gotoAdmin();
        this.gotoSupportRequestAdminPage();
        this.tester.assertTextPresent("Supportanforderung");
        this.tester.assertTextPresent("Betreff");
        this.tester.assertTextPresent("Beschreibung");
        this.tester.assertTextPresent("Existierende Supportanfrage");
    }

    public void testSupportRequestEmailNotTranslated() throws MessagingException, IOException, InterruptedException, FolderException {
        String from = "sender@support.request.com";
        String prefix = "[TEST-PREFIX]";
        this.configureAndStartSmtpServer(from, prefix);
        this.administration.generalConfiguration().setJiraLocale("German (Germany)");
        UserProfileImpl userProfile = new UserProfileImpl(this.tester, this.getEnvironmentData(), this.navigation);
        userProfile.changeUserLanguage("Deutsch (Deutschland) [Default]");
        this.sendSupportRequestAndVerify("test@localhost", "", false, false, from, prefix, 1, false);
    }

    private void sendSupportRequestAndVerify(String to, String cc, boolean isAttachExport, boolean isAttachLog, String from, String prefix, int expectTotalNumOfEmails, boolean useEnglish) throws InterruptedException, MessagingException, IOException, FolderException {
        Address[] recipients;
        int expectedNumberOfParts = 2;
        if (isAttachExport) {
            ++expectedNumberOfParts;
        }
        if (isAttachLog) {
            ++expectedNumberOfParts;
        }
        String subject = "New Support Request Test";
        String description = "test sending a support req";
        if (useEnglish) {
            this.sendSupportRequestInEnglish(to, cc, subject, description, isAttachExport, isAttachLog);
        } else {
            this.sendSupportRequestInGerman(to, cc, subject, description, isAttachExport, isAttachLog);
        }
        this.waitForMail(1);
        TestSupportRequest.assertEquals((int)expectTotalNumOfEmails, (int)this.getGreenMail().getReceivedMessages().length);
        MimeMessage[] receivedEmails = this.getGreenMail().getReceivedMessages();
        MimeMessage email = receivedEmails[expectTotalNumOfEmails - 1];
        Collection<String> toEmailAddresses = this.parseEmailAddresses(to);
        Collection<String> ccEmailAddresses = this.parseEmailAddresses(cc);
        for (Address recipient : recipients = email.getAllRecipients()) {
            String recipientEmailAddress = recipient.toString();
            MailFolder userInbox = this.getUserInbox(recipientEmailAddress);
            TestSupportRequest.assertEquals((int)1, (int)userInbox.getMessageCount());
            TestSupportRequest.assertEquals((Object)email, (Object)((SimpleStoredMessage)userInbox.getMessages().iterator().next()).getMimeMessage());
            this.assertEmailToEquals(email, toEmailAddresses);
            this.assertEmailCcEquals(email, ccEmailAddresses);
            this.assertEmailFromEquals(email, from);
            this.assertEmailSubjectEquals(email, prefix + " [JIRA Support Request] " + subject);
            String body = GreenMailUtil.getBody((Part)email);
            this.assertEmailBodyContains(body, SUPPORT_REQUEST_HEADER);
            this.assertEmailBodyContains(body, SUPPORT_REQUEST_PROBLEM + description);
            this.assertEmailBodyDoesntContain(email, "Kaufdatum");
            this.assertEmailBodyDoesntContain(email, "Lizenztyp");
            this.assertEmailBodyContains(body, "Date Purchased");
            this.assertEmailBodyContains(body, "License Type");
            this.assertEmailBodyContains(body, "Environment Information:");
            this.assertEmailBodyContains(body, "Language Information:");
            this.assertEmailBodyContains(body, "Database Statistics");
            this.assertEmailBodyContains(body, "Listeners:");
            this.assertEmailBodyContains(body, "Services:");
            this.assertEmailBodyContains(body, "Plugins:");
            this.assertEmailBodyContains(body, SUPPORT_REQUEST_CONTACT);
            this.assertEmailBodyContains(body, "System Properties");
        }
    }

    private void sendSupportRequestInEnglish(String to, String cc, String subject, String description, boolean isAttachExport, boolean isAttachLog) {
        this.navigation.gotoAdmin();
        this.gotoSupportRequestAdminPage();
        this.tester.setFormElement("to", to);
        this.tester.setFormElement("subject", subject);
        this.tester.setFormElement("description", description);
        this.tester.setFormElement("cc", cc);
        this.tester.setFormElement("name", CONTACT_NAME);
        this.tester.setFormElement("email", CONTACT_EMAIL);
        this.tester.setFormElement("phone", CONTACT_NUMBER);
        this.tester.submit("Submit");
        this.tester.assertTextPresent("Your support request email has been sent");
        this.tester.assertTextPresent("(Please note that if there is a problem delivering this email, the Atlassian support staff may not receive your support request.)");
    }

    private void sendSupportRequestInGerman(String to, String cc, String subject, String description, boolean isAttachExport, boolean isAttachLog) {
        this.navigation.gotoAdmin();
        this.gotoSupportRequestAdminPage();
        this.tester.setFormElement("to", to);
        this.tester.setFormElement("subject", subject);
        this.tester.setFormElement("description", description);
        this.tester.setFormElement("cc", cc);
        this.tester.setFormElement("name", CONTACT_NAME);
        this.tester.setFormElement("email", CONTACT_EMAIL);
        this.tester.setFormElement("phone", CONTACT_NUMBER);
        this.tester.submit("Senden");
        this.tester.assertTextPresent("Supportanfrage gesendet");
        this.tester.assertTextPresent("Ihre E-Mail-Supportanfrage wurde gesendet.");
    }
}

