/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.license.DefaultSIDManager;
import com.atlassian.license.SIDManager;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
public class TestServerId
extends FuncTestCase {
    private final SIDManager sidManager = new DefaultSIDManager();

    public void testServerIdIdenticalAfterRestore() throws SAXException {
        this.administration.restoreData("TestServerId.xml");
        this.navigation.gotoAdminSection("license_details");
        this.text.assertTextPresent(this.locator.page(), "Server ID");
        WebTable licenseTable = this.tester.getDialog().getResponse().getTableWithID("license_table");
        String serverId = licenseTable.getCellAsText(3, 1);
        TestServerId.assertEquals((String)"Server ID same as stored", (String)"ALA0-Y7A3-TR93-KAHT", (String)serverId.trim());
    }

    public void testServerIdGeneratedFresh() throws SAXException {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection("license_details");
        this.text.assertTextPresent(this.locator.page(), "Server ID");
        WebTable licenseTable = this.tester.getDialog().getResponse().getTableWithID("license_table");
        String serverId = licenseTable.getCellAsText(3, 1);
        TestServerId.assertTrue((String)"Valid SID", (boolean)this.sidManager.isValidSID(serverId.trim()));
    }
}

