/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.NodeLocator;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
public class TestLookAndFeelUpgrade
extends FuncTestCase {
    public void test312NonModified() throws Exception {
        this.administration.restoreData("TestUpgradeBase312.xml");
        this.navigation.gotoAdminSection("lookandfeel");
        this.assertHasDefaultLookAndFeel();
    }

    public void test312Modified() throws Exception {
        this.administration.restoreData("TestUpgradeModifiedLookAndFeel312.xml");
        this.navigation.gotoAdminSection("lookandfeel");
        this.assertHas312Modifications();
    }

    public void test313NonModified() throws Exception {
        this.administration.restoreData("TestUpgradeBase313.xml");
        this.navigation.gotoAdminSection("lookandfeel");
        this.assertHasDefaultLookAndFeel();
    }

    public void test313Modified() throws Exception {
        this.administration.restoreData("TestUpgradeModifiedLookAndFeel313.xml");
        this.navigation.gotoAdminSection("lookandfeel");
        this.assertHas313Modifications();
    }

    private void assertHas312Modifications() {
        this.assertHasUrl("lookAndFeelLogo", 0, 1, "/images/debug/debug.png");
        TableLocator tableLocatorColors = new TableLocator(this.tester, "lookAndFeelColors");
        String textStr = tableLocatorColors.getText();
        this.text.assertTextSequence(textStr, new String[]{"Header Background Colour", "#99ccff", "Header Highlight Background Colour", "<Default>", "Header Text Colour", "#cc00ff", "Header Text Highlight Colour", "<Default>", "Header Separator Color", "#99ccff", "Navigation Bar Background Colour", "#3366ff", "Navigation Bar Text Colour", "#000066", "Navigation Bar Separator Colour", "<Default>"});
    }

    private void assertHas313Modifications() {
        this.assertHasUrl("lookAndFeelLogo", 0, 1, "/images/debug/debug.png");
        TableLocator tableLocatorColors = new TableLocator(this.tester, "lookAndFeelColors");
        String textStr = tableLocatorColors.getText();
        this.text.assertTextSequence(textStr, new String[]{"Header Background Colour", "#663399", "Header Highlight Background Colour", "#ff33cc", "Header Text Colour", "#cccccc", "Header Text Highlight Colour", "#6666cc", "Header Separator Color", "<Default>", "Navigation Bar Background Colour", "#9966ff", "Navigation Bar Text Colour", "#777777", "Navigation Bar Separator Colour", "<Default>"});
    }

    private void assertHasDefaultLookAndFeel() {
        this.assertHasDefaultLogos();
        TableLocator tableLocatorColors = new TableLocator(this.tester, "lookAndFeelColors");
        String textStr = tableLocatorColors.getText();
        this.text.assertTextSequence(textStr, new String[]{"Header Background Colour", "<Default>", "Header Highlight Background Colour", "<Default>", "Header Text Colour", "<Default>", "Header Text Highlight Colour", "<Default>", "Header Separator Color", "<Default>", "Navigation Bar Background Colour", "<Default>", "Navigation Bar Text Colour", "<Default>", "Navigation Bar Separator Colour", "<Default>", "Link Colour", "<Default>", "Link Active Colour", "<Default>", "Heading Colour", "<Default>"});
        TableLocator tableLocatorGadgetColors = new TableLocator(this.tester, "lookAndFeelGadgetChromeColours");
        textStr = tableLocatorGadgetColors.getText();
        this.text.assertTextSequence(textStr, new String[]{"Colour 1", "<Default>", "Colour 2", "<Default>", "Colour 3", "<Default>", "Colour 4", "<Default>", "Colour 5", "<Default>", "Colour 6", "<Default>", "Colour 7", "<Default>"});
        TableLocator tableLocatorFormats = new TableLocator(this.tester, "lookAndFeelFormats");
        this.text.assertTextSequence(tableLocatorFormats, new String[]{"Time Format", "h:mm a", "Day Format", "EEEE h:mm a", "Complete Date/Time Format", "dd/MMM/yy h:mm a", "Day/Month/Year Format", "dd/MMM/yy"});
    }

    private void assertHasDefaultLogos() {
        TableLocator tableLocatorLogo = new TableLocator(this.tester, "lookAndFeelLogo");
        this.text.assertTextSequence(tableLocatorLogo, new String[]{"Preview", "Favicon Preview"});
        this.assertHasUrl("lookAndFeelLogo", 0, 1, "/images/jira111x30.png");
        this.assertHasUrl("lookAndFeelLogo", 1, 1, "/images/icons/favicon32.png");
    }

    private void assertHasUrl(String tableId, int row, int col, String expectedUrl) {
        TableCellLocator cellLocator = new TableCellLocator(this.tester, tableId, row, col);
        Node[] nodes = cellLocator.getNodes();
        this.text.assertTextPresent(new NodeLocator(nodes[0].getFirstChild().getNextSibling().getAttributes().getNamedItem("src")), expectedUrl);
    }
}

