/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.NodeLocator;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
public class TestLookAndFeel
extends FuncTestCase {
    private static final String VERSION_ELEMENT_STR = "<dl style=\"display:none;\" id=\"jira.webresource.flushcounter\">";
    private static final String DEFAULT_LOGO_URL = "/images/jira111x30.png";
    public static final String DEFAULT_FAVICON_URL = "/images/icons/favicon32.png";

    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection("lookandfeel");
    }

    public void testHasDefaults() throws Exception {
        this.assertHasDefaultLookAndFeel();
    }

    public void testEditLookAndFeelIncrementsWebResourceUrl() {
        this.tester.clickLinkWithText("Edit Configuration");
        String responseText = this.tester.getDialog().getResponseText();
        String oldVersionNumber = responseText.substring(responseText.indexOf(VERSION_ELEMENT_STR) + VERSION_ELEMENT_STR.length(), responseText.indexOf("</dl>"));
        this.tester.setFormElement("topBgColour", "#010101");
        this.tester.submit("Update");
        long newVersionNum = Long.parseLong(oldVersionNumber) + 1L;
        String newResponseText = this.tester.getDialog().getResponseText();
        String batchResource = "/" + newVersionNum + "/1.0/_/download/batch/jira.webresources:global-static/jira.webresources:global-static.css";
        String nonbatchResource = "/" + newVersionNum + "/1.0/_/download/resources/jira.webresources:global-static/base.css";
        TestLookAndFeel.assertTrue((newResponseText.contains(batchResource) || newResponseText.contains(nonbatchResource) ? 1 : 0) != 0);
    }

    private void assertHasDefaultLookAndFeel() {
        this.assertHasDefaultLogos();
        TableLocator tableLocatorColors = new TableLocator(this.tester, "lookAndFeelColors");
        String textStr = tableLocatorColors.getText();
        this.text.assertTextSequence(textStr, new String[]{"Header Background Colour", "<Default>", "Header Highlight Background Colour", "<Default>", "Header Text Colour", "<Default>", "Header Text Highlight Colour", "<Default>", "Header Separator Color", "<Default>", "Navigation Bar Background Colour", "<Default>", "Navigation Bar Text Colour", "<Default>", "Navigation Bar Separator Colour", "<Default>", "Link Colour", "<Default>", "Link Active Colour", "<Default>", "Heading Colour", "<Default>"});
        TableLocator tableLocatorGadgetColors = new TableLocator(this.tester, "lookAndFeelGadgetChromeColours");
        textStr = tableLocatorGadgetColors.getText();
        this.text.assertTextSequence(textStr, new String[]{"Colour 1", "<Default>", "Colour 2", "<Default>", "Colour 3", "<Default>", "Colour 4", "<Default>", "Colour 5", "<Default>", "Colour 6", "<Default>", "Colour 7", "<Default>"});
        TableLocator tableLocatorFormats = new TableLocator(this.tester, "lookAndFeelFormats");
        this.text.assertTextSequence(tableLocatorFormats, new String[]{"Time Format", "h:mm a", "Day Format", "EEEE h:mm a", "Complete Date/Time Format", "dd/MMM/yy h:mm a", "Day/Month/Year Format", "dd/MMM/yy", "Use ISO8601 standard in Date Picker", "OFF"});
    }

    private void assertHasDefaultLogos() {
        TableLocator tableLocatorLogo = new TableLocator(this.tester, "lookAndFeelLogo");
        this.text.assertTextSequence(tableLocatorLogo, new String[]{"Preview", "Favicon Preview"});
        this.assertHasUrl("lookAndFeelLogo", 0, 1, DEFAULT_LOGO_URL);
        this.assertHasUrl("lookAndFeelLogo", 1, 1, DEFAULT_FAVICON_URL);
    }

    private void assertHasUrl(String tableId, int row, int col, String expectedUrl) {
        TableCellLocator cellLocator = new TableCellLocator(this.tester, tableId, row, col);
        Node[] nodes = cellLocator.getNodes();
        this.text.assertTextPresent(new NodeLocator(nodes[0].getFirstChild().getNextSibling().getAttributes().getNamedItem("src")), expectedUrl);
    }

    public void testReflectsEdits() throws Exception {
        this.tester.clickLinkWithText("Edit Configuration");
        WebPageLocator pageLocator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(pageLocator.getHTML(), new String[]{"Header Background Colour", "#114070", "Header Highlight Background Colour", "#325c82", "Header Text Colour", "#ffffff", "Header Text Highlight Colour", "#f0f0f0", "Header Separator Color", "#114070", "Navigation Bar Background Colour", "#3c78b5", "Navigation Bar Text Colour", "#ffffff", "Navigation Bar Separator Colour", "#f0f0f0", "Link Colour", "#3c78b5", "Link Active Colour", "#3c78b5", "Heading Colour", "#3c78b5"});
        this.tester.setFormElement("logoUrl", "logoURL");
        this.tester.setFormElement("topBgColour", "#010101");
        this.tester.setFormElement("topTextColour", "#020202");
        this.tester.setFormElement("topHighlightBgColour", "#030303");
        this.tester.setFormElement("topTextHighlightColour", "#040404");
        this.tester.setFormElement("topSeparatorColor", "#050505");
        this.tester.setFormElement("menuBgColour", "#060606");
        this.tester.setFormElement("menuTextColour", "#070707");
        this.tester.setFormElement("menuSeparatorColour", "#080808");
        this.tester.setFormElement("linkColour", "#101010");
        this.tester.setFormElement("linkAColour", "#111111");
        this.tester.setFormElement("headingColour", "#121212");
        this.tester.setFormElement("gadgetChromeColorcolor1", "#313131");
        this.tester.setFormElement("gadgetChromeColorcolor2", "#323131");
        this.tester.setFormElement("gadgetChromeColorcolor3", "#333131");
        this.tester.setFormElement("gadgetChromeColorcolor4", "#343131");
        this.tester.setFormElement("gadgetChromeColorcolor5", "#353131");
        this.tester.setFormElement("gadgetChromeColorcolor6", "#363131");
        this.tester.setFormElement("gadgetChromeColorcolor7", "#373131");
        this.tester.setFormElement("formatTime", "h:m:s");
        this.tester.setFormElement("formatDay", "d:M:y");
        this.tester.setFormElement("formatComplete", "d:M:y h:m:s");
        this.tester.setFormElement("formatDMY", "d/M/y");
        this.tester.checkCheckbox("useISO8601", "true");
        this.tester.submit("Update");
        TableLocator tableLocatorLogo = new TableLocator(this.tester, "lookAndFeelLogo");
        this.assertHasUrl("lookAndFeelLogo", 0, 1, DEFAULT_LOGO_URL);
        TableLocator tableLocatorColors = new TableLocator(this.tester, "lookAndFeelColors");
        String textStr = tableLocatorColors.getText();
        this.text.assertTextSequence(textStr, new String[]{"Header Background Colour", "#010101", "Header Highlight Background Colour", "#030303", "Header Text Colour", "#020202", "Header Text Highlight Colour", "#040404", "Header Separator Color", "#050505", "Navigation Bar Background Colour", "#060606", "Navigation Bar Text Colour", "#070707", "Navigation Bar Separator Colour", "#080808", "Link Colour", "#101010", "Link Active Colour", "#111111", "Heading Colour", "#121212"});
        TableLocator tableLocatorGadgetColors = new TableLocator(this.tester, "lookAndFeelGadgetChromeColours");
        textStr = tableLocatorGadgetColors.getText();
        this.text.assertTextSequence(textStr, new String[]{"Colour 1", "#313131", "Colour 2", "#323131", "Colour 3", "#333131", "Colour 4", "#343131", "Colour 5", "#353131", "Colour 6", "#363131", "Colour 7", "#373131"});
        TableLocator tableLocatorFormats = new TableLocator(this.tester, "lookAndFeelFormats");
        this.text.assertTextSequence(tableLocatorFormats, new String[]{"Time Format", "h:m:s", "Day Format", "d:M:y", "Complete Date/Time Format", "d:M:y h:m:s", "Day/Month/Year Format", "d/M/y", "Use ISO8601 standard in Date Picker", "ON"});
        this.tester.gotoPage(this.page.addXsrfToken("EditLookAndFeel!reset.jspa"));
        this.assertHasDefaultLookAndFeel();
    }

    public void testInvalidUrlLogoUpload() {
        this.tester.clickLinkWithText("Edit Configuration");
        FormParameterUtil formHelper = new FormParameterUtil(this.tester, "jiraform", "Update");
        formHelper.setFormElement("logoOption", "url");
        formHelper.setFormElement("logoUrl", "logourl");
        Node document = formHelper.submitForm();
        XPathLocator locator = new XPathLocator(document, "//*[@id='error-container']");
        TestLookAndFeel.assertTrue((boolean)locator.getText().contains("Failed to upload image from"));
    }

    public void testInvalidFaviconLogoUpload() {
        this.tester.clickLinkWithText("Edit Configuration");
        FormParameterUtil formHelper = new FormParameterUtil(this.tester, "jiraform", "Update");
        formHelper.setFormElement("faviconOption", "url");
        formHelper.setFormElement("faviconUrl", "logourl");
        Node document = formHelper.submitForm();
        XPathLocator locator = new XPathLocator(document, "//*[@id='error-container']");
        TestLookAndFeel.assertTrue((boolean)locator.getText().contains("Failed to upload image from"));
    }
}

