/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.ISSUES})
public class TestIssueLinkCheck
extends FuncTestCase {
    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueLinkCheck.xml");
    }

    public void testIssueLinkCheck() {
        this.navigation.gotoAdminSection("integrity_checker");
        this.tester.checkCheckbox("integrity_check_1_3", "3");
        this.tester.submit("check");
        this.text.assertTextPresent(this.locator.page(), "Choose the errors you would like to fix, or return to the previous screen");
        this.text.assertTextPresent(this.locator.page(), "The following Issue Link will be removed due to a related invalid issue: IssueLink (ID:10002)");
        this.text.assertTextPresent(this.locator.page(), "The following Issue Link will be removed due to a related invalid issue: IssueLink (ID:10003)");
        this.text.assertTextPresent(this.locator.page(), "The following Issue Link will be removed due to a related invalid issue: IssueLink (ID:10004)");
        this.tester.checkCheckbox("integrity_check_1_3", "3");
        this.tester.submit("fix");
        this.text.assertTextPresent(this.locator.page(), "3 error(s) were corrected");
        this.text.assertTextPresent(this.locator.page(), "The following Issue Link has been removed due to a related invalid issue: IssueLink (ID:10002)");
        this.text.assertTextPresent(this.locator.page(), "The following Issue Link has been removed due to a related invalid issue: IssueLink (ID:10003)");
        this.text.assertTextPresent(this.locator.page(), "The following Issue Link has been removed due to a related invalid issue: IssueLink (ID:10004)");
        this.navigation.gotoAdminSection("integrity_checker");
        this.tester.checkCheckbox("integrity_check_1_3", "3");
        this.tester.submit("check");
        this.text.assertTextPresent(this.locator.page(), "No errors were found");
        this.text.assertTextSequence(this.locator.page(), "PASSED", "Check that all Issue Links are associated with valid issues");
    }
}

