/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
public class TestAdministrators
extends JIRAWebTest {
    private static final String XPATH_ADMIN = "//ul[@id='adminlist']//a";
    private static final String XPATH_SYS_ADMIN = "//ul[@id='sysadminlist']//a";

    public TestAdministrators(String name) {
        super(name);
    }

    public void testDummy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testWithBothSystemAdminsAndAdmins() throws SAXException {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoPage("/secure/Administrators.jspa");
            this.text.assertTextPresent(new XPathLocator(this.tester, XPATH_ADMIN), "Administrator");
            this.text.assertTextPresent(new XPathLocator(this.tester, XPATH_SYS_ADMIN), "Root");
        }
        finally {
            this.navigation.login("root");
            this.administration.restoreBlankInstance();
            this.navigation.login("admin");
        }
    }

    public void _testWithOnlySysAdmins() throws SAXException {
        this.restoreBlankInstance();
        this.gotoPage("/secure/Administrators.jspa");
        this.text.assertTextPresent(new XPathLocator(this.tester, XPATH_SYS_ADMIN), "Administrator");
        this.assertions.assertNodeDoesNotExist(XPATH_ADMIN);
    }

    public void _testMailAddressesNormal() {
        this.restoreBlankInstance();
        this.gotoDashboard();
        this.clickLinkWithText("Contact Administrators");
        this.assertLinkPresent("admin");
        this.assertTextPresent("admin@example.com");
    }

    public void _testMailAddressesHidden() {
        this.restoreBlankInstance();
        this.editEmailVisibility("hide");
        this.clickLinkWithText("Contact Administrators");
        this.assertLinkNotPresent("admin");
        this.assertTextNotPresent("admin@example.com");
    }

    public void _testMailAddressesMasked() {
        this.restoreBlankInstance();
        this.editEmailVisibility("mask");
        this.clickLinkWithText("Contact Administrators");
        this.assertLinkPresent("admin");
        this.assertTextPresent("admin at example dot com");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testMailAddressesLoggedInUsersOnly() {
        try {
            this.restoreBlankInstance();
            this.editEmailVisibility("user");
            this.clickLinkWithText("Contact Administrators");
            this.assertLinkPresent("admin");
            this.assertTextPresent("admin@example.com");
            this.logout();
            this.clickLinkWithText("Contact Administrators");
            this.assertLinkNotPresent("admin");
            this.assertTextNotPresent("admin@example.com");
        }
        finally {
            this.login("admin");
        }
    }

    private void editEmailVisibility(String visibility) {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.clickLinkWithText("Edit Configuration");
        this.setFormElement("title", "jWebTest JIRA installation");
        this.checkCheckbox("emailVisibility", visibility);
        this.submit("Update");
    }
}

