/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
public class TestAdminMenuWebFragment
extends JIRAWebTest {
    public TestAdminMenuWebFragment(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestWebFragment.xml");
    }

    @Override
    public void tearDown() {
        this.login("admin", "admin");
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testBackToProjectConfigLink() {
        this.login("admin");
        this.navigation.gotoAdminSection("view_projects");
        this.assertLinkPresentWithText("homosapien");
        this.clickLinkWithText("homosapien");
        this.assertions.assertNodeByIdDoesNotExist("proj-config-return-link");
        this.clickLink("view_project_issuetypes_tab");
        this.assertions.assertNodeByIdExists("project-config-panel-issuetypes");
        this.assertions.assertNodeByIdDoesNotExist("proj-config-return-link");
        this.assertions.assertNodeByIdHasText("project-config-issuetype-scheme-name", "Default Issue Type Scheme");
        this.clickLink("project-config-issuetype-scheme-change");
        this.assertions.assertNodeByIdExists("proj-config-return-link");
        this.assertions.assertNodeByIdHasText("back-lnk", "Back to project: homosapien");
        this.clickLink("back-lnk");
        this.assertions.assertNodeByIdExists("project-config-panel-issuetypes");
        this.assertions.assertNodeByIdDoesNotExist("proj-config-return-link");
        this.assertions.assertNodeByIdHasText("project-config-issuetype-scheme-name", "Default Issue Type Scheme");
        this.clickLink("workflows");
        this.assertions.assertNodeByIdExists("proj-config-return-link");
        this.assertions.assertNodeByIdHasText("back-lnk", "Back to project: homosapien");
        this.clickLink("back-lnk");
        this.assertions.assertNodeByIdExists("project-config-panel-issuetypes");
        this.assertions.assertNodeByIdDoesNotExist("proj-config-return-link");
        this.assertions.assertNodeByIdHasText("project-config-issuetype-scheme-name", "Default Issue Type Scheme");
        this.clickLink("view_projects");
        this.assertions.assertNodeByIdDoesNotExist("proj-config-return-link");
        this.clickLink("workflows");
        this.assertions.assertNodeByIdDoesNotExist("proj-config-return-link");
    }

    public void testAdminMenuWebFragment() {
        this._testSystemAdminCanSeeAllAdminSections();
        this._testProjectAdminCanSeeProjectSectionOnly();
        this._testOtherUsersCannotSeeAdminSections();
    }

    public void _testSystemAdminCanSeeAllAdminSections() {
        this.login("admin", "admin");
        this.gotoAdmin();
        this.assertAdminLinksAreVisible();
    }

    public void _testProjectAdminCanSeeProjectSectionOnly() {
        this.login("project_admin", "project_admin");
        this.navigation.gotoAdmin();
        this.assertAdminLinksAreNotVisible();
    }

    public void _testOtherUsersCannotSeeAdminSections() {
        this.login("user", "user");
        this.gotoPage("/secure/project/ViewProjects.jspa");
        this.assertTextPresent("You do not have the permissions to administer any projects, or there are none created.");
        this.assertAdminLinksAreNotVisible();
        this.logout();
        this.gotoPage("/secure/project/ViewProjects.jspa");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-message.warning"), "If you log in or sign up for an account, you might be able to see more here.");
        this.assertions.assertNodeByIdDoesNotExist("adminMenu");
    }

    public void assertAdminLinksAreVisible() {
        this.assertLinkPresent("view_projects");
        this.assertLinkPresent("user_browser");
        this.assertLinkPresent("group_browser");
        this.assertLinkPresent("project_role_browser");
        this.assertLinkPresent("attachments");
        this.assertLinkPresent("cvs_modules");
        this.assertLinkPresent("edit_default_dashboard");
        this.assertLinkPresent("general_configuration");
        this.assertLinkPresent("global_permissions");
        this.assertLinkPresent("linking");
        this.assertLinkPresent("lookandfeel");
        this.assertLinkPresent("mail_servers");
        this.assertLinkPresent("timetracking");
        this.assertLinkPresent("trackbacks");
        this.assertLinkPresent("user_defaults");
        this.assertLinkPresent("permission_schemes");
        this.assertLinkPresent("scheme_tools");
        this.assertLinkPresent("view_custom_fields");
        this.assertLinkPresent("field_configuration");
        this.assertLinkPresent("issue_field_columns");
        this.assertLinkPresent("field_screens");
        this.assertLinkPresent("issue_types");
        this.assertLinkPresent("priorities");
        this.assertLinkPresent("resolutions");
        this.assertLinkPresent("statuses");
        this.assertLinkPresent("backup_data");
        this.assertLinkPresent("restore_data");
        this.assertLinkPresent("jelly_runner");
        this.assertLinkPresent("send_email");
        this.assertLinkPresent("edit_announcement");
        this.assertLinkPresent("indexing");
        this.assertLinkNotPresent("issue_caching");
        this.assertLinkPresent("integrity_checker");
        this.assertLinkPresent("license_details");
        this.assertLinkPresent("listeners");
        this.assertLinkPresent("logging_profiling");
        this.assertLinkPresent("mail_queue");
        this.assertLinkPresent("upm-admin-link");
        this.assertLinkPresent("scheduler_details");
        this.assertLinkPresent("services");
        this.assertLinkPresent("system_info");
        this.assertLinkPresent("view_categories");
        this.assertLinkPresent("security_schemes");
        this.assertLinkPresent("workflow_schemes");
        this.assertLinkPresent("field_configuration");
        this.assertLinkPresent("issue_fields");
        this.assertLinkPresent("issue_type_screen_scheme");
        this.assertLinkPresent("eventtypes");
        this.assertLinkPresent("subtasks");
        this.assertLinkPresent("workflows");
        this.assertLinkPresent("field_screen_scheme");
    }

    public void assertAdminLinksAreNotVisible() {
        this.assertLinkPresent("view_projects");
        this.assertLinkNotPresent("user_browser");
        this.assertLinkNotPresent("group_browser");
        this.assertLinkNotPresent("project_role_browser");
        this.assertLinkNotPresent("attachments");
        this.assertLinkNotPresent("cvs_modules");
        this.assertLinkNotPresent("edit_default_dashboard");
        this.assertLinkNotPresent("general_configuration");
        this.assertLinkNotPresent("global_permissions");
        this.assertLinkNotPresent("linking");
        this.assertLinkNotPresent("lookandfeel");
        this.assertLinkNotPresent("mail_servers");
        this.assertLinkNotPresent("timetracking");
        this.assertLinkNotPresent("trackbacks");
        this.assertLinkNotPresent("user_defaults");
        this.assertLinkNotPresent("permission_schemes");
        this.assertLinkNotPresent("scheme_tools");
        this.assertLinkNotPresent("view_custom_fields");
        this.assertLinkNotPresent("field_configuration");
        this.assertLinkNotPresent("issue_field_columns");
        this.assertLinkNotPresent("field_screens");
        this.assertLinkNotPresent("issue_types");
        this.assertLinkNotPresent("priorities");
        this.assertLinkNotPresent("resolutions");
        this.assertLinkNotPresent("statuses");
        this.assertLinkNotPresent("backup_data");
        this.assertLinkNotPresent("restore_data");
        this.assertLinkNotPresent("jelly_runner");
        this.assertLinkNotPresent("send_email");
        this.assertLinkNotPresent("edit_announcement");
        this.assertLinkNotPresent("indexing");
        this.assertLinkNotPresent("issue_caching");
        this.assertLinkNotPresent("integrity_checker");
        this.assertLinkNotPresent("license_details");
        this.assertLinkNotPresent("listeners");
        this.assertLinkNotPresent("logging_profiling");
        this.assertLinkNotPresent("mail_queue");
        this.assertLinkNotPresent("plugins");
        this.assertLinkNotPresent("scheduler_details");
        this.assertLinkNotPresent("services");
        this.assertLinkNotPresent("system_info");
        this.assertLinkNotPresent("view_categories");
        this.assertLinkNotPresent("security_schemes");
        this.assertLinkNotPresent("workflow_schemes");
        this.assertLinkNotPresent("field_configuration");
        this.assertLinkNotPresent("issue_fields");
        this.assertLinkNotPresent("issue_type_screen_scheme");
        this.assertLinkNotPresent("eventtypes");
        this.assertLinkNotPresent("subtasks");
        this.assertLinkNotPresent("workflows");
        this.assertLinkNotPresent("field_screen_scheme");
    }
}

