/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;

@WebTest(value={Category.FUNC_TEST, Category.IMPORT_EXPORT})
public class TestXmlRestore
extends FuncTestCase {
    public TestXmlRestore(String name) {
        this.setName(name);
    }

    public void testRestoreDataWhereCurrentUserDoesntExist() {
        this.administration.restoreBlankInstance();
        this.administration.usersAndGroups().addUser("idontexist");
        this.administration.usersAndGroups().addUserToGroup("idontexist", "jira-administrators");
        this.navigation.logout();
        this.navigation.login("idontexist");
        this.getTester().gotoPage("secure/admin/XmlRestore!default.jspa");
        this.getTester().setWorkingForm("jiraform");
        String filePath = this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/blankprojects.xml";
        this.getTester().setFormElement("filename", filePath);
        this.getTester().setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.getTester().submit();
        this.administration.waitForRestore();
        this.getTester().assertTextPresent("Your project has been successfully imported");
        this.getTester().assertTextNotPresent("NullPointerException");
        this.navigation.disableWebSudo();
        this.navigation.login("admin", "admin");
        this.administration.generalConfiguration().setBaseUrl(this.getBaseUrl());
    }

    public void testRestoreWithCustomPathsErrors() {
        try {
            this.administration.restoreData("TestXMLRestore.xml");
        }
        catch (Throwable e) {
            TestXmlRestore.assertTrue((String)"custom path should not be created", (boolean)e.getMessage().startsWith("Failed to restore JIRA data. Cause: specified in the backup file is not valid"));
        }
        this.tester.assertTextPresent("specified in the backup file is not valid");
    }

    private String getBaseUrl() {
        return this.getEnvironmentData().getBaseUrl().toExternalForm();
    }
}

