/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.table;

import com.atlassian.jira.functest.framework.util.url.URLUtil;
import com.atlassian.jira.webtests.table.AbstractSimpleCell;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;

public class LinkCell
extends AbstractSimpleCell {
    private final String url;
    private final String label;

    public LinkCell(String url, String label) {
        this.url = url;
        this.label = label;
    }

    public String toString() {
        return "[url: '" + this.url + "', label: '" + this.label + "']";
    }

    @Override
    public String getCellAsText(WebTable table, int row, int col) {
        TableCell tableCell = table.getTableCell(row, col);
        WebLink[] links = tableCell.getLinks();
        if (links != null && links.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < links.length; ++i) {
                WebLink webLink = links[i];
                String urlString = webLink.getURLString();
                sb.append("[link: '").append(urlString).append("']");
            }
            return sb.toString();
        }
        return "No Links was found in " + table.getID() + "[" + row + ", " + col + "]";
    }

    @Override
    public boolean equals(WebTable table, int row, int col) {
        return this.tableCellHasLinkThatContains(table, row, col, this.url) && this.tableCellHasStrictText(table, row, col, this.label);
    }

    protected boolean tableCellHasLinkThatContains(WebTable table, int row, int col, String link) {
        if (link == null) {
            return this.tableCellHasNoLinks(table, row, col);
        }
        TableCell tableCell = table.getTableCell(row, col);
        WebLink[] links = tableCell.getLinks();
        if (links != null && links.length > 0) {
            for (int i = 0; i < links.length; ++i) {
                WebLink webLink = links[i];
                String urlString = webLink.getURLString();
                if (urlString == null || !URLUtil.compareURLStrings(link, urlString)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean tableCellHasNoLinks(WebTable table, int row, int col) {
        boolean result;
        TableCell tableCell = table.getTableCell(row, col);
        WebLink[] links = tableCell.getLinks();
        boolean bl = result = links == null || links.length == 0;
        if (!result) {
            // empty if block
        }
        return result;
    }

    protected boolean tableCellHasStrictText(WebTable table, int row, int col, String text) {
        boolean result;
        String cellContent = table.getCellAsText(row, col);
        if ("".equals(text)) {
            result = "".equals(cellContent.trim());
        } else {
            boolean bl = result = cellContent.indexOf(text) != -1;
        }
        if (!result) {
            // empty if block
        }
        return result;
    }
}

