/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests;

import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.log.FuncTestOut;
import com.meterware.httpunit.HttpUnitOptions;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.sourceforge.jwebunit.WebTestCase;
import org.apache.commons.lang.StringUtils;

public class WebTestCaseWrapper
extends WebTestCase {
    public static void raiseRuntimeException(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public WebTestCaseWrapper(String name) {
        super(name);
    }

    public WebTestCaseWrapper() {
    }

    public void clickCancelButton() {
        WebTestCaseWrapper.assertTrue((String)"Scripting must be enabled in the HttpUnit for cancel to work correctly", (boolean)HttpUnitOptions.isScriptingEnabled());
        this.clickButton("cancelButton");
    }

    public void assertTextPresent(String text) {
        WebTestCaseWrapper.log("Asserting text present: " + text);
        super.assertTextPresent(text);
    }

    public void assertTextNotPresent(String text) {
        WebTestCaseWrapper.log("Asserting text *not* present: " + text);
        super.assertTextNotPresent(text);
    }

    public void assertTextInTable(String tableSummaryOrId, String text) {
        WebTestCaseWrapper.log("Asserting text present in table (" + tableSummaryOrId + ") : " + text);
        super.assertTextInTable(tableSummaryOrId, text);
    }

    public void assertElementPresent(String anID) {
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//*[@id='" + anID + "']");
        WebTestCaseWrapper.assertTrue((String)("Could not find any elements with the id '" + anID + "'"), (xPathLocator.getNodes().length > 0 ? 1 : 0) != 0);
    }

    public void assertElementNotPresent(String anID) {
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//*[@id='" + anID + "']");
        WebTestCaseWrapper.assertTrue((String)("Found an element with the id '" + anID + "' - was expecting none"), (xPathLocator.getNodes().length == 0 ? 1 : 0) != 0);
    }

    public void selectMultiOption(String selectName, String option) {
        String value = this.getDialog().getValueForOption(selectName, option);
        this.checkCheckbox(selectName, value);
    }

    public void selectMultiOptionByValue(String selectName, String value) {
        this.checkCheckbox(selectName, value);
    }

    public void selectOption(String selectName, String option) {
        super.selectOption(selectName, option);
    }

    public void assertOptionValuePresent(String selectName, String optionLabel) {
        if (!this.getDialog().hasRadioOption(selectName, optionLabel)) {
            WebTestCaseWrapper.fail((String)("Option with value " + optionLabel + " not found for select name " + selectName));
        }
    }

    public void assertOptionValueNotPresent(String selectName, String option) {
        if (this.getDialog().hasRadioOption(selectName, option)) {
            WebTestCaseWrapper.fail((String)("Option with value " + option + " found for select name " + selectName));
        }
    }

    public void submit(String buttonName) {
        try {
            super.submit(buttonName);
        }
        catch (Throwable e) {
            WebTestCaseWrapper.raiseRuntimeException(e);
        }
    }

    public static void log(String msg) {
        FuncTestOut.log(msg);
    }

    public static void logSection(String msg) {
        WebTestCaseWrapper.log("");
        WebTestCaseWrapper.log(StringUtils.repeat((String)"-", (int)msg.length()));
        WebTestCaseWrapper.log(msg);
    }

    public static void log(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        WebTestCaseWrapper.log(sw.toString());
    }

    public static void log(String msg, Throwable t) {
        WebTestCaseWrapper.log(msg);
        WebTestCaseWrapper.log(t);
    }

    public void dumpResponse() {
        super.dumpResponse(FuncTestOut.out);
    }

    public void dumpResponse(Throwable t) {
        if (t != null) {
            t.printStackTrace(FuncTestOut.out);
        }
        super.dumpResponse(FuncTestOut.out);
    }

    public void tearDown() {
        this.tester = null;
        try {
            super.tearDown();
        }
        catch (Throwable t) {
            WebTestCaseWrapper.raiseRuntimeException(t);
        }
    }
}

