/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests;

import com.atlassian.jira.webtests.EmailFuncTestCase;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;

public abstract class AbstractSubscriptionEmailTest
extends EmailFuncTestCase {
    private static final String VIEW_FILTER_REGEX = "secure/IssueNavigator.jspa\\?mode=hide\\&requestId=\\d+";
    private static final String EDIT_FILTER_REGEX = "secure/FilterSubscription\\!default.jspa\\?subId=\\d+&filterId=\\d+";
    private static final String TEXT_HEADER_REGEX = "Key\\s*Summary";
    private static final String[] HTML_TABLE_HEADER = new String[]{"Key", "Summary", "Assignee", "Reporter", "Status", "Created", "Updated", "Due"};

    protected String assertTextMessageValid(MimeMessage message, FilterConfig config, String from, String to, String userName) throws Exception {
        this.assertMessageHeader(message, from, to, config);
        String body = GreenMailUtil.getBody((Part)message);
        body = this.assertTextMessageStart(body, config, userName);
        return this.assertIssuesInTextMessage(config, body);
    }

    protected String assertHtmlMessageValid(MimeMessage message, FilterConfig config, String from, String to, String userName) throws Exception {
        this.assertMessageHeader(message, from, to, config);
        String body = GreenMailUtil.getBody((Part)message);
        body = this.assertHtmlMessageStart(body, config, userName);
        this.assertHtmlMessageFooter(body);
        return this.assertIssuesInHtmlMessage(config, body);
    }

    private void assertMessageHeader(MimeMessage message, String from, String to, FilterConfig filterConfig) throws Exception {
        this.assertEmailFromEquals(message, from);
        this.assertEmailToEquals(message, to);
        this.assertEmailSubjectEquals(message, "[JIRATEST] Subscription: " + filterConfig.getFilterName());
    }

    private String assertTextMessageStart(String body, FilterConfig filterConfig, String userName) throws Exception {
        this.assertNotStringContains(body, "<html>");
        body = this.assertStringContains(body, "Issue Subscription");
        String filterStr = "Filter: " + filterConfig.getFilterName() + " " + AbstractSubscriptionEmailTest.getFilterStatus(filterConfig);
        body = this.assertStringContains(body, filterStr);
        if (filterConfig.getFilterDescription() != null) {
            body = this.assertStringContains(body, filterConfig.getFilterDescription());
        }
        String subscriber = "Subscriber: " + userName;
        return this.assertStringContains(body, subscriber);
    }

    private String assertHtmlMessageStart(String body, FilterConfig filterConfig, String username) {
        this.assertStringContains(body, "<html>");
        body = this.assertStringContains(body, "Issue Subscription");
        body = this.assertStringContains(body, "Filter");
        body = this.assertStringMatchesRegex(body, VIEW_FILTER_REGEX);
        body = this.assertStringContains(body, filterConfig.getFilterName());
        body = this.assertStringContains(body, AbstractSubscriptionEmailTest.getFilterStatus(filterConfig));
        return this.assertStringContains(body, username);
    }

    private void assertHtmlMessageFooter(String body) {
        this.assertStringContains(body, "This message is automatically generated by JIRA.");
    }

    private String assertIssuesInTextMessage(FilterConfig filterConfig, String body) {
        if (filterConfig.getTotalIssues() > 0) {
            body = this.assertStringMatchesRegex(body, TEXT_HEADER_REGEX);
            Iterator issuesIter = filterConfig.getIssueIterator();
            while (issuesIter.hasNext()) {
                Integer issue = (Integer)issuesIter.next();
                String issueKey = filterConfig.getProjectKey() + "-" + issue;
                body = this.assertStringContains(body, issueKey);
                String url = "browse/" + issueKey;
                body = this.assertStringContains(body, url);
            }
        } else {
            this.assertNotStringMatchesRegex(body, TEXT_HEADER_REGEX);
        }
        this.assertNotStringMatchesRegex(body, filterConfig.getProjectKey() + "-\\d+");
        return body;
    }

    private String assertIssuesInHtmlMessage(FilterConfig filterConfig, String body) {
        if (filterConfig.getTotalIssues() > 0) {
            body = this.assertStringContains(body, HTML_TABLE_HEADER);
            Iterator issuesIter = filterConfig.getIssueIterator();
            while (issuesIter.hasNext()) {
                Integer issue = (Integer)issuesIter.next();
                String issueKey = filterConfig.getProjectKey() + "-" + issue;
                String url = "browse/" + issueKey;
                body = this.assertStringContains(body, url);
                body = this.assertStringContains(body, url);
                body = this.assertStringContains(body, issueKey);
                body = this.assertStringContains(body, url);
            }
        } else {
            this.assertNotStringContains(body, HTML_TABLE_HEADER);
        }
        this.assertNotStringMatchesRegex(body, filterConfig.getProjectKey() + "-\\d+");
        return body;
    }

    protected String assertPartialLink(FilterConfig filterConfig, String body) {
        String partialString = "Displaying " + filterConfig.getReturnedIssues() + " of " + filterConfig.getTotalIssues() + " matched issues. You may view all matched issues";
        body = this.assertStringContains(body, partialString);
        return this.assertStringMatchesRegex(body, VIEW_FILTER_REGEX);
    }

    protected void assertNotPartialLink(String body) {
        this.assertNotStringContains(body, "You may view all matched issues");
    }

    protected String assertEditLink(String body) {
        body = this.assertStringContains(body, "You may edit this subscription");
        return this.assertStringMatchesRegex(body, EDIT_FILTER_REGEX);
    }

    protected void assertNotEditLink(String body) {
        this.assertNotStringContains(body, "You may edit this subscription");
    }

    private void assertNotStringContains(String string, String substring) {
        if (string.indexOf(substring) >= 0) {
            AbstractSubscriptionEmailTest.fail((String)("String '" + string + "' shouldn't contain '" + substring + "'."));
        }
    }

    private void assertNotStringContains(String string, String[] substrings) {
        for (int i = 0; string != null && i < substrings.length; ++i) {
            String substring = substrings[i];
            string = AbstractSubscriptionEmailTest.findStringInString(string, substring);
        }
        if (string != null) {
            AbstractSubscriptionEmailTest.fail((String)("Found strings '" + Arrays.asList(substrings).toString() + "' in text."));
        }
    }

    private String assertStringContains(String string, String substring) {
        String result = AbstractSubscriptionEmailTest.findStringInString(string, substring);
        if (result == null) {
            AbstractSubscriptionEmailTest.fail((String)("Unable to find string '" + substring + "' in " + string));
        }
        return result;
    }

    private String assertStringContains(String string, String[] substrings) {
        for (int i = 0; i < substrings.length; ++i) {
            String substring = substrings[i];
            string = this.assertStringContains(string, substring);
        }
        return string;
    }

    private static String findStringInString(String string, String substring) {
        int pos = string.indexOf(substring);
        if (pos < 0) {
            return null;
        }
        return string.substring(pos + substring.length());
    }

    private String assertStringMatchesRegex(String string, String regex) {
        String result = AbstractSubscriptionEmailTest.findRegexInString(string, regex);
        if (result == null) {
            AbstractSubscriptionEmailTest.fail((String)("Unable to find regex '" + regex + "' in string '" + string + "'."));
        }
        return result;
    }

    private void assertNotStringMatchesRegex(String string, String regex) {
        if (AbstractSubscriptionEmailTest.findRegexInString(string, regex) != null) {
            AbstractSubscriptionEmailTest.fail((String)("The regular expression '" + regex + "' should not match the string '" + string + "'."));
        }
    }

    private static String findRegexInString(String string, String regex) {
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher match = pattern.matcher(string);
        if (!match.find()) {
            return null;
        }
        return string.substring(match.end());
    }

    private static String getFilterStatus(FilterConfig filterConfig) {
        if (!filterConfig.isPaged()) {
            if (filterConfig.getTotalIssues() == 1) {
                return "(" + filterConfig.getTotalIssues() + " issue)";
            }
            return "(" + filterConfig.getTotalIssues() + " issues)";
        }
        return "(" + filterConfig.getReturnedIssues() + " of " + filterConfig.getTotalIssues() + " issues)";
    }

    private void gotoSubscribeFilter(FilterConfig config) {
        this.navigation.manageFilters().allFilters();
        this.tester.clickLink("subscribe_" + config.getFilterName());
    }

    protected void subscribeToFilterAndRun(FilterConfig config, String group) {
        this.gotoSubscribeFilter(config);
        if (group != null) {
            this.tester.setFormElement("groupName", group);
        }
        this.tester.setFormElement("emailOnEmpty", "true");
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, 5);
        String cronExpr = "0 0 0 1 1 ? " + calendar.get(1);
        this.tester.setFormElement("filter.subscription.prefix.dailyWeeklyMonthly", "advanced");
        this.tester.setFormElement("filter.subscription.prefix.cronString", cronExpr);
        this.tester.submit();
        this.tester.assertTextPresent("View Subscriptions for " + config.getFilterName());
        this.tester.assertTextPresent(cronExpr);
        this.tester.clickLinkWithText("Run now");
        this.tester.assertTextPresent("View Subscriptions for " + config.getFilterName());
        this.tester.assertTextPresent(cronExpr);
    }

    protected static class CountingIterator
    implements Iterator {
        private int current;
        private final int endRange;
        private final int increment;

        public CountingIterator(int start, int length) {
            this.endRange = start + length;
            this.current = start;
            this.increment = length < 0 ? -1 : 1;
        }

        @Override
        public boolean hasNext() {
            return this.current != this.endRange;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            int ret = this.current;
            this.current += this.increment;
            return new Integer(ret);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class FilterConfig {
        public static final FilterConfig ADMIN_FILTER_ZERO_RESULTS = new FilterConfig("ZeroFilter", "This is the zero filter.", "ProjectOne", "ONE", 0, 0);
        public static final FilterConfig ADMIN_FILTER_PARTIAL;
        public static final FilterConfig ADMIN_FILTER_FULL;
        public static final FilterConfig FRED_FILTER_ZERO_RESULTS;
        public static final FilterConfig FRED_FILTER_PARTIAL;
        public static final FilterConfig FRED_FILTER_FULL;
        private final String filterName;
        private final String filterDescription;
        private final int returnedIssues;
        private final int totalIssues;
        private final String projectName;
        private final String projectKey;

        protected FilterConfig(String filterName, String filterDescription, String projectName, String projectKey, int returnedIssues, int totalIssues) {
            this.projectName = projectName;
            this.projectKey = projectKey;
            this.filterName = filterName;
            this.filterDescription = filterDescription;
            this.returnedIssues = returnedIssues;
            this.totalIssues = totalIssues;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public String getFilterDescription() {
            return this.filterDescription;
        }

        public int getReturnedIssues() {
            return this.returnedIssues;
        }

        public int getTotalIssues() {
            return this.totalIssues;
        }

        public boolean isPaged() {
            return this.returnedIssues != this.totalIssues;
        }

        public Iterator getIssueIterator() {
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new IllegalStateException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getProjectKey() {
            return this.projectKey;
        }

        static {
            FRED_FILTER_ZERO_RESULTS = new FilterConfig("FredZeroFilter", "Fred Zero Filter for test.", "ProjectOne", "ONE", 0, 0);
            ADMIN_FILTER_PARTIAL = new FilterConfig("FilterOne", "Filter One Description.", "ProjectOne", "ONE", 200, 210){

                @Override
                public Iterator getIssueIterator() {
                    return new CountingIterator(this.getTotalIssues(), -this.getReturnedIssues());
                }
            };
            ADMIN_FILTER_FULL = new FilterConfig("FilterTwo", null, "ProjectTwo", "TWO", 2, 2){

                @Override
                public Iterator getIssueIterator() {
                    return new CountingIterator(1, this.getReturnedIssues());
                }
            };
            FRED_FILTER_PARTIAL = new FilterConfig("FredFilterOne", null, "ProjectOne", "ONE", 200, 210){

                @Override
                public Iterator getIssueIterator() {
                    return new CountingIterator(1, this.getReturnedIssues());
                }
            };
            FRED_FILTER_FULL = new FilterConfig("FredFilterTwo", "This is a simple filter that will return all results.", "ProjectTwo", "TWO", 2, 2){

                @Override
                public Iterator getIssueIterator() {
                    return new CountingIterator(this.getTotalIssues(), -this.getReturnedIssues());
                }
            };
        }
    }
}

