/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.util.dbc.NumberAssertions;
import java.util.Date;

public class PeriodicClock
implements Clock {
    private final long increment;
    private final int periodLength;
    private long current;
    private int currentInPeriod = 0;

    public PeriodicClock(long intitialValue, long increment, int periodLength) {
        this.current = intitialValue;
        this.increment = NumberAssertions.greaterThan("increment", increment, 0L);
        this.periodLength = NumberAssertions.greaterThan("periodLength", periodLength, 0);
    }

    public PeriodicClock(long increment, int periodLength) {
        this(0L, increment, periodLength);
    }

    public PeriodicClock(long increment) {
        this(0L, increment, 1);
    }

    public Date getCurrentDate() {
        long answer = this.current;
        if (this.periodFinished()) {
            this.current += this.increment;
        }
        return new Date(answer);
    }

    private boolean periodFinished() {
        ++this.currentInPeriod;
        if (this.currentInPeriod == this.periodLength) {
            this.currentInPeriod = 0;
            return true;
        }
        return false;
    }
}

