/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.xmlbackup;

import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlBackupCopier {
    private static final Logger log = LoggerFactory.getLogger(XmlBackupCopier.class);
    private static final String LOCALHOST_8090 = "\"http://localhost:8080/jira\"";
    private static final String LOCALHOST_8080 = "\"http://localhost:8090/jira\"";
    private final URL baseUrl;
    private Map<Pattern, String> baseUrlSubstitutions;

    public XmlBackupCopier(URL baseUrl) {
        this.baseUrl = (URL)Preconditions.checkNotNull((Object)baseUrl);
        this.baseUrlSubstitutions = this.createBaseUrlSubstitution(baseUrl.toString());
    }

    public boolean copyXmlBackupTo(String sourcePath, String destinationPath) {
        return this.copyXmlBackupTo(sourcePath, destinationPath, Collections.<Pattern, String>emptyMap());
    }

    public boolean copyXmlBackupTo(String sourcePath, String destinationPath, Map<Pattern, String> substitutions) {
        if (sourcePath.endsWith(".zip")) {
            try {
                log.trace("File '{}' is a ZIP file, copying without performing substiturions", (Object)sourcePath);
                FileUtils.copyFile((File)new File(sourcePath), (File)new File(destinationPath));
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String ls = System.getProperty("line.separator");
        HashMap tokensPlusBaseUrlSubs = Maps.newHashMap(substitutions);
        tokensPlusBaseUrlSubs.putAll(this.baseUrlSubstitutions);
        boolean wasReplaced = false;
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            reader = new BufferedReader(new FileReader(sourcePath));
            writer = new BufferedWriter(new FileWriter(new File(destinationPath)));
            log.trace("Begin copying '{} to '{}'", (Object)sourcePath, (Object)destinationPath);
            int lineNumber = 1;
            String line = reader.readLine();
            while (line != null) {
                for (Map.Entry subst : tokensPlusBaseUrlSubs.entrySet()) {
                    Matcher m = ((Pattern)subst.getKey()).matcher(line);
                    if (!m.find()) continue;
                    wasReplaced = true;
                    line = m.replaceAll((String)subst.getValue());
                    log.trace("{}:{} replaced '{}' with '{}'", new Object[]{sourcePath, lineNumber, subst.getKey(), subst.getValue()});
                }
                writer.write(line);
                writer.write(ls);
                ++lineNumber;
                line = reader.readLine();
            }
            log.trace("Finished copying '{} to '{}'", (Object)sourcePath, (Object)destinationPath);
            boolean bl = wasReplaced;
            return bl;
        }
        catch (IOException e) {
            log.trace("Error copying '{} to '{}'", (Object)sourcePath, (Object)destinationPath);
            throw new RuntimeException("Could not copy file " + sourcePath + " to the import directory in jira home " + destinationPath, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable t) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    protected Map<Pattern, String> createBaseUrlSubstitution(String baseURL) {
        return MapBuilder.newBuilder().add(Pattern.compile(String.format("value=%s", LOCALHOST_8080), 16), Matcher.quoteReplacement(String.format("value=\"%s\"", baseURL))).add(Pattern.compile(String.format("value=%s", LOCALHOST_8090), 16), Matcher.quoteReplacement(String.format("value=\"%s\"", baseURL))).toMap();
    }
}

