/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util.json;

import com.atlassian.jira.functest.framework.util.json.TestJSONArray;
import com.atlassian.jira.functest.framework.util.json.TestJSONException;
import com.atlassian.jira.functest.framework.util.json.TestJSONString;
import com.atlassian.jira.functest.framework.util.json.TestJSONTokener;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TestJSONObject {
    private HashMap myHashMap;
    public static final Null NULL = Null.access$000();

    public TestJSONObject() {
        this.myHashMap = new HashMap();
    }

    public TestJSONObject(TestJSONObject jo, String[] names) throws TestJSONException {
        this();
        for (int i = 0; i < names.length; ++i) {
            this.putOpt(names[i], jo.opt(names[i]));
        }
    }

    public TestJSONObject(TestJSONTokener x) throws TestJSONException {
        this();
        if (x.nextClean() != '{') {
            x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    x.syntaxError("A JSONObject text must end with '}'");
                    return;
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                x.syntaxError("Expected a ':' after a key");
            }
            this.put(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            x.syntaxError("Expected a ',' or '}'");
        }
    }

    public TestJSONObject(Map map) {
        this.myHashMap = map == null ? new HashMap() : new HashMap(map);
    }

    public TestJSONObject(Object bean) {
        this();
        Class<?> klass = bean.getClass();
        Method[] methods = klass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            try {
                Method method = methods[i];
                String name = method.getName();
                String key = "";
                if (name.startsWith("get")) {
                    key = name.substring(3);
                } else if (name.startsWith("is")) {
                    key = name.substring(2);
                }
                if (key.length() <= 0 || !Character.isUpperCase(key.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (key.length() == 1) {
                    key = key.toLowerCase();
                } else if (!Character.isUpperCase(key.charAt(1))) {
                    key = key.substring(0, 1).toLowerCase() + key.substring(1);
                }
                this.put(key, method.invoke(bean, new Object[0]));
                continue;
            }
            catch (RuntimeException e) {
                continue;
            }
            catch (InvocationTargetException e) {
                continue;
            }
            catch (TestJSONException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    public TestJSONObject(Object object, String[] names) {
        this();
        Class<?> c = object.getClass();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            try {
                Field field = c.getField(name);
                Object value = field.get(object);
                this.put(name, value);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public TestJSONObject(String source) throws TestJSONException {
        this(new TestJSONTokener(source));
    }

    public TestJSONObject accumulate(String key, Object value) throws TestJSONException {
        TestJSONObject.testValidity(value);
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, value instanceof TestJSONArray ? new TestJSONArray().put(value) : value);
        } else if (o instanceof TestJSONArray) {
            ((TestJSONArray)o).put(value);
        } else {
            this.put(key, new TestJSONArray().put(o).put(value));
        }
        return this;
    }

    public TestJSONObject append(String key, Object value) throws TestJSONException {
        TestJSONObject.testValidity(value);
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, new TestJSONArray().put(value));
        } else if (o instanceof TestJSONArray) {
            this.put(key, ((TestJSONArray)o).put(value));
        } else {
            throw new TestJSONException("JSONObject[" + key + "] is not a JSONArray.");
        }
        return this;
    }

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String s = Double.toString(d);
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object get(String key) throws TestJSONException {
        Object o = this.opt(key);
        if (o == null) {
            throw new TestJSONException("JSONObject[" + TestJSONObject.quote(key) + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(String key) throws TestJSONException {
        Object o = this.get(key);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new TestJSONException("JSONObject[" + TestJSONObject.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) throws TestJSONException {
        Object o = this.get(key);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.valueOf((String)o).doubleValue();
        }
        catch (Exception e) {
            throw new TestJSONException("JSONObject[" + TestJSONObject.quote(key) + "] is not a number.");
        }
    }

    public int getInt(String key) throws TestJSONException {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(key);
    }

    public TestJSONArray getJSONArray(String key) throws TestJSONException {
        Object o = this.get(key);
        if (o instanceof TestJSONArray) {
            return (TestJSONArray)o;
        }
        throw new TestJSONException("JSONObject[" + TestJSONObject.quote(key) + "] is not a JSONArray.");
    }

    public TestJSONObject getJSONObject(String key) throws TestJSONException {
        Object o = this.get(key);
        if (o instanceof TestJSONObject) {
            return (TestJSONObject)o;
        }
        throw new TestJSONException("JSONObject[" + TestJSONObject.quote(key) + "] is not a JSONObject.");
    }

    public long getLong(String key) throws TestJSONException {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(key);
    }

    public static String[] getNames(TestJSONObject jo) {
        int length = jo.length();
        if (length == 0) {
            return null;
        }
        Iterator i = jo.keys();
        String[] names = new String[length];
        int j = 0;
        while (i.hasNext()) {
            names[j] = (String)i.next();
            ++j;
        }
        return names;
    }

    public static String[] getNames(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> klass = object.getClass();
        Field[] fields = klass.getFields();
        int length = fields.length;
        if (length == 0) {
            return null;
        }
        String[] names = new String[length];
        for (int i = 0; i < length; ++i) {
            names[i] = fields[i].getName();
        }
        return names;
    }

    public String getString(String key) throws TestJSONException {
        return this.get(key).toString();
    }

    public boolean has(String key) {
        return this.myHashMap.containsKey(key);
    }

    public boolean isNull(String key) {
        return NULL.isNull(this.opt(key));
    }

    public Iterator keys() {
        return this.myHashMap.keySet().iterator();
    }

    public int length() {
        return this.myHashMap.size();
    }

    public TestJSONArray names() {
        TestJSONArray ja = new TestJSONArray();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            ja.put(keys.next());
        }
        return ja.length() == 0 ? null : ja;
    }

    public static String numberToString(Number n) throws TestJSONException {
        if (n == null) {
            throw new TestJSONException("Null pointer");
        }
        TestJSONObject.testValidity(n);
        String s = n.toString();
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object opt(String key) {
        return key == null ? null : this.myHashMap.get(key);
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public TestJSONObject put(String key, Collection value) throws TestJSONException {
        this.put(key, new TestJSONArray(value));
        return this;
    }

    public double optDouble(String key) {
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        try {
            Object o = this.opt(key);
            return o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble((String)o);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public TestJSONArray optJSONArray(String key) {
        Object o = this.opt(key);
        return o instanceof TestJSONArray ? (TestJSONArray)o : null;
    }

    public TestJSONObject optJSONObject(String key) {
        Object o = this.opt(key);
        return o instanceof TestJSONObject ? (TestJSONObject)o : null;
    }

    public long optLong(String key) {
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        Object o = this.opt(key);
        return o != null ? o.toString() : defaultValue;
    }

    public TestJSONObject put(String key, boolean value) throws TestJSONException {
        this.put(key, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public TestJSONObject put(String key, double value) throws TestJSONException {
        this.put(key, new Double(value));
        return this;
    }

    public TestJSONObject put(String key, int value) throws TestJSONException {
        this.put(key, new Integer(value));
        return this;
    }

    public TestJSONObject put(String key, long value) throws TestJSONException {
        this.put(key, new Long(value));
        return this;
    }

    public TestJSONObject put(String key, Map value) throws TestJSONException {
        this.put(key, new TestJSONObject(value));
        return this;
    }

    public TestJSONObject put(String key, Object value) throws TestJSONException {
        if (key == null) {
            throw new TestJSONException("Null key.");
        }
        if (value != null) {
            TestJSONObject.testValidity(value);
            this.myHashMap.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public TestJSONObject putOpt(String key, Object value) throws TestJSONException {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public Object remove(String key) {
        return this.myHashMap.remove(key);
    }

    static void testValidity(Object o) throws TestJSONException {
        if (o != null && (o instanceof Double ? ((Double)o).isInfinite() || ((Double)o).isNaN() : o instanceof Float && (((Float)o).isInfinite() || ((Float)o).isNaN()))) {
            throw new TestJSONException("JSON does not allow non-finite numbers.");
        }
    }

    public TestJSONArray toJSONArray(TestJSONArray names) throws TestJSONException {
        if (names == null || names.length() == 0) {
            return null;
        }
        TestJSONArray ja = new TestJSONArray();
        for (int i = 0; i < names.length(); ++i) {
            ja.put(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        try {
            Iterator keys = this.keys();
            StringBuffer sb = new StringBuffer("{");
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                Object o = keys.next();
                sb.append(TestJSONObject.quote(o.toString()));
                sb.append(':');
                sb.append(TestJSONObject.valueToString(this.myHashMap.get(o)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String toString(int indentFactor) throws TestJSONException {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) throws TestJSONException {
        int n = this.length();
        if (n == 0) {
            return "{}";
        }
        Iterator keys = this.keys();
        StringBuffer sb = new StringBuffer("{");
        int newindent = indent + indentFactor;
        if (n == 1) {
            Object o = keys.next();
            sb.append(TestJSONObject.quote(o.toString()));
            sb.append(": ");
            sb.append(TestJSONObject.valueToString(this.myHashMap.get(o), indentFactor, indent));
        } else {
            int i;
            while (keys.hasNext()) {
                Object o = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (i = 0; i < newindent; ++i) {
                    sb.append(' ');
                }
                sb.append(TestJSONObject.quote(o.toString()));
                sb.append(": ");
                sb.append(TestJSONObject.valueToString(this.myHashMap.get(o), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }

    static String valueToString(Object value) throws TestJSONException {
        if (NULL.isNull(value)) {
            return "null";
        }
        if (value instanceof TestJSONString) {
            String o;
            try {
                o = ((TestJSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new TestJSONException(e);
            }
            if (o instanceof String) {
                return o;
            }
            throw new TestJSONException("Bad value from toJSONString: " + o);
        }
        if (value instanceof Number) {
            return TestJSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof TestJSONObject || value instanceof TestJSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            return new TestJSONObject((Map)value).toString();
        }
        if (value instanceof Collection) {
            return new TestJSONArray((Collection)value).toString();
        }
        if (value.getClass().isArray()) {
            return new TestJSONArray(value).toString();
        }
        return TestJSONObject.quote(value.toString());
    }

    static String valueToString(Object value, int indentFactor, int indent) throws TestJSONException {
        if (value == null || value instanceof Null) {
            return "null";
        }
        try {
            String o;
            if (value instanceof TestJSONString && (o = ((TestJSONString)value).toJSONString()) instanceof String) {
                return o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value instanceof Number) {
            return TestJSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof TestJSONObject) {
            return ((TestJSONObject)value).toString(indentFactor, indent);
        }
        if (value instanceof TestJSONArray) {
            return ((TestJSONArray)value).toString(indentFactor, indent);
        }
        if (value instanceof Map) {
            return new TestJSONObject((Map)value).toString(indentFactor, indent);
        }
        if (value instanceof Collection) {
            return new TestJSONArray((Collection)value).toString(indentFactor, indent);
        }
        if (value.getClass().isArray()) {
            return new TestJSONArray(value).toString(indentFactor, indent);
        }
        return TestJSONObject.quote(value.toString());
    }

    public Writer write(Writer writer) throws TestJSONException {
        try {
            boolean b = false;
            Iterator keys = this.keys();
            writer.write(123);
            while (keys.hasNext()) {
                if (b) {
                    writer.write(44);
                }
                Object k = keys.next();
                writer.write(TestJSONObject.quote(k.toString()));
                writer.write(58);
                Object v = this.myHashMap.get(k);
                if (v instanceof TestJSONObject) {
                    ((TestJSONObject)v).write(writer);
                } else if (v instanceof TestJSONArray) {
                    ((TestJSONArray)v).write(writer);
                } else {
                    writer.write(TestJSONObject.valueToString(v));
                }
                b = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException e) {
            throw new TestJSONException(e);
        }
    }

    static final class Null {
        private static final Null INSTANCE = new Null();

        Null() {
        }

        boolean isNull(Object value) {
            return value == null || this.equals(value);
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "null";
        }

        static /* synthetic */ Null access$000() {
            return INSTANCE;
        }
    }
}

