/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util.dom;

import com.atlassian.jira.functest.framework.util.dom.DomBetterNode;
import com.atlassian.jira.functest.framework.util.dom.DomNodeCopier;
import com.atlassian.jira.functest.framework.util.dom.DomNodeOutputter;
import com.atlassian.jira.functest.framework.util.dom.SaxTagOutputter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomKit {
    private static final ThreadLocal nonvalidatingDocumentBuilders = new ThreadLocal(){

        protected Object initialValue() {
            return DomKit.buildDocumentBuilder();
        }
    };
    private static final boolean convertTagsToLowerCaseOnOutput = false;

    private static DocumentBuilder buildDocumentBuilder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static DocumentBuilder getNonValidatingDocumentBuilder() {
        return (DocumentBuilder)nonvalidatingDocumentBuilders.get();
    }

    public static Element getHtmlElement(Document document) {
        return DomKit.getFirstElementByTag(document, "HTML");
    }

    public static Element getBodyElement(Document document) {
        return DomKit.getFirstElementByTag(document, "BODY");
    }

    public static Element getFirstParentByTag(Element element, String parentTagName) {
        for (Element el = (Element)element.getParentNode(); el != null; el = (Element)el.getParentNode()) {
            if (!el.getTagName().equalsIgnoreCase(parentTagName)) continue;
            return el;
        }
        return null;
    }

    static Element getFirstElementByTag(Document document, String tagName) {
        NodeList nodeList = document.getElementsByTagName(tagName);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        nodeList = document.getElementsByTagName(tagName.toLowerCase());
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public static Text[] getTextNodes(Element element) {
        ArrayList textNodeList = new ArrayList();
        DomKit.walkDOMAndGatherTextNodes(element, textNodeList);
        return textNodeList.toArray(new Text[textNodeList.size()]);
    }

    public static String getCollapsedText(Node node) {
        ArrayList textList = new ArrayList();
        DomKit.walkDOMAndGatherText(node, textList);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < textList.size(); ++i) {
            String text = (String)textList.get(i);
            text = DomKit.canonicalTextNode(text);
            DomKit.smooshTogether(sb, text);
        }
        return sb.toString().trim();
    }

    public static String getRawText(Node node) {
        ArrayList textList = new ArrayList();
        DomKit.walkDOMAndGatherText(node, textList);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < textList.size(); ++i) {
            String text = (String)textList.get(i);
            sb.append(text);
        }
        return sb.toString();
    }

    private static StringBuffer smooshTogether(StringBuffer sb, String text) {
        if (DomKit.endsWithWhitespace(sb.toString()) && DomKit.startsWithWhitespace(text)) {
            sb = DomKit.rightTrim(sb);
            text = DomKit.leftTrim(text);
            sb.append(" ");
        }
        sb.append(text);
        return sb;
    }

    private static String canonicalTextNode(String textNodeStr) {
        String[] cleanupStrs = new String[]{"\u00a0"};
        for (int i = 0; i < cleanupStrs.length; ++i) {
            String cleanupStr = cleanupStrs[i];
            int si = textNodeStr.indexOf(cleanupStr);
            if (si == -1) continue;
            int nbsplen = cleanupStr.length();
            StringBuffer sb = new StringBuffer(textNodeStr);
            while (si != -1) {
                sb.replace(si, si + nbsplen, " ");
                ++si;
                si = sb.indexOf(cleanupStr, si);
            }
            textNodeStr = sb.toString();
        }
        boolean hasFrontWhiteSpace = DomKit.startsWithWhitespace(textNodeStr);
        boolean hasBackWhiteSpace = DomKit.endsWithWhitespace(textNodeStr);
        textNodeStr = textNodeStr.trim();
        if (hasFrontWhiteSpace) {
            textNodeStr = " " + textNodeStr;
        }
        if (hasBackWhiteSpace) {
            textNodeStr = textNodeStr + " ";
        }
        if (DomKit.isAllWhitespace(textNodeStr)) {
            textNodeStr = " ";
        }
        return textNodeStr;
    }

    private static boolean startsWithWhitespace(String s) {
        char[] chars = s.toCharArray();
        int len = chars.length;
        return len > 0 && Character.isWhitespace(chars[0]);
    }

    private static boolean endsWithWhitespace(String s) {
        char[] chars = s.toCharArray();
        int len = chars.length;
        return len > 0 && Character.isWhitespace(chars[len - 1]);
    }

    private static boolean isAllWhitespace(String s) {
        char[] chars = s.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(chars[i])) continue;
            return false;
        }
        return true;
    }

    private static String leftTrim(String s) {
        StringBuffer sb = new StringBuffer();
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (sb.length() == 0 && Character.isWhitespace(chars[i])) continue;
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    private static StringBuffer rightTrim(StringBuffer sb) {
        int len = sb.length();
        if (len > 0) {
            for (int index = sb.length() - 1; index >= 0 && Character.isWhitespace(sb.charAt(index)); --index) {
                sb.deleteCharAt(index);
            }
        }
        return sb;
    }

    private static void walkDOMAndGatherText(Node node, List textList) {
        DomKit.walkDOMAndGatherImpl(node, textList, false);
    }

    private static void walkDOMAndGatherTextNodes(Node node, List textList) {
        DomKit.walkDOMAndGatherImpl(node, textList, true);
    }

    private static void walkDOMAndGatherImpl(Node node, List textList, boolean justNodes) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                Text textNode = (Text)child;
                if (justNodes) {
                    textList.add(textNode);
                } else {
                    String nodeText = textNode.getData();
                    textList.add(nodeText);
                }
            }
            if (child.getNodeType() != 1) continue;
            DomKit.walkDOMAndGatherImpl(child, textList, justNodes);
        }
    }

    public static String getInnerHTML(Node node) {
        StringBuffer sb = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nodeList.item(i);
            sb.append(DomKit.getHTML(child));
        }
        return sb.toString();
    }

    public static String getHTML(Node node) {
        StringBuffer sb = new StringBuffer();
        DomKit.useDOM(node, sb);
        return sb.toString();
    }

    private static void useDOM(Node node, StringBuffer sb) {
        new DomNodeOutputter(node, sb, false);
    }

    static void useSAX(Node node, StringBuffer sb) {
        try {
            DOMSource source = new DOMSource(node);
            SaxTagOutputter tagOutputter = new SaxTagOutputter(sb, false);
            SAXResult result = new SAXResult(tagOutputter);
            result.setLexicalHandler(tagOutputter);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("omit-xml-declaration", "yes");
            xformer.setOutputProperty("indent", "no");
            xformer.setOutputProperty("method", "html");
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e1) {
            throw new RuntimeException(e1);
        }
        catch (TransformerException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static Node copyDOM(Node srcNode, boolean convertTagsToLowerCase) {
        return new DomNodeCopier(srcNode, convertTagsToLowerCase).getCopiedNode();
    }

    public static Node betterNode(Node node) {
        return DomBetterNode.betterNode(node);
    }
}

