/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.suite.CategoryFilter;
import com.atlassian.jira.functest.framework.suite.SortByCategory;
import com.atlassian.jira.functest.framework.suite.SuiteTransform;
import com.atlassian.jira.functest.framework.suite.SystemPropertyBasedBatcherTransform;
import com.atlassian.jira.functest.framework.suite.TestOutputTransform;
import com.atlassian.jira.functest.framework.suite.TransformingParentRunner;
import com.atlassian.jira.functest.framework.suite.Transforms;
import com.atlassian.jira.functest.framework.suite.WebTestSuite;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import org.hamcrest.StringDescription;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runners.ParentRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public final class WebTestRunners {
    private WebTestRunners() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static <T> ParentRunner<T> newRunner(WebTestSuite suite, ParentRunner<T> runner, Predicate<Description> splittable) throws InitializationError {
        return new TransformingParentRunner<T>(WebTestRunners.nameOf(suite), runner, Lists.newArrayList((Object[])new SuiteTransform[]{Transforms.fromFilter(new CategoryFilter(suite.includes(), suite.excludes())), SortByCategory.INSTANCE, new SystemPropertyBasedBatcherTransform(splittable), new TestOutputTransform()}));
    }

    public static <T> ParentRunner<T> newRunner(WebTestSuite suite, ParentRunner<T> runner) throws InitializationError {
        return new TransformingParentRunner<T>(WebTestRunners.nameOf(suite), runner, Lists.newArrayList((Object[])new SuiteTransform[]{Transforms.fromFilter(new CategoryFilter(suite.includes(), suite.excludes())), SortByCategory.INSTANCE, new SystemPropertyBasedBatcherTransform(), new TestOutputTransform()}));
    }

    public static ParentRunner<Runner> newRunner(WebTestSuite suite, RunnerBuilder runnerBuilder, Predicate<Description> splittable, Class<?> ... classes) throws InitializationError {
        return WebTestRunners.newRunner(suite, new SuiteExt(runnerBuilder, classes), splittable);
    }

    public static ParentRunner<Runner> newRunner(WebTestSuite suite, RunnerBuilder runnerBuilder, Class<?> ... classes) throws InitializationError {
        return WebTestRunners.newRunner(suite, new SuiteExt(runnerBuilder, classes));
    }

    private static String nameOf(WebTestSuite suite) {
        return new StringDescription().appendText(suite.getClass().getName()).appendText("\n").appendText("package=").appendText(suite.webTestPackage()).appendText("\n").appendText("includes=").appendValue(suite.includes()).appendText("\n").appendText("excludes=").appendValue(suite.excludes()).toString();
    }

    private static final class SuiteExt
    extends Suite {
        SuiteExt(RunnerBuilder builder, Class<?>[] classes) throws InitializationError {
            super(builder, (Class[])classes);
        }
    }
}

