/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.log.FuncTestOut;
import com.atlassian.jira.functest.framework.suite.SuiteTransform;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.junit.runner.Description;

public class TestOutputTransform
implements SuiteTransform {
    private boolean hasRun = false;

    public Iterable<Description> apply(@Nullable Iterable<Description> input) {
        if (!this.hasRun) {
            this.outputTests(input);
            this.hasRun = true;
        }
        return input;
    }

    private void outputTests(Iterable<Description> descriptions) {
        List<Description> singleTests = this.getSingleTests(descriptions);
        FuncTestOut.log("***** Running " + singleTests.size() + " tests in total *****");
        for (Description singleTest : singleTests) {
            FuncTestOut.log(singleTest.getDisplayName());
        }
    }

    private List<Description> getSingleTests(Iterable<Description> input) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Description description : input) {
            if (description.isTest()) {
                builder.add((Object)description);
                continue;
            }
            builder.addAll(this.getSingleTests(description.getChildren()));
        }
        return builder.build();
    }
}

