/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.log.FuncTestOut;
import com.atlassian.jira.functest.framework.suite.BatcherTransform;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.junit.runner.Description;

public class SystemPropertyBasedBatcherTransform
extends BatcherTransform {
    private static final String BATCH_NUMBER_PROP = "atlassian.test.suite.batch";
    private static final String NUMBER_OF_BATCHES_PROP = "atlassian.test.suite.numbatches";
    private final Predicate<Description> splittable;
    private final int numberOfBatches;
    private final int batchNumber;

    public SystemPropertyBasedBatcherTransform() {
        this((Predicate<Description>)Predicates.alwaysTrue());
    }

    public SystemPropertyBasedBatcherTransform(Predicate<Description> splittable) {
        this.splittable = (Predicate)Preconditions.checkNotNull(splittable);
        this.batchNumber = this.getProperty(BATCH_NUMBER_PROP);
        this.numberOfBatches = this.getProperty(NUMBER_OF_BATCHES_PROP);
    }

    @Override
    protected int batchNumber() {
        return this.batchNumber;
    }

    @Override
    protected int numberOfBatches() {
        return this.numberOfBatches;
    }

    private int getProperty(String key) {
        Integer val = Integer.getInteger(key);
        if (val == null) {
            FuncTestOut.log("'" + key + "' is not specified or invalid");
            return -1;
        }
        return val;
    }

    @Override
    protected boolean isSplittable(Description classTestSuite) {
        return this.splittable.apply((Object)classTestSuite);
    }
}

