/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.FunctionalCategoryComparator;
import com.atlassian.jira.functest.framework.suite.SuiteTransform;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.junit.runner.Description;

public class SortByCategory
implements SuiteTransform {
    public static final SortByCategory INSTANCE = new SortByCategory();

    public Iterable<Description> apply(@Nullable Iterable<Description> input) {
        ArrayList answer = Lists.newArrayList();
        Collections.sort(answer, CategoryComparator.INSTANCE);
        return input;
    }

    private static class CategoryComparator
    implements Comparator<Description> {
        private static final CategoryComparator INSTANCE = new CategoryComparator();

        private CategoryComparator() {
        }

        @Override
        public int compare(Description first, Description second) {
            Category category1 = this.getCategory(first);
            Category category2 = this.getCategory(second);
            if (category1 == null && category2 == null) {
                return this.compareByName(first, second);
            }
            if (category1 == null) {
                return 1;
            }
            if (category2 == null) {
                return -1;
            }
            int result = category1.compareTo(category2);
            return result != 0 ? result : this.compareByName(first, second);
        }

        private Category getCategory(Description description) {
            WebTest webTest = (WebTest)description.getAnnotation(WebTest.class);
            if (webTest == null) {
                if (description.isTest()) {
                    return this.getCategory(Description.createSuiteDescription((Class)description.getTestClass()));
                }
                return null;
            }
            for (Category category : webTest.value()) {
                if (!FunctionalCategoryComparator.isFunctionalCategory(category)) continue;
                return category;
            }
            return null;
        }

        private int compareByName(Description one, Description two) {
            String className1 = one.getClassName();
            String className2 = two.getClassName();
            if (className1 == null && className2 == null) {
                return one.getDisplayName().compareTo(two.getDisplayName());
            }
            if (className1 == null) {
                return -1;
            }
            if (className2 == null) {
                return 1;
            }
            int result = className1.compareTo(className2);
            return result != 0 ? result : this.compareByMethodName(one, two);
        }

        private int compareByMethodName(Description one, Description two) {
            String method1 = one.getMethodName();
            String method2 = two.getMethodName();
            if (method1 == null && method2 == null) {
                return 0;
            }
            if (method1 == null) {
                return -1;
            }
            if (method2 == null) {
                return 1;
            }
            return method1.compareTo(method2);
        }
    }
}

