/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.Set;

public class FunctionalCategoryComparator
implements Comparator<Class<?>> {
    public static final FunctionalCategoryComparator INSTANCE = new FunctionalCategoryComparator();
    private static final Set<Category> FUNC_TEST_CATEGORIES = ImmutableSet.of((Object)((Object)Category.ADMINISTRATION), (Object)((Object)Category.APP_LINKS), (Object)((Object)Category.ATTACHMENTS), (Object)((Object)Category.BROWSE_PROJECT), (Object)((Object)Category.BROWSING), (Object)((Object)Category.BULK_OPERATIONS), (Object[])new Category[]{Category.CHARTING, Category.CLONE_ISSUE, Category.COMMENTS, Category.COMPONENTS_AND_VERSIONS, Category.CUSTOM_FIELDS, Category.DASHBOARDS, Category.EMAIL, Category.FIELDS, Category.FILTERS, Category.GADGETS, Category.HTTP, Category.I18N, Category.IMPORT_EXPORT, Category.INDEXING, Category.ISSUE_NAVIGATOR, Category.ISSUES, Category.JELLY, Category.JQL, Category.LDAP, Category.LICENSING, Category.MOVE_ISSUE, Category.PERMISSIONS, Category.RELOADABLE_PLUGINS, Category.PORTLETS, Category.PROJECT_IMPORT, Category.PROJECTS, Category.QUARTZ, Category.REPORTS, Category.REST, Category.ROLES, Category.SCHEMES, Category.SECURITY, Category.SETUP, Category.SUB_TASKS, Category.TIME_TRACKING, Category.UPGRADE_TASKS, Category.USERS_AND_GROUPS, Category.WORKFLOW, Category.WORKLOGS});

    public static boolean isFunctionalCategory(Category category) {
        return FUNC_TEST_CATEGORIES.contains((Object)category);
    }

    @Override
    public int compare(Class<?> test1, Class<?> test2) {
        Category category1 = this.getCategory(test1);
        Category category2 = this.getCategory(test2);
        if (category1 == null && category2 == null) {
            return this.compareByName(test1, test2);
        }
        if (category1 == null) {
            return 1;
        }
        if (category2 == null) {
            return -1;
        }
        int result = category1.compareTo(category2);
        return result != 0 ? result : this.compareByName(test1, test2);
    }

    private Category getCategory(Class<?> test1) {
        WebTest webTest = test1.getAnnotation(WebTest.class);
        if (webTest == null) {
            return null;
        }
        for (Category category : webTest.value()) {
            if (!FunctionalCategoryComparator.isFunctionalCategory(category)) continue;
            return category;
        }
        return null;
    }

    private int compareByName(Class<?> test1, Class<?> test2) {
        return test1.getSimpleName().compareTo(test2.getSimpleName());
    }
}

