/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.hamcrest.StringDescription;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public class CategoryFilter
extends Filter {
    private final Set<Category> included;
    private final Set<Category> excluded;

    public CategoryFilter(Set<Category> includedCategories, Set<Category> excludedCategories) {
        this.included = includedCategories.size() > 0 ? EnumSet.copyOf(includedCategories) : EnumSet.noneOf(Category.class);
        this.excluded = excludedCategories.size() > 0 ? EnumSet.copyOf(excludedCategories) : EnumSet.noneOf(Category.class);
    }

    public String describe() {
        return new StringDescription().appendText("Included categories ").appendValue(this.included).appendText("\nExcluded categories").appendValue(this.excluded).toString();
    }

    public boolean shouldRun(Description description) {
        if (this.hasCorrectCategoryAnnotation(description)) {
            return true;
        }
        for (Description each : description.getChildren()) {
            if (!this.shouldRun(each)) continue;
            return true;
        }
        return false;
    }

    private boolean hasCorrectCategoryAnnotation(Description description) {
        Set<Category> categories = this.categories(description);
        if (categories.isEmpty()) {
            return this.included == null;
        }
        for (Category each : categories) {
            if (this.excluded == null || !this.excluded.contains((Object)each)) continue;
            return false;
        }
        for (Category each : categories) {
            if (this.included != null && !this.included.contains((Object)each)) continue;
            return true;
        }
        return false;
    }

    private Set<Category> categories(Description description) {
        EnumSet<Category> answer = EnumSet.noneOf(Category.class);
        answer.addAll(this.directCategories(description));
        if (description.isTest()) {
            answer.addAll(this.directCategories(this.parentDescription(description)));
        }
        return answer;
    }

    private Description parentDescription(Description description) {
        return Description.createSuiteDescription((Class)description.getTestClass());
    }

    private Set<Category> directCategories(Description description) {
        WebTest annotation = (WebTest)description.getAnnotation(WebTest.class);
        if (annotation == null || annotation.value().length == 0) {
            return EnumSet.noneOf(Category.class);
        }
        return EnumSet.copyOf(Arrays.asList(annotation.value()));
    }
}

