/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public enum Category {
    FUNC_TEST,
    SELENIUM_TEST,
    WEBDRIVER_TEST,
    TPM,
    PLATFORM_COMPATIBILITY,
    VISUAL_REGRESSION,
    QUNIT,
    DEV_MODE,
    REFERENCE_PLUGIN,
    IGNITE,
    PERFORMANCE,
    RELOADABLE_PLUGINS,
    ACTIVITY_STREAMS,
    ADMINISTRATION,
    API,
    APP_LINKS,
    ATTACHMENTS,
    BROWSE_PROJECT,
    BROWSING,
    BULK_OPERATIONS,
    CHARTING,
    CLONE_ISSUE,
    COMMENTS,
    COMPONENTS_AND_VERSIONS,
    CUSTOM_FIELDS,
    DASHBOARDS,
    EMAIL,
    FIELDS,
    FILTERS,
    GADGETS,
    HTTP,
    I18N,
    IMPORT_EXPORT,
    INDEXING,
    ISSUE_NAVIGATOR,
    ISSUES,
    JELLY,
    JQL,
    LDAP,
    LICENSING,
    MOVE_ISSUE,
    PERMISSIONS,
    PLUGINS,
    PORTLETS,
    PROJECT_IMPORT,
    PROJECTS,
    QUARTZ,
    REPORTS,
    REST,
    ROLES,
    SCHEMES,
    SECURITY,
    SETUP,
    SUB_TASKS,
    TIME_TRACKING,
    TIME_ZONES,
    UPGRADE_TASKS,
    USERS_AND_GROUPS,
    WORKFLOW,
    WORKLOGS,
    CHANGE_HISTORY;


    public static Category forString(String constName) {
        Assertions.notBlank("constName", constName);
        for (Category category : Category.values()) {
            if (!category.name().equalsIgnoreCase(constName)) continue;
            return category;
        }
        throw new IllegalArgumentException("No corresponding Category constant for value \"" + constName + "\"");
    }

    public static Set<Category> fromAnnotation(WebTest webTest) {
        if (webTest == null || webTest.value().length == 0) {
            return EnumSet.noneOf(Category.class);
        }
        return EnumSet.copyOf(Arrays.asList(webTest.value()));
    }
}

