/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.log.FuncTestOut;
import com.atlassian.jira.functest.framework.suite.RunFirst;
import com.atlassian.jira.functest.framework.suite.SuiteTransform;
import com.atlassian.jira.functest.framework.util.junit.AnnotatedDescription;
import com.atlassian.jira.functest.framework.util.junit.DescriptionWalker;
import com.atlassian.jira.functest.framework.util.junit.JUnitPredicates;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.NotNull;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.hamcrest.StringDescription;
import org.junit.Ignore;
import org.junit.runner.Description;

public abstract class BatcherTransform
implements SuiteTransform {
    static final Predicate<Description> IS_RUN_FIRST = new Predicate<Description>(){

        public boolean apply(@Nullable Description input) {
            return new AnnotatedDescription(input).hasAnnotation(RunFirst.class);
        }
    };
    private boolean firstRun = true;
    private Iterable<TestWithParents> batch;

    public Iterable<Description> apply(@Nullable Iterable<Description> input) {
        if (this.batch != null) {
            return this.descriptionsMatchingBatch(input);
        }
        BatchValidator validator = new BatchValidator(this.batchNumber(), this.numberOfBatches());
        if (!validator.shouldBatch()) {
            if (this.firstRun) {
                FuncTestOut.log("***** Running in non-batched mode *****");
                this.firstRun = false;
            }
            return input;
        }
        Batcher batcher = new Batcher(this.batchNumber(), this.numberOfBatches(), input);
        this.batch = batcher.batch();
        if (this.firstRun) {
            FuncTestOut.log(String.format("***** Running batch %d of %d *****", batcher.batchNumber, batcher.numberOfBatches));
            this.firstRun = false;
        }
        return this.descriptionsMatchingBatch(input);
    }

    private Iterable<Description> descriptionsMatchingBatch(Iterable<Description> input) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        block0: for (TestWithParents batched : this.batch) {
            for (Description inputDescription : input) {
                if (!batched.matches(inputDescription)) continue;
                builder.add((Object)inputDescription);
                continue block0;
            }
        }
        return ImmutableList.copyOf((Collection)builder.build());
    }

    protected abstract int batchNumber();

    protected abstract int numberOfBatches();

    protected abstract boolean isSplittable(Description var1);

    private static class TestWithParents {
        public final Description test;
        public final List<Description> parents;

        TestWithParents(Description test, List<Description> parents) {
            this.test = test;
            this.parents = ImmutableList.copyOf(parents);
        }

        boolean matches(Description test) {
            return this.test.equals((Object)test) || this.parents.contains(test);
        }

        public Description directParent() {
            if (this.parents.size() > 0) {
                return this.parents.get(this.parents.size() - 1);
            }
            return null;
        }

        public String toString() {
            return new StringDescription().appendValue(this.test).appendText("\nParents:").appendValue(this.parents).toString();
        }
    }

    private class Batcher
    extends BatchManipulator {
        private final Iterable<Description> input;
        private final List<TestWithParents> singleTests;
        private final List<TestWithParents> runFirstTests;
        private int currentBatchSize;
        private int currentBatchNumber;
        private int currentTestIndex;
        private int currentRunFirstIndex;
        private int batchesLeft;
        private List<TestWithParents> currentBatch;
        private int testsInBatchLeft;

        public Batcher(int batchNumber, int numberOfBatches, Iterable<Description> input) {
            super(batchNumber, numberOfBatches);
            this.currentBatchNumber = 0;
            int runFirstCount = this.countRunFirst(input);
            Preconditions.checkState((runFirstCount <= numberOfBatches ? 1 : 0) != 0, (Object)("Too many RUN_FIRST tests <" + runFirstCount + ">, can only accomodate <" + numberOfBatches + ">"));
            this.input = input;
            this.singleTests = this.getSingleTests();
            this.runFirstTests = this.getRunFirstTests();
            this.currentTestIndex = 0;
        }

        private int countRunFirst(Iterable<Description> input) {
            final AtomicInteger count = new AtomicInteger();
            DescriptionWalker.walk(new Consumer<Description>(){

                @Override
                public void consume(@NotNull Description element) {
                    if (IS_RUN_FIRST.apply((Object)element)) {
                        count.incrementAndGet();
                    }
                }
            }, JUnitPredicates.isTest(), (Description[])Iterables.toArray(input, Description.class));
            return count.get();
        }

        private List<TestWithParents> getSingleTests() {
            return this.getMatchingTests((Predicate<Description>)Predicates.not(IS_RUN_FIRST));
        }

        private List<TestWithParents> getRunFirstTests() {
            return this.getMatchingTests(IS_RUN_FIRST);
        }

        private List<TestWithParents> getMatchingTests(Predicate<Description> matcher) {
            ArrayList answer = Lists.newArrayList();
            for (Description description : this.input) {
                answer.addAll(this.getTestsWithParents(description, Lists.newArrayList(), matcher));
            }
            return answer;
        }

        private List<TestWithParents> getTestsWithParents(Description test, List<Description> parents, Predicate<Description> included) {
            if (this.isSingleTestNotMatching(test, included) || this.isIgnored(test)) {
                return Collections.emptyList();
            }
            if (test.isTest()) {
                return ImmutableList.of((Object)new TestWithParents(test, (List<Description>)ImmutableList.copyOf(parents)));
            }
            ArrayList answer = Lists.newArrayList();
            ImmutableList newParents = ImmutableList.builder().addAll(parents).add((Object)test).build();
            for (Description child : test.getChildren()) {
                answer.addAll(this.getTestsWithParents(child, (List<Description>)newParents, included));
            }
            return answer;
        }

        private boolean isSingleTestNotMatching(Description test, Predicate<Description> included) {
            return test.isTest() && !included.apply((Object)test);
        }

        private boolean isIgnored(Description test) {
            return test.getAnnotation(Ignore.class) != null;
        }

        public List<TestWithParents> batch() {
            do {
                this.startBatch();
                while (this.isSpaceInBatch() && this.hasMoreMainTests()) {
                    this.addNext();
                }
            } while (this.currentBatchNumber < this.batchNumber);
            return this.currentBatch;
        }

        private void startBatch() {
            this.batchesLeft = this.numberOfBatches - this.currentBatchNumber;
            ++this.currentBatchNumber;
            this.testsInBatchLeft = this.currentBatchSize = this.computeBatchSize();
            this.currentBatch = Lists.newArrayList();
            if (this.isSpaceInBatch() && this.hasMoreRunFirstTests()) {
                this.addNextRunFirst();
            }
        }

        private boolean isSpaceInBatch() {
            return this.testsInBatchLeft > 0;
        }

        private boolean hasMoreTests() {
            return this.hasMoreMainTests() || this.hasMoreRunFirstTests();
        }

        private boolean hasMoreMainTests() {
            return this.currentTestIndex < this.singleTests.size();
        }

        private boolean hasMoreRunFirstTests() {
            return this.currentRunFirstIndex < this.runFirstTests.size();
        }

        private int testsLeft() {
            return this.mainTestsLeft() + this.runFirstTestsLeft();
        }

        private int mainTestsLeft() {
            return this.singleTests.size() - this.currentTestIndex;
        }

        private int runFirstTestsLeft() {
            return this.runFirstTests.size() - this.currentRunFirstIndex;
        }

        private TestWithParents current() {
            return this.singleTests.get(this.currentTestIndex);
        }

        private TestWithParents currentRunFirst() {
            return this.runFirstTests.get(this.currentRunFirstIndex);
        }

        private int computeBatchSize() {
            if (!this.hasMoreTests()) {
                return 0;
            }
            int size = this.testsLeft() / this.batchesLeft;
            if (this.testsLeft() % this.batchesLeft > 0) {
                ++size;
            }
            return size;
        }

        private void addNext() {
            if (!BatcherTransform.this.isSplittable(this.current().directParent())) {
                this.addNextClassSuite();
            } else {
                this.addNextSingleTest();
            }
        }

        private void addNextRunFirst() {
            this.currentBatch.add(this.currentRunFirst());
            --this.testsInBatchLeft;
            ++this.currentRunFirstIndex;
        }

        private void addNextClassSuite() {
            Description parent = this.current().directParent();
            while (this.hasMoreTests() && this.current().matches(parent)) {
                this.addNextSingleTest();
            }
        }

        private void addNextSingleTest() {
            this.currentBatch.add(this.current());
            --this.testsInBatchLeft;
            ++this.currentTestIndex;
        }
    }

    private static class BatchValidator
    extends BatchManipulator {
        public BatchValidator(int batchNumber, int numberOfBatches) {
            super(batchNumber, numberOfBatches);
        }

        boolean shouldBatch() {
            if (this.numberOfBatches <= 0) {
                return false;
            }
            Preconditions.checkState((this.batchNumber > 0 ? 1 : 0) != 0, (Object)("Batch number <" + this.batchNumber + "> must be greater than 0"));
            Preconditions.checkState((this.batchNumber <= this.numberOfBatches ? 1 : 0) != 0, (Object)("Batch number <" + this.batchNumber + "> must be greater than 0"));
            return true;
        }
    }

    private static abstract class BatchManipulator {
        protected final int batchNumber;
        protected final int numberOfBatches;

        public BatchManipulator(int batchNumber, int numberOfBatches) {
            this.batchNumber = batchNumber;
            this.numberOfBatches = numberOfBatches;
        }
    }
}

