/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.setup;

import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.FuncTestWebClientListener;
import com.atlassian.jira.functest.framework.log.FuncTestOut;
import com.atlassian.jira.functest.framework.util.text.MsgOfD;
import com.atlassian.jira.webtests.LicenseKeys;
import com.atlassian.jira.webtests.WebTesterFactory;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.util.TenantOverridingEnvironmentData;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebClientListener;
import com.meterware.httpunit.WebRequest;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.InputStream;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;

public class JiraSetupInstanceHelper {
    private static final String SYSTEM_TENANT_NAME = "_jiraSystemTenant";
    private final WebTester tester;
    private final JIRAEnvironmentData jiraEnvironmentData;

    public JiraSetupInstanceHelper(WebTester tester, JIRAEnvironmentData jiraEnvironmentData) {
        this.tester = tester;
        this.jiraEnvironmentData = jiraEnvironmentData;
    }

    public void ensureJIRAIsReadyToGo(FuncTestWebClientListener webClientListener) {
        FuncTestOut.log("Checking that JIRA is setup and ready to be tested...");
        if (!this.isSystemTenant()) {
            TenantOverridingEnvironmentData systemTenantEnvironmentData = new TenantOverridingEnvironmentData(SYSTEM_TENANT_NAME, this.jiraEnvironmentData);
            WebTester systemTester = WebTesterFactory.createNewWebTester(systemTenantEnvironmentData);
            JiraSetupInstanceHelper helper = new JiraSetupInstanceHelper(systemTester, systemTenantEnvironmentData);
            helper.ensureJiraTenantIsReadyToGo(webClientListener);
            if (!helper.isTenantProvisioned(this.jiraEnvironmentData.getTenant())) {
                helper.provisionTenant(this.jiraEnvironmentData.getTenant(), this.jiraEnvironmentData.shouldCreateDummyTenant());
                this.tester.getTestContext().getWebClient().clearCookies();
            }
        }
        this.ensureJiraTenantIsReadyToGo(webClientListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void ensureJiraTenantIsReadyToGo(FuncTestWebClientListener webClientListener) {
        if (!this.isJiraSetup(webClientListener)) {
            this.detectJohnson();
            Class<JiraSetupInstanceHelper> clazz = JiraSetupInstanceHelper.class;
            // MONITORENTER : com.atlassian.jira.functest.framework.setup.JiraSetupInstanceHelper.class
            if (this.isV1LicState()) {
                this.updateV1LicenseState(LicenseKeys.V2_COMMERCIAL);
            } else {
                this.setupJIRA();
            }
            // MONITOREXIT : clazz
        }
        this.login("admin", "admin");
        if (this.isSystemTenant()) {
            FuncTestOut.log("JIRA is setup and 'admin' is logged in. " + new MsgOfD());
            return;
        }
        FuncTestOut.log("JIRA tenant '" + this.jiraEnvironmentData.getTenant() + "' is setup and 'admin' is logged in. " + new MsgOfD());
    }

    private boolean isJiraSetup(FuncTestWebClientListener webClientListener) {
        this.tester.beginAt("/");
        this.tester.getDialog().getWebClient().addClientListener((WebClientListener)webClientListener);
        return this.hasBeenSetup();
    }

    private boolean isTenantProvisioned(String tenant) {
        this.tester.getTestContext().getWebClient().setExceptionsThrownOnErrorStatus(false);
        try {
            boolean bl = this.tester.getTestContext().getWebClient().getResponse(this.tester.getTestContext().getBaseUrl() + "multitenant/" + tenant).getResponseCode() == 200;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.tester.getTestContext().getWebClient().setExceptionsThrownOnErrorStatus(true);
        }
    }

    private boolean hasBeenSetup() {
        boolean hasBeenSetUp = (this.jiraEnvironmentData.getContext() + "/secure/Dashboard.jspa").equals(this.tester.getDialog().getResponse().getURL().getPath());
        return hasBeenSetUp;
    }

    private void detectJohnson() {
        String response = this.tester.getDialog().getResponseText();
        if (response.contains("JIRA Access Constraints")) {
            FuncTestOut.log("Test failed because we are getting the following johnson page:\n" + response);
            Assert.fail((String)"It appears that JIRA is currenty being Johnsoned.  That cant be good!");
        }
    }

    private void setupJIRA() {
        FuncTestOut.log("JIRA is not setup.  Installing a new V2 license and completing setup steps");
        try {
            if (!this.isDatabaseSetUp()) {
                this.setupDatabase();
            }
            this.blatInValidLicense(LicenseKeys.V2_COMMERCIAL, "Enterprise");
            if (!this.tester.getDialog().isTextInResponse("4 of 4")) {
                this.tester.assertTextPresent("3 of 4");
                this.setupJiraStep3("admin", "admin", "Administrator", "admin@stuff.com.com");
            }
            this.tester.assertTextPresent("4 of 4");
            this.setupJiraStep4();
            this.tester.assertTextPresent("Setup Complete");
        }
        catch (RuntimeException rte) {
            FuncTestOut.log("Unable to setup JIRA because of " + rte.getMessage());
            throw rte;
        }
    }

    private boolean isDatabaseSetUp() {
        boolean dbConfig = this.tester.getDialog().isTextInResponse("Database Configuration");
        boolean step1 = this.tester.getDialog().isTextInResponse("Step 1 of 4");
        return !dbConfig || !step1;
    }

    private void setupDatabase() {
        if (StringUtils.isNotEmpty((String)this.jiraEnvironmentData.getProperty("databaseType"))) {
            FuncTestOut.log("Setting up external db");
            JiraSetupInstanceHelper.setupDirectJDBCConnection(this.tester, this.jiraEnvironmentData);
        } else {
            FuncTestOut.log("Setting up internal db");
            this.tester.checkCheckbox("databaseOption", "INTERNAL");
            this.tester.submit("next");
        }
        Assert.assertTrue((String)this.tester.getDialog().getResponseText(), (boolean)this.tester.getDialog().getResponseText().contains("Step 2 of 4:"));
    }

    public static void setupDirectJDBCConnection(WebTester webTester, JIRAEnvironmentData environmentData) {
        webTester.checkCheckbox("databaseOption", "EXTERNAL");
        webTester.setFormElement("databaseType", environmentData.getProperty("databaseType"));
        webTester.setFormElement("jdbcHostname", environmentData.getProperty("db.host"));
        webTester.setFormElement("jdbcPort", environmentData.getProperty("db.port"));
        webTester.setFormElement("jdbcSid", environmentData.getProperty("db.instance"));
        webTester.setFormElement("jdbcDatabase", environmentData.getProperty("db.instance"));
        webTester.setFormElement("jdbcUsername", environmentData.getProperty("username"));
        webTester.setFormElement("jdbcPassword", environmentData.getProperty("password"));
        webTester.setFormElement("schemaName", environmentData.getProperty("schema-name"));
        webTester.submit();
    }

    private void setupJiraStep3(String username, String password, String fullName, String email) {
        this.tester.setFormElement("username", username);
        this.tester.setFormElement("password", password);
        this.tester.setFormElement("confirm", password);
        this.tester.setFormElement("fullname", fullName);
        this.tester.setFormElement("email", email);
        this.tester.submit();
    }

    private void setupJiraStep4() {
        this.tester.submit("finish");
    }

    private void blatInValidLicense(LicenseKeys.License licenseKey, String buildType) {
        this.logLicense(licenseKey);
        this.tester.setFormElement("license", licenseKey.getLicenseString());
        this.tester.submit();
        this.tester.assertTextNotPresent("Invalid license type for this edition of JIRA. License should be of type " + buildType + ".");
    }

    private void login(String username, String password) {
        this.tester.beginAt("/login.jsp");
        this.tester.setFormElement("os_username", username);
        this.tester.setFormElement("os_password", password);
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
    }

    private boolean isV1LicState() {
        String responseText = this.tester.getDialog().getResponseText();
        return responseText.contains("The current version of your license is incompatible with this JIRA installation.");
    }

    private void updateV1LicenseState(LicenseKeys.License licenseKey) {
        FuncTestOut.log("JIRA has data but it contains a V1 license.  Overwriting this with a V2 license");
        this.tester.gotoPage("secure/ConfirmInstallationWithLicense!default.jspa");
        this.tester.assertTextPresent("Confirm License Update");
        this.tester.setWorkingForm("jiraform");
        this.logLicense(licenseKey);
        this.tester.setFormElement("userName", "admin");
        this.tester.setFormElement("password", "admin");
        this.tester.setFormElement("license", licenseKey.getLicenseString());
        this.tester.submit();
        boolean hasRecovered = this.hasBeenSetup();
        if (!hasRecovered) {
            String message = "It was detected that a V1 license was presented in the data and we tried to upgrade it to V2 but failed";
            FuncTestOut.log("It was detected that a V1 license was presented in the data and we tried to upgrade it to V2 but failed");
            Assert.fail((String)"It was detected that a V1 license was presented in the data and we tried to upgrade it to V2 but failed");
        }
    }

    private void logLicense(LicenseKeys.License licenseKey) {
        FuncTestOut.log("Using a '" + licenseKey.getDescription() + "' license which allows " + licenseKey.getMaxUsers() + " maximum users");
    }

    private boolean isSystemTenant() {
        return StringUtils.isBlank((String)this.jiraEnvironmentData.getTenant()) || SYSTEM_TENANT_NAME.equals(this.jiraEnvironmentData.getTenant());
    }

    private void provisionTenant(String tenant, boolean createDummyTenant) {
        this.provisionTenant(tenant);
        if (createDummyTenant) {
            this.provisionTenant(tenant + "-dummy");
        }
    }

    private void provisionTenant(String tenant) {
        FuncTestOut.log("Provisioning Tenant " + tenant);
        File homeDirFile = new File(new FuncTestHelperFactory(this.tester, this.jiraEnvironmentData).getAdministration().getSystemTenantHomeDirectory(), "tenants/" + tenant);
        homeDirFile.mkdirs();
        File attachmentDir = new File(homeDirFile, "data/attachments");
        attachmentDir.mkdirs();
        String homedir = homeDirFile.getAbsolutePath();
        CharArrayWriter writer = new CharArrayWriter();
        writer.append("<tenant name=\"").append(tenant).append("\">\n");
        writer.append("  <hostnames>\n");
        writer.append("    <hostname>").append(tenant).append(".example.org</hostname>\n");
        writer.append("  </hostnames>\n");
        writer.append("  <homeDir>").append(homedir).append("</homeDir>\n");
        writer.append("  <database>\n");
        writer.append("    <name>").append(tenant).append("</name>\n");
        writer.append("    <database-type>hsql</database-type>\n");
        writer.append("    <schema-name>PUBLIC</schema-name>\n");
        writer.append("    <jdbc-datasource>\n");
        writer.append("      <url>jdbc:hsqldb:").append(homedir).append("/database</url>\n");
        writer.append("      <driver-class>org.hsqldb.jdbcDriver</driver-class>\n");
        writer.append("      <username>sa</username>\n");
        writer.append("      <password></password>\n");
        writer.append("      <pool-size>10</pool-size>\n");
        writer.append("    </jdbc-datasource>\n");
        writer.append("  </database>\n");
        writer.append("</tenant>\n");
        ByteArrayInputStream is = new ByteArrayInputStream(writer.toString().getBytes());
        PostMethodWebRequest request = new PostMethodWebRequest(this.tester.getTestContext().getBaseUrl() + "multitenant", (InputStream)is, "application/xml");
        try {
            this.tester.getTestContext().getWebClient().getResponse((WebRequest)request);
        }
        catch (Exception e) {
            throw new RuntimeException("Error provisioning tenant " + tenant, e);
        }
        FuncTestOut.log("Tenant " + tenant + " Provisioned.");
    }
}

