/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.parser.dashboard;

import com.atlassian.jira.functest.framework.parser.SharedEntityItem;
import com.atlassian.jira.functest.framework.parser.filter.WebTestSharePermission;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class DashboardItem
implements Cloneable,
SharedEntityItem {
    private long id;
    private String name;
    private String description;
    private String author;
    private long issues;
    private List sharing;
    private boolean fav;
    private long subscriptions;
    private List<String> operations = new ArrayList<String>();
    private long favCount;

    protected DashboardItem(long id, String name, String description, String author, long issues, List<WebTestSharePermission> sharing, Boolean fav, long subscriptions, List<String> operations, long favCount) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.author = author;
        this.issues = issues;
        this.sharing = sharing;
        this.fav = fav;
        this.subscriptions = subscriptions;
        if (operations != null) {
            this.operations = operations;
        }
        this.favCount = favCount;
    }

    public DashboardItem(DashboardItem copyFrom) {
        this(copyFrom.id, copyFrom.name, copyFrom.description, copyFrom.author, copyFrom.issues, copyFrom.sharing, copyFrom.fav, copyFrom.subscriptions, copyFrom.operations, copyFrom.favCount);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public Long getIssues() {
        return this.issues;
    }

    @Override
    public List getSharing() {
        return this.sharing;
    }

    @Override
    public Boolean isFav() {
        return this.fav;
    }

    @Override
    public Long getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    public List getOperations() {
        return this.operations;
    }

    @Override
    public Long getFavCount() {
        return this.favCount;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DashboardItem)) {
            return false;
        }
        DashboardItem rhs = (DashboardItem)obj;
        return new EqualsBuilder().append((Object)this.author, (Object)rhs.author).append((Object)this.description, (Object)rhs.description).append(this.fav, rhs.fav).append(this.favCount, rhs.favCount).append(this.id, rhs.id).append(this.issues, rhs.issues).append((Object)this.name, (Object)rhs.name).append(this.operations, rhs.operations).append((Object)this.sharing, (Object)rhs.sharing).append(this.subscriptions, rhs.subscriptions).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append(this.id).append((Object)this.name).append((Object)this.description).append((Object)this.author).append(this.issues).append((Object)this.sharing).append(this.fav).append(this.subscriptions).append(this.operations).append(this.favCount).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", this.id).append("name", (Object)this.name).append("author", (Object)this.author).append("fav", this.fav).append("favCount", this.favCount).append("description", (Object)this.description).append("issues", this.issues).append("sharing", (Object)this.sharing).append("subscriptions", this.subscriptions).append("operations", this.operations).toString();
    }

    public DashboardItem cloneFilter() {
        try {
            return (DashboardItem)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private long id;
        private String name = "";
        private String owner = "";
        private boolean isFavourite = false;
        private int favouriteCount;
        private int issueCount;
        private String description = "";
        private int subscriptionCount;
        private List<String> availableOperations = Lists.newArrayList();
        private List<WebTestSharePermission> sharePermissions = Lists.newArrayList();

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder name(String filterName) {
            this.name = filterName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder asFavourite() {
            this.isFavourite = true;
            return this;
        }

        public Builder favouriteCount(int favouriteCount) {
            this.favouriteCount = favouriteCount;
            return this;
        }

        public Builder sharedWith(List<WebTestSharePermission> sharePermissions) {
            this.sharePermissions = sharePermissions;
            return this;
        }

        public Builder issueCount(int issueCount) {
            this.issueCount = issueCount;
            return this;
        }

        public Builder subscriptionCount(int subscriptionCount) {
            this.subscriptionCount = subscriptionCount;
            return this;
        }

        public Builder availableOperations(List<String> availableOperations) {
            this.availableOperations = availableOperations;
            return this;
        }

        public DashboardItem build() {
            return new DashboardItem(this.id, this.name, this.description, this.owner, this.issueCount, this.sharePermissions, this.isFavourite, this.subscriptionCount, this.availableOperations, this.favouriteCount);
        }
    }
}

