/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigator;

import com.atlassian.jira.functest.framework.navigator.NavigatorCondition;
import com.meterware.httpunit.WebForm;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import net.sourceforge.jwebunit.HttpUnitDialog;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;

public abstract class MultiSelectCondition
implements NavigatorCondition {
    private Set<String> options = new HashSet<String>();
    private final String elementName;

    protected MultiSelectCondition(String elementName) {
        this.elementName = elementName;
    }

    protected MultiSelectCondition(String elementName, Collection<String> options) {
        this(elementName);
        this.addOptions(options);
    }

    protected MultiSelectCondition(MultiSelectCondition condition) {
        this(condition.elementName, condition.options);
    }

    public void setOptions(Collection<String> options) {
        this.options = options == null ? new HashSet<String>() : new HashSet<String>(options);
    }

    public boolean addOption(String option) {
        return option != null && this.options.add(option);
    }

    public boolean removeOption(String option) {
        return option != null && this.options.remove(option);
    }

    public void clearOptions() {
        this.options.clear();
    }

    public void addOptions(Collection<String> options) {
        if (options != null) {
            this.options.addAll(options);
        }
    }

    public void removeOptions(Collection<String> options) {
        if (options != null) {
            this.options.removeAll(options);
        }
    }

    public Set<String> getOptions() {
        return Collections.unmodifiableSet(this.options);
    }

    public String getElementName() {
        return this.elementName;
    }

    @Override
    public void setForm(WebTester tester) {
        HttpUnitDialog dialog = tester.getDialog();
        WebForm form = dialog.getForm();
        if (!this.options.isEmpty()) {
            String[] values = new String[this.options.size()];
            int position = 0;
            for (String type : this.options) {
                values[position] = dialog.getValueForOption(this.elementName, type);
                ++position;
            }
            form.setParameter(this.elementName, values);
        } else {
            form.setParameter(this.elementName, new String[0]);
        }
    }

    @Override
    public void parseCondition(WebTester tester) {
        WebForm form = tester.getDialog().getForm();
        this.setOptions(this.getSetOptions(form));
    }

    private Set<String> getSetOptions(WebForm form) {
        String[] options = form.getOptions(this.elementName);
        String[] optionValues = form.getOptionValues(this.elementName);
        String[] values = form.getParameterValues(this.elementName);
        HashSet<String> actualOptions = new HashSet<String>();
        for (String value : values) {
            if (!StringUtils.isNotBlank((String)value)) continue;
            for (int j = 0; j < optionValues.length; ++j) {
                if (!optionValues[j].equals(value)) continue;
                actualOptions.add(options[j]);
            }
        }
        return actualOptions;
    }

    @Override
    public void assertSettings(WebTester tester) {
        WebForm form = tester.getDialog().getForm();
        Assert.assertEquals((String)("Options not set correctly for element: " + this.elementName), this.options, this.getSetOptions(form));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiSelectCondition that = (MultiSelectCondition)o;
        if (this.elementName != null ? !this.elementName.equals(that.elementName) : that.elementName != null) {
            return false;
        }
        return !(this.options != null ? !((Object)this.options).equals(that.options) : that.options != null);
    }

    public int hashCode() {
        int result = this.options != null ? ((Object)this.options).hashCode() : 0;
        result = 31 * result + (this.elementName != null ? this.elementName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MultiSelectCondition{elementName='" + this.elementName + '\'' + ", options=" + this.options + '}';
    }
}

