/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation;

import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;

public abstract class AbstractBulkChangeWizard
implements BulkChangeWizard {
    protected static final String SAME_FOR_ALL = "sameAsBulkEditBean";
    protected static final String BULK_EDIT_KEY = "10000_1_";
    protected static final String TARGET_PROJECT_ID = "10000_1_pid";
    private BulkChangeWizard.WizardState state = BulkChangeWizard.WizardState.SELECT_ISSUES;
    private BulkChangeWizard.BulkOperations operation = null;

    @Override
    public BulkChangeWizard selectAllIssues() {
        this.validateState(BulkChangeWizard.WizardState.SELECT_ISSUES);
        this.selectAllIssueCheckboxes();
        this.clickOnNext();
        this.state = BulkChangeWizard.WizardState.CHOOSE_OPERATION;
        return this;
    }

    @Override
    public BulkChangeWizard chooseOperation(BulkChangeWizard.BulkOperations operation) {
        this.validateState(BulkChangeWizard.WizardState.CHOOSE_OPERATION);
        this.chooseOperationRadioButton(operation);
        this.clickOnNext();
        this.operation = operation;
        switch (operation) {
            case MOVE: {
                this.state = BulkChangeWizard.WizardState.CHOOSE_TARGET_CONTEXTS;
                break;
            }
            case EDIT: {
                this.state = BulkChangeWizard.WizardState.SET_FIELDS;
            }
        }
        return this;
    }

    @Override
    public BulkChangeWizard chooseTargetContextForAll(String projectName) {
        this.validateState(BulkChangeWizard.BulkOperations.MOVE, BulkChangeWizard.WizardState.CHOOSE_TARGET_CONTEXTS);
        this.checkSameTargetForAllCheckbox();
        this.selectFirstTargetProject(projectName);
        this.clickOnNext();
        this.state = BulkChangeWizard.WizardState.SET_FIELDS;
        return this;
    }

    @Override
    public BulkChangeWizard setFieldValue(String fieldName, String value) {
        return this.setFieldValue(BulkChangeWizard.InputTypes.TEXT, fieldName, value);
    }

    @Override
    public BulkChangeWizard setFieldValue(BulkChangeWizard.InputTypes inputType, String fieldName, String value) {
        this.validateState(BulkChangeWizard.WizardState.SET_FIELDS);
        switch (inputType) {
            case SELECT: {
                this.setSelectElement(fieldName, value);
                break;
            }
            default: {
                this.setTextElement(fieldName, value);
            }
        }
        return this;
    }

    @Override
    public BulkChangeWizard checkRetainForField(String fieldName) {
        this.validateState(BulkChangeWizard.BulkOperations.MOVE, BulkChangeWizard.WizardState.SET_FIELDS);
        this.checkCheckbox("retain_" + fieldName);
        return this;
    }

    @Override
    public BulkChangeWizard checkActionForField(String fieldName) {
        this.validateState(BulkChangeWizard.BulkOperations.EDIT, BulkChangeWizard.WizardState.SET_FIELDS);
        this.checkCheckbox("actions", fieldName);
        return this;
    }

    @Override
    public BulkChangeWizard finaliseFields() {
        this.validateState(BulkChangeWizard.WizardState.SET_FIELDS);
        this.clickOnNext();
        if (this.operation == BulkChangeWizard.BulkOperations.MOVE) {
            if (!this.pageContainsText("Update the fields for the new issues.")) {
                this.state = BulkChangeWizard.WizardState.CONFIRMATION;
            }
        } else if (this.operation == BulkChangeWizard.BulkOperations.EDIT && this.pageContainsText("Please confirm that the correct issues and changes have been entered")) {
            this.state = BulkChangeWizard.WizardState.CONFIRMATION;
        }
        return this;
    }

    @Override
    public BulkChangeWizard complete() {
        this.validateState(BulkChangeWizard.WizardState.CONFIRMATION);
        if (this.operation == BulkChangeWizard.BulkOperations.MOVE) {
            this.clickOnNext();
        } else if (this.operation == BulkChangeWizard.BulkOperations.EDIT) {
            this.clickOnConfirm();
        }
        this.state = BulkChangeWizard.WizardState.COMPLETE;
        return this;
    }

    protected abstract void clickOnNext();

    protected abstract void clickOnConfirm();

    protected abstract void selectAllIssueCheckboxes();

    protected abstract void chooseOperationRadioButton(BulkChangeWizard.BulkOperations var1);

    protected abstract void selectFirstTargetProject(String var1);

    protected abstract void checkSameTargetForAllCheckbox();

    protected abstract void setTextElement(String var1, String var2);

    protected abstract void setSelectElement(String var1, String var2);

    protected abstract void checkCheckbox(String var1);

    protected abstract void checkCheckbox(String var1, String var2);

    protected abstract boolean pageContainsText(String var1);

    private void validateState(BulkChangeWizard.WizardState expectedState) {
        if (this.state != expectedState || this.state == BulkChangeWizard.WizardState.COMPLETE) {
            throw new IllegalStateException("Wizard is in invalid state. Expected state: " + (Object)((Object)expectedState) + "; actual state: " + this.state.toString());
        }
    }

    private void validateState(BulkChangeWizard.BulkOperations expectedOperation, BulkChangeWizard.WizardState expectedState) {
        if (this.operation != expectedOperation) {
            throw new IllegalStateException("Wizard is in invalid state. Expected operation: " + (Object)((Object)expectedOperation) + "; actual operation: " + expectedOperation.toString());
        }
        this.validateState(expectedState);
    }
}

