/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.log;

import com.atlassian.jira.functest.framework.log.FuncTestLoggerImpl;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class FuncTestOut {
    public static final PrintStream out = new PrintStream(new EnvironmentDetectingPrintStream("JiraFuncTests.out.log", System.out));
    public static final PrintStream err = new PrintStream(new EnvironmentDetectingPrintStream("JiraFuncTests.err.log", System.err));

    public static void log(Object logData) {
        FuncTestLoggerImpl.logIndented(logData);
    }

    public static void log(int indentLevel, Object logData) {
        FuncTestLoggerImpl.logIndented(indentLevel, logData);
    }

    private static class EnvironmentDetectingPrintStream
    extends OutputStream {
        private final OutputStream fileOutputStream;
        private final PrintStream systemPrintStream;

        private EnvironmentDetectingPrintStream(String fileName, PrintStream systemPrintStream) {
            FileOutputStream fileOut;
            String targetFileName = EnvironmentUtils.getMavenAwareOutputDir() + File.separator + fileName;
            try {
                fileOut = new FileOutputStream(targetFileName, false);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(System.err);
                fileOut = null;
            }
            this.fileOutputStream = fileOut;
            this.systemPrintStream = systemPrintStream;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.fileOutputStream != null) {
                this.fileOutputStream.write(b, off, len);
            }
            this.systemPrintStream.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (this.fileOutputStream != null) {
                this.fileOutputStream.write(b);
            }
            this.systemPrintStream.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            if (this.fileOutputStream != null) {
                this.fileOutputStream.write(b);
            }
            this.systemPrintStream.write(b);
        }

        @Override
        public void flush() throws IOException {
            if (this.fileOutputStream != null) {
                this.fileOutputStream.flush();
            }
            this.systemPrintStream.flush();
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.fileOutputStream != null) {
                this.fileOutputStream.close();
            }
        }
    }
}

