/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.locator;

import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.LocatorEntry;
import com.atlassian.jira.functest.framework.locator.LocatorIterator;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.functest.framework.util.dom.SneakyDomExtractor;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.meterware.httpunit.WebResponse;
import java.util.Iterator;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractLocator
implements Locator {
    protected WebTester tester;
    protected WebResponse originalWebResponse;
    protected Node[] nodes;

    protected AbstractLocator() {
        this.nodes = null;
    }

    protected AbstractLocator(WebTester tester) {
        if (tester == null) {
            throw new IllegalArgumentException("The WebTester must not be null");
        }
        this.tester = tester;
        this.nodes = null;
    }

    protected Node betterNode(Node node) {
        return DomKit.betterNode(node);
    }

    @Override
    public boolean exists() {
        return this.getNodes().length > 0;
    }

    @Override
    public Node getNode() {
        Node[] nodes = this.getNodes();
        if (nodes.length == 0) {
            return null;
        }
        return this.betterNode(nodes[0]);
    }

    @Override
    public Iterator<LocatorEntry> iterator() {
        return new LocatorIterator(this);
    }

    @Override
    public Iterable<LocatorEntry> allMatches() {
        return CollectionUtil.toList(this.iterator());
    }

    @Override
    public boolean hasNodes() {
        return this.getNodes().length > 0;
    }

    protected Document getDOM(WebTester tester) {
        return SneakyDomExtractor.getDOM(tester);
    }

    @Override
    public String getText() {
        return this.getNodesTextImpl(this.getNodes(), LocatorTextOperation.COLLAPSED_TEXT);
    }

    @Override
    public String getText(Node node) {
        return this.getNodeTextImpl(node, LocatorTextOperation.COLLAPSED_TEXT);
    }

    @Override
    public String getRawText() {
        return this.getNodesTextImpl(this.getNodes(), LocatorTextOperation.RAW_TEXT);
    }

    @Override
    public String getRawText(Node node) {
        return this.getNodeTextImpl(node, LocatorTextOperation.RAW_TEXT);
    }

    @Override
    public String getHTML() {
        return this.getNodesTextImpl(this.getNodes(), LocatorTextOperation.HTML_TEXT);
    }

    @Override
    public String getHTML(Node node) {
        return this.getNodeTextImpl(node, LocatorTextOperation.HTML_TEXT);
    }

    protected String getNodeTextImpl(Node node, LocatorTextOperation textOperation) {
        if (!AbstractLocator.containsNode(this, node)) {
            throw new IllegalArgumentException("The node provided must be one contained in a call to Locator.getNodes()");
        }
        if (textOperation == LocatorTextOperation.HTML_TEXT) {
            return DomKit.getHTML(node);
        }
        if (textOperation == LocatorTextOperation.RAW_TEXT) {
            return DomKit.getRawText(node);
        }
        return DomKit.getCollapsedText(node);
    }

    protected String getNodesTextImpl(Node[] nodes, LocatorTextOperation textOperation) {
        StringBuffer sb = new StringBuffer();
        for (Node node : nodes) {
            sb.append(this.getNodeTextImpl(node, textOperation));
        }
        return sb.toString();
    }

    protected static boolean containsNode(Locator locator, Node node) {
        Node[] nodes = locator.getNodes();
        boolean found = false;
        for (Node node1 : nodes) {
            if (node1 != node) continue;
            found = true;
            break;
        }
        return found;
    }

    protected WebResponse getWebResponse(WebTester tester) {
        WebResponse webResponse = null;
        if (tester.getDialog() != null) {
            webResponse = tester.getDialog().getResponse();
        }
        return webResponse;
    }

    protected synchronized String toStringImpl(String concreteImplementationName) {
        StringBuffer sb = new StringBuffer(concreteImplementationName);
        sb.append(" : ");
        if (this.nodes != null) {
            sb.append(this.nodes.length);
            sb.append(" node(s)");
            String text = this.getText();
            if (text != null) {
                text = StringUtils.abbreviate((String)text, (int)40);
            }
            sb.append(" - '").append(text).append("'");
        }
        return sb.toString();
    }

    protected static interface LocatorTextOperation {
        public static final LocatorTextOperation COLLAPSED_TEXT = new LocatorTextOperation(){};
        public static final LocatorTextOperation RAW_TEXT = new LocatorTextOperation(){};
        public static final LocatorTextOperation HTML_TEXT = new LocatorTextOperation(){};
    }
}

